import req from '@/request'

const portal = window.context.portal

// 事故统计
export function accidentStatistics(data) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/statsReport/v1/eventNum`, data)
      .then(res => resolve(res?.data || []))
      .catch(err => reject(err))
  })
}

// 突发事件统计
export function emergencyStatistics(data) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/statsReport/v1/otEventNum`, data)
      .then(res => resolve(res?.data || []))
      .catch(err => reject(err))
  })
}

// 巡查救援统计
export function patrolAndRescueStatistics(data) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/statsReport/v1/taskLedgerNum`, data)
      .then(res => resolve(res?.data || []))
      .catch(err => reject(err))
  })
}

// 交通拥堵统计
export function trafficCongestionStatistics(data) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/statsReport/v1/trafficCongestionNum`, data)
      .then(res => resolve(res?.data || []))
      .catch(err => reject(err))
  })
}

// 交通管制统计
export function trafficControlStatistics(data) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/statsReport/v1/trafficControlNum`, data)
      .then(res => resolve(res?.data || []))
      .catch(err => reject(err))
  })
}

export function getTree() {
  return new Promise((resolve, reject) => {
    req.get(portal + `/uc/org/roadTree`)
      .then(res => resolve(res?.data || []))
      .catch(err => reject(err))
  })
}

// 明细导出(事故统计)
export function exportDataFileEventNum(data) {
  return new Promise((resolve, reject) => {
    req.downloadPostCopy(portal + `/statsReport/v1/eventNum/export`, data)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 明细导出(突发事件统计)
export function exportDataFileOtEventNum(data) {
  return new Promise((resolve, reject) => {
    req.downloadPostCopy(portal + `/statsReport/v1/otEventNum/export`, data)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 明细导出(交通管制统计)
export function exportDataFileTraffic(data) {
  return new Promise((resolve, reject) => {
    req.downloadPostCopy(portal + `/statsReport/v1/trafficControlNum/export`, data)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 明细导出(巡查救援统计)
export function exportDataFileTaskLedgerNum(data) {
  return new Promise((resolve, reject) => {
    req.downloadPostCopy(portal + `/statsReport/v1/taskLedgerNum/export`, data)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 明细导出(交通拥堵统计)
export function exportDataFile(data) {
  return new Promise((resolve, reject) => {
    req.downloadPostCopy(portal + `/statsReport/v1/trafficCongestionNum/export`, data)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}
