import req from '@/request'
import qs from 'qs'

const portal = window.context.portal

// 表格分页
export function tableData() {
    return new Promise((resolve, reject) => {
        req.get(portal + `/biz/trainTask/study/preStudyList`)
            .then(res => resolve(res?.data?.value || []))
            .catch(err => reject(err))
    })
}

// 获取学习资料
export function getStudyFiles(studyId) {
    return new Promise((resolve, reject) => {
        req.get(portal + `/biz/trainTask/study/getStudyFiles/${studyId}`)
            .then(res => resolve(res?.data?.value || []))
            .catch(err => reject(err))
    })
}

// 资料学习
export function dataStudy(data) {
    return new Promise((resolve, reject) => {
        req.post(portal + `/biz/trainTask/study/dataStudy`, data)
            .then(res => resolve(res?.data || {}))
            .catch(err => reject(err))
    })
}

// 岗前学习任务签到
export function sign(studyLogId) {
    return new Promise((resolve, reject) => {
        req.get(portal + `/biz/trainTask/study/sign/${studyLogId}`)
            .then(res => resolve(res?.data || {}))
            .catch(err => reject(err))
    })
}




