import req from '@/request'
import qs from 'qs'

const portal = window.context.portal

// 表格分页
export function tableData(data) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/exam/user/record/myPaperTask`, data)
      .then(res => resolve(res?.data || []))
      .catch(err => reject(err))
  })
}

// 开始考试-试卷分数信息
export function paperPointOut(recordId) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/exam/user/record/paperPointOut`, {recordId})
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 试卷数据（进入我的考试）
export function startExam(recordId) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/exam/user/record/startExam`, {recordId})
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 提交答卷
export function submitAnswer(data) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/exam/user/record/submitAnswer`, data)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 答题结果
export function paperResult(data) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/exam/user/record/paperResult`, data)
      .then(res => resolve(res?.data?.value || {}))
      .catch(err => reject(err))
  })
}

// 答卷记录
export function getUserRecord(id) {
  return new Promise((resolve, reject) => {
    req.get(portal + `/exam/user/record/getUserRecord/${id}`)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}



