import req from '@/request'

const portal = window.context.portal

// 表格分页
export function tableData(data) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/biz/train/task/query`, data)
      .then(res => resolve(res?.data || []))
      .catch(err => reject(err))
  })
}

// 表格详情
export function finishTask(taskId) {
  return new Promise((resolve, reject) => {
    req.get(portal + `/biz/train/task/finishTask?taskId=${taskId}`)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 表格删除
export function tableDelete(id) {
  return new Promise((resolve, reject) => {
    req.remove(portal + `/biz/train/task/${id}`)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}




