import req from '@/request'
const portal = window.context.portal
const headers = {
    'Content-type': 'application/x-www-form-urlencoded'
}
export default {
    //分页查询 我的问卷
    queryData(data, cb) {
        req.post(portal + `/exam/user/record/myPaper`, data).then(res => {
            cb(res.data)
        })
    },
    //我的问卷调查封面
    getCoverInfo(id, cb) {
        req.get(portal + `/exam/user/record/getTaskInfo/${id}`).then(res => {
            cb(res.data)
        })
    },
    //开始考试-进入我的试卷开始答题
    getExamination(data, cb) {
        req.post(portal + `/exam/user/record/startExam`, data).then(res => {
            cb(res.data)
        })
    },
    //提交答卷
    submitTest(data, cb) {
        req.post(portal + `/exam/user/record/submitAnswer`, data).then(res => {
            cb(res.data)
        })
    },
    //预览答卷
    previewTest(data, cb) {
        req.get(portal + `/exam/paper/base/viewPaper/${data.id}`, data).then(res => {
            cb(res.data)
        })
    }
}
