import req from '@/request'

const portal = window.context.portal

// 表格分页
export function tableData(data) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/monitor/bizEarlyWarningManagement/v1/query`, data)
      .then(res => resolve(res?.data || []))
      .catch(err => reject(err))
  })
}

// 新增
export function tableAdd(data) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/monitor/bizEarlyWarningManagement/v1/publish`, data)
      .then(res => resolve(res?.data || []))
      .catch(err => reject(err))
  })
}

// 修改
export function tableEdit(data) {
  return new Promise((resolve, reject) => {
    req.put(portal + `/monitor/bizEarlyWarningManagement/v1/`, data)
      .then(res => resolve(res?.data || []))
      .catch(err => reject(err))
  })
}

// 表格详情
export function tableDetail(id) {
  return new Promise((resolve, reject) => {
    req.get(portal + `/monitor/bizEarlyWarningManagement/v1/${id}`)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 表格删除
export function tableDelete(ids) {
  let param = ''
  if (ids.indexOf(',') === -1) {
    param = `ids=${ids}`
  } else {
    const idArray = ids.split(',')
    param = idArray.map(id => `ids=${id}`).join('&')
  }
  return new Promise((resolve, reject) => {
    req.remove(portal + `/monitor/bizEarlyWarningManagement/v1/?${param}`)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 模板下载
export function downloadModel() {
  return new Promise((resolve, reject) => {
    req.download(portal + `/monitor/bizEarlyWarningManagement/v1/downloadMainTempFile`)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 导出
export function exportFile(data) {
  return new Promise((resolve, reject) => {
    req.downloadPostCopy(portal + `/monitor/bizEarlyWarningManagement/v1/exportExcel?code=sc`, data)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 根据路段获取区域
export function getRegionalData(id) {
  return new Promise((resolve, reject) => {
    req.get(portal + `/monitor/bizEarlyWarningManagement/v1/regional?roadId=${id}`)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

export function bhConfirmation(data) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/monitor/bizEarlyWarningManagement/v1/bhConfirmation`, data)
      .then(res => resolve(res?.data || []))
      .catch(err => reject(err))
  })
}