import req from '@/request'

const portal = window.context.portal

// 个人学习情况 统计
export function paperAnalysis() {
    return new Promise((resolve, reject) => {
        req.post(portal + `/eduAndTrain/main/paperAnalysis`)
            .then(res => resolve(res?.data?.value || {}))
            .catch(err => reject(err))
    })
}

// 获取我的新人学习课程
export function freshmanStudyTask() {
    return new Promise((resolve, reject) => {
        req.get(portal + `/biz/trainTask/study/freshmanStudyList`)
            .then(res => resolve(res?.data?.value || ''))
            .catch(err => reject(err))
    })
}

//新人三级培训目录树
export function newStudyTypeTree(taskId) {
    return new Promise((resolve, reject) => {
        req.get(portal + `/bizStudyLog/v1/getTree/` + taskId)
            .then(res => resolve(res?.data?.value || []))
            .catch(err => reject(err))
    })
}

// 获取我的最新学习课程
export function myCourse() {
    return new Promise((resolve, reject) => {
        req.post(portal + `/biz/trainTask/study/myCourse`)
            .then(res => resolve(res?.data || {}))
            .catch(err => reject(err))
    })
}

// 学习资料清单
export function listOfLearningMaterials(data = {}) {
    return new Promise((resolve, reject) => {
        req.post(portal + `/biz/trainTask/study/myCourse`, data)
            .then(res => resolve(res?.data || {}))
            .catch(err => reject(err))
    })
}

// 获取我的新人学习课程
export function preStudyStatus() {
    return new Promise((resolve, reject) => {
        req.get(portal + `/biz/trainTask/study/preStudyStatus`)
            .then(res => resolve(res?.data || {}))
            .catch(err => reject(err))
    })
}


