import req from '@/request'

const portal = window.context.portal

// 表格分页
export function tableData(data) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/biz/trainTask/conf/query`, data)
      .then(res => resolve(res?.data || []))
      .catch(err => reject(err))
  })
}

// 表格详情
export function tableDetail(id) {
  return new Promise((resolve, reject) => {
    req.get(portal + `/biz/trainTask/conf/${id}`)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 表格新增
export function tableAdd(data) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/biz/trainTask/conf/saveOrUpdate`, data)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 表格删除
export function tableDelete(ids) {
  return new Promise((resolve, reject) => {
    req.remove(portal + `/biz/trainTask/conf/?ids=${ids}`)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 表格修改
export function tableEdit(data) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/biz/trainTask/conf/saveOrUpdate`, data)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 执行培训配置
export function executeJob(id) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/biz/trainTask/conf/executeJob?id=${id}`)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 启用或停止培训配置
export function toggleTriggerRun(id) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/biz/trainTask/conf/toggleTriggerRun?id=${id}`)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 根据专题id查询专题资料
export function resultDataFindById(topicId) {
  return new Promise((resolve, reject) => {
    req.get(portal + `/biz/special/resultData/findById/${topicId}`)
      .then(res => resolve(res?.data || []))
      .catch(err => reject(err))
  })
}


