package com.artfess.base.feign;

import com.alibaba.fastjson.JSONObject;
import com.artfess.base.conf.FeignConfig;
import com.artfess.base.feign.impl.UCFeignServiceFactory;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.QueryFilter;
import com.artfess.uc.api.model.Group;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.gson.JsonObject;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * @author liyg
 */
@FeignClient(name = "bpm-uc", fallbackFactory = UCFeignServiceFactory.class, configuration = FeignConfig.class, primary = false)
public interface UCFeignService {

    /**
     * 启动或登录验证系统版权信息
     *
     * @return
     */
    @RequestMapping(value = "/uc/AuthorizationModel/v1/checkSystemAuthorization", method = RequestMethod.POST)
    JsonNode checkSysAuthorization();

    /**
     * 系统启动的时候默认生成一个临时授权文件
     *
     * @return
     */
    @RequestMapping(value = "/uc/AuthorizationModel/v1/systemStartCreateFile", method = RequestMethod.POST)
    void systemStartCreateFile();

    /**
     * 根据用户账号获取用户信息
     *
     * @param account
     * @return
     */
    @RequestMapping(value = "/api/user/v1/user/loadUserByUsername", method = RequestMethod.POST)
    JsonNode loadUserByUsername(@RequestParam(value = "account", required = true) String account);

    @RequestMapping(value = "/api/user/v1/users/getAllUser", method = RequestMethod.GET)
    JsonNode getAllUser();

    @RequestMapping(value = "/api/org/v1/org/getTeam", method = RequestMethod.GET)
    JSONObject getTeam(@RequestParam(value = "id", required = true)String id);

    /**
     * 根据用户id获取用户信息
     */
    @RequestMapping(value = "/api/user/v1/user/getUserById", method = RequestMethod.GET)
    CommonResult<JsonNode> getUserById(@RequestParam(value = "userId", required = true) String userId);

    /**
     * 获取用户信息
     *
     * @param account
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/api/user/v1/user/getUser", method = RequestMethod.GET)
    JsonNode getUser(@RequestParam(value = "account", required = true) String account, @RequestParam(value = "userNumber", required = false) String userNumber);

    /**
     * 根据多个用户账号获取用户信息(以逗号隔开)
     */
    @RequestMapping(value = "/api/user/v1/user/getUserByAccounts", method = RequestMethod.GET)
    ArrayNode getUserByAccounts(@RequestParam(value = "accounts", required = true) String accounts);

    @RequestMapping(value = "/api/user/v1/users/postUserByAccount", method = RequestMethod.GET)
    CommonResult<String> postUserByAccount(@RequestParam(value = "account", required = true) String accounts, @RequestParam(value = "openid", required = true) String openid);

    /**
     * 获取所有组织人员（带分页信息）
     *
     * @param queryFilter
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/api/user/v1/users/getAllOrgUsers", method = RequestMethod.POST)
    ObjectNode getAllOrgUsers(@RequestBody QueryFilter queryFilter);

    /**
     * 获取多个组织人员（不带分页信息）
     *
     * @param groupIds
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/api/user/v1/users/getAllOrgsUsers", method = RequestMethod.POST)
    ObjectNode getAllOrgsUsers(@RequestParam(value = "groupIds", required = true) String groupIds);

    /**
     * 获取角色（多个）中的用户
     *
     * @param codes
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/api/role/v1/role/getUsersByRoleCode", method = RequestMethod.POST)
    ArrayNode getUsersByRoleCode(@RequestBody String codes);


    /**
     * 通过岗位编码获取用户
     *
     * @param postCode
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/api/user/v1/users/getUserByPost", method = RequestMethod.GET)
    ArrayNode getUserByPost(@RequestParam(value = "postCode", required = true) String postCode);

    /**
     * 获取职务（多个）下的所有人员
     *
     * @param codes
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/api/job/v1/jobUser/getUsersByJob", method = RequestMethod.GET, produces = {
            "application/json; charset=utf-8"})
    @ApiOperation(value = "获取职务（多个）下的所有人员", httpMethod = "GET", notes = "获取职务下的所有人员")
    ArrayNode getUsersByJob(@RequestParam(value = "codes", required = true) String codes);

    /**
     * 根据email查询用户信息
     *
     * @param email
     * @return
     */
    @RequestMapping(value = "/api/user/v1/user/getUserByEmail", method = RequestMethod.GET)
    ArrayNode getUserByEmail(@RequestParam(value = "email", required = true) String email);


    /**
     * List<OrgUser> orgUsers = orgUserManager.getChargesByOrgId(id,isMain);
     * 根据组织ID获取组织的负责人组织关系
     *
     * @param orgId
     * @return
     */
    @RequestMapping(value = "/api/org/v1/orgUsers/getChargesByOrgId", method = RequestMethod.GET)
    List<ObjectNode> getChargesByOrgId(@RequestParam(value = "orgId", required = true) String orgId, @RequestParam(value = "isMain", required = true) boolean isMain);

    /**
     * Org org =  orgManager.get(orgId);
     * 根据组织id获取组织
     *
     * @return
     */
    @RequestMapping(value = "/api/org/v1/org/get", method = RequestMethod.GET)
    ObjectNode getOrgByIdOrCode(@RequestParam(value = "id", required = true) String orgId);

    /**
     * 根据多个组织编码获取组织信息(以逗号隔开)
     */
    @RequestMapping(value = "/api/org/v1/org/getList", method = RequestMethod.GET)
    ArrayNode getOrgListByCodes(@RequestParam(value = "codes", required = true) String codes);


    /**
     * 根据角色id或编码获取角色
     *
     * @return
     */
    @RequestMapping(value = "/api/role/v1/role/getRole", method = RequestMethod.GET)
    CommonResult<ObjectNode> getRoleByIdOrCode(@RequestParam(value = "code", required = true) String code);

    /**
     * 根据岗位id或编码获取岗位
     *
     * @return
     */
    @RequestMapping(value = "/api/org/v1/orgPost/getOrgPost", method = RequestMethod.GET)
    CommonResult<ObjectNode> getPostByIdOrCode(@RequestParam(value = "postCode", required = true) String code);

    /**
     * 根据职务id或编码获取职务(返回CommonResult<?>)
     *
     * @return
     */
    @RequestMapping(value = "/api/job/v1/job/getOrgJob", method = RequestMethod.GET)
    CommonResult<ObjectNode> getJobByOrgCode(@RequestParam(value = "code", required = true) String code);

    /**
     * 根据职务id或编码获取职务
     *
     * @return
     */
    @RequestMapping(value = "/api/job/v1/job/getJob", method = RequestMethod.GET)
    ObjectNode getJobByIdOrCode(@RequestParam(value = "code", required = true) String code);

    /**
     * OrgUser orgUser = orgUserManager.getOrgUserMaster(ContextUtil.getCurrentUserId());
     * 获取当前用户的主部门
     */
    @RequestMapping(value = "/api/org/v1/org/getSupOrgByCurrMain", method = RequestMethod.GET)
    ObjectNode getOrgUserMaster(@RequestParam(value = "userId", required = true) String userId, @RequestParam(value = "demId", required = true) String demId);

    /**
     * 根据id或别名获取系统分类
     */
    @RequestMapping(value = "/sys/sysType/v1/getJson", method = RequestMethod.GET)
    ObjectNode getSysTypeByIdOrKey(@RequestParam(value = "userId", required = true) String id);

    /**
     * List<SysUserRel> sysUserRels = sysUserRelManager.getSuperUser(userId, level, sysType.get("id").asText());
     * 根據分類編碼和用戶賬號獲取匯報線
     */

    @RequestMapping(value = "/api/userRel/v1/userRel/getSuperUser", method = RequestMethod.POST)
    List<ObjectNode> getSuperUser(@RequestBody(required = true) ObjectNode obj);

    /**
     * List<Role> listRole= roleManager.getAll();
     */
    @RequestMapping(value = "/api/role/v1/roles/getAll", method = RequestMethod.GET)
    List<ObjectNode> getAllRole();

    /**
     * List<Role> listRole = roleManager.getListByUserId(userId);
     * 根據用戶賬號獲取角色
     */
    @RequestMapping(value = "/api/role/v1/role/getRolesByUser", method = RequestMethod.GET)
    List<ObjectNode> getRoleListByAccount(@RequestParam(value = "account", required = true) String account);

    /**
     * 獲取用戶默認維度下的主組織
     * Org org = orgManager.getMainGroup(ContextUtil.getCurrentUser().getUserId());
     */
    @RequestMapping(value = "/api/org/v1/org/getMainGroup", method = RequestMethod.GET)
    ObjectNode getMainGroup(@RequestParam(value = "userId", required = true) String userId);

    /**
     * List<OrgRel> orgRels = orgRelManager.getListByUserId(ContextUtil.getCurrentUser().getUserId());
     * 獲取當前用戶所有崗位
     */
    @RequestMapping(value = "/api/org/v1/orgPost/getOrgPostByUserAccount", method = RequestMethod.GET)
    List<ObjectNode> getPosListByAccount(@RequestParam(value = "account", required = true) String account);

    @RequestMapping(value = "/api/org/v1/org/getParentMainOrg", method = RequestMethod.GET)
    Map<String, ObjectNode> getParentMainOrg(@RequestParam(value = "userId", required = true) String userId);


    /**
     * 获取当前用户的组织布局管理权限
     */
    @RequestMapping(value = "/api/orgAuth/v1/orgAuths/getCurrentUserAuthOrgLayout", method = RequestMethod.GET)
    ArrayNode getCurrentUserAuthOrgLayout(@RequestParam(value = "userId", required = true) String userId);

    /**
     * 获取用户所属组织
     */
    @RequestMapping(value = "/api/org/v1/orgs/getOrgListByUserId", method = RequestMethod.GET)
    ArrayNode getOrgListByUserId(@RequestParam(value = "userId", required = true) String userId);


    /**
     * 根据职务编码、组织编码获取对应人员
     *
     * @param jobCode
     * @param orgCode
     * @return
     */
    @RequestMapping(value = "/api/user/v1/users/getByJobCodeAndOrgCode", method = RequestMethod.GET)
    List<ObjectNode> getByOrgRelDefCode(@RequestParam(value = "jobCode", required = true) String jobCode, @RequestParam(value = "orgCode", required = true) String orgCode);

    /**
     * 根据岗位编码、组织编码获取对应人员
     *
     * @param postCode
     * @param orgCode
     * @return
     */
    @RequestMapping(value = "/api/user/v1/users/getByPostCodeAndOrgCode", method = RequestMethod.GET)
    List<ObjectNode> getByOrgRelCode(@RequestParam(value = "postCode", required = true) String postCode, @RequestParam(value = "orgCode", required = true) String orgCode);

    /**
     * 获取用户主组织
     */
    @RequestMapping(value = "/api/org/v1/org/getMainGroup", method = RequestMethod.GET)
    ObjectNode getMainGroup(@RequestParam(value = "userId", required = true) String userId, @RequestParam(value = "demId", required = true) String demId);

    /**
     * 获取组织（主）负责人
     *
     * @param userId 用户id
     * @param isMain 是否主组织
     * @param isP    是否上级
     * @return
     */
    @RequestMapping(value = "/api/user/v1/users/getCharges", method = RequestMethod.GET)
    JsonNode getCharges(@RequestParam(value = "userId", required = true) String userId, @RequestParam(value = "isMain") Boolean isMain, @RequestParam(value = "isP") Boolean isP);

    /**
     * 获取用户所有职务
     */
    @RequestMapping(value = "/api/org/v1/orgJobs/getJobsByUserId", method = RequestMethod.GET)
    JsonNode getJobsByUserId(@RequestParam(value = "userId", required = true) String userId);

    /**
     * 判断当前用户主部门是否有上级
     */
    @RequestMapping(value = "/api/org/v1/org/isSupOrgByCurrMain", method = RequestMethod.GET)
    boolean isSupOrgByCurrMain(@RequestParam(value = "userId", required = true) String userId, @RequestParam(value = "demId", required = true) String demId, @RequestParam(value = "level", required = true) Integer level);

    /**
     * 通过组织中的下属设置获取上级人员
     */
    @RequestMapping(value = "/api/user/v1/users/getSuperiorFromUnder", method = RequestMethod.GET)
    ArrayNode getSuperFromUnder(@RequestParam(value = "userId", required = true) String userId, @RequestParam(value = "demId", required = false) String demId);

    /**
     * 获取发起人指定级别组织的负责人
     *
     * @param userId
     * @param level        2
     * @param isMainCharge true/false
     * @return
     */
    @RequestMapping(value = "/api/org/v1/orgusers/getCustomLevelCharge", method = RequestMethod.GET)
    ArrayNode getCustomLevelCharge(@RequestParam(value = "userId", required = true) String userId, @RequestParam(value = "level", required = true) String level, @RequestParam(value = "isMainCharge", required = true) boolean isMainCharge);

    /**
     * 获取发起人指定级别组织的指定岗位的用户
     *
     * @param userId
     * @param level
     * @param postCode
     * @return
     */
    @RequestMapping(value = "/api/org/v1/orgusers/getCustomLevelPost", method = RequestMethod.GET)
    Set<ObjectNode> getCustomLevelPost(@RequestParam(value = "userId", required = true) String userId, @RequestParam(value = "level", required = true) String level, @RequestParam(value = "postCode", required = true) String postCode);

    /**
     * 获取发起人指定级别组织的指定职务的用户
     *
     * @param userId
     * @param level
     * @param jobCode
     * @return
     */
    @RequestMapping(value = "/api/org/v1/orgusers/getCustomLevelJob", method = RequestMethod.GET)
    Set<ObjectNode> getCustomLevelJob(@RequestParam(value = "userId", required = true) String userId, @RequestParam(value = "level", required = true) String level, @RequestParam(value = "jobCode", required = true) String jobCode);

    /**
     * 获取发起人组织的指定扩展参数值
     *
     * @param userId
     * @param param
     * @return
     */
    @RequestMapping(value = "/api/org/v1/orgusers/getStartOrgParam", method = RequestMethod.GET)
    String getStartOrgParam(@RequestParam(value = "userId", required = true) String userId, @RequestParam(value = "param", required = true) String param);

    /**
     * 通过用户ID和参数代码获取用户参数
     *
     * @param userId
     * @param code
     * @return
     */
    @RequestMapping(value = "/api/params/v1/userParam/getUserParamsById", method = RequestMethod.GET)
    ObjectNode getUserParamsById(@RequestParam(value = "userId", required = true) String userId, @RequestParam(value = "code", required = true) String code);

    /**
     * 通过组织ID和参数代码获取组织参数
     *
     * @param orgId
     * @param code
     * @return
     */
    @RequestMapping(value = "/api/params/v1/orgParam/getOrgParamsById", method = RequestMethod.GET)
    ObjectNode getOrgParamsById(@RequestParam(value = "orgId", required = true) String orgId, @RequestParam(value = "code", required = true) String code);

    /**
     * 根据id或者账号串获取用户
     */
    @RequestMapping(value = "/api/user/v1/users/postUserByIds", method = RequestMethod.POST)
    ArrayNode getUserByIdsOrAccounts(@RequestBody(required = false) String ids);

    /**
     * 获取子组织
     *
     * @return
     */
    @RequestMapping(value = "/api/org/v1/orgs/getByParentId", method = RequestMethod.GET)
    List<ObjectNode> getChildOrg(@RequestParam(value = "parentId", required = true) String parentId);

    /**
     * 获取子组织（只获取底下一层子组织）
     *
     * @return
     */
    @RequestMapping(value = "/api/org/v1/orgs/getOrgsByparentId", method = RequestMethod.GET)
    List<ObjectNode> getOrgsByparentId(@RequestParam(value = "parentId", required = true) String parentId);

    /**
     * 根据用户id组获取主组织路径
     */
    @RequestMapping(value = "/api/org/v1/org/getPathNames", method = RequestMethod.POST)
    List<Map<String, String>> getPathNames(@RequestParam(value = "userIds", required = true) List<String> userIds);

    /**
     * 根据用户id获取用户所在部门负责人
     *
     * @param userId
     * @param isMain
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/api/user/v1/user/getDepHeader", method = RequestMethod.GET)
    ArrayNode getDepHeader(@RequestParam(value = "userId", required = false) String userId, @RequestParam(value = "isMain", required = true) Boolean isMain);


    /**
     * 根据部门id获取部门负责人
     *
     * @param orgId
     * @param isMain
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/api/user/v1/user/getDepHeaderByOrg", method = RequestMethod.GET)
    ArrayNode getDepHeaderByOrg(@RequestParam(value = "orgId", required = true) String orgId, @RequestParam(value = "isMain", required = true) Boolean isMain);


    /**
     * 根据用户id获取其相关用户组id
     *
     * @param userId
     * @return
     */
    @RequestMapping(value = "/api/user/v1/user/getGroupsByUidAndType", method = RequestMethod.GET)
    List<Group> getGroupsByUidAndType(@RequestParam(value = "userId", required = true) String userId, @RequestParam(value = "type", required = true) String type);


    /**
     * 获取子组织ID（包含自己）
     * Org org = orgManager.getMainGroup(ContextUtil.getCurrentUser().getUserId());
     */

    @RequestMapping(value = "/api/org/v1/org/getChildrenIds", method = RequestMethod.POST)
    Map<String, Set<String>> getChildrenIds(@RequestBody(required = true) Map<String, String> ids);

    /**
     * 查询用户组织关系
     *
     * @param queryFilter
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/api/user/v1/user/queryOrgUserRel", method = RequestMethod.POST)
    List queryOrgUserRel(@RequestBody QueryFilter queryFilter);

    /**
     * 模糊查询用户列表
     */
    @RequestMapping(value = "/api/user/v1/users/getUserByNameaAndEmal", method = RequestMethod.GET)
    List<ObjectNode> getUserByNameaAndEmal(@RequestParam(value = "query", required = true) String query);

    /**
     * 结算节点人员
     */
    @RequestMapping(value = "/api/user/v1/users/calculateNodeUser", method = RequestMethod.POST)
    Map<String, Object> calculateNodeUser(@RequestBody(required = true) Map<String, Object> result);

    /**
     * 根据维度获取组织
     *
     * @param demId
     * @return
     */
    @RequestMapping(value = "/api/org/v1/orgs/getOrgListByDemId", method = RequestMethod.GET)
    List<ObjectNode> getOrgListByDemId(@RequestParam(value = "demId", required = true) String demId);

    /**
     * 根据微信公众号openId获取用户信息
     *
     * @param openId
     * @return
     */
    @RequestMapping(value = "/api/user/v1/user/getUserByOpenId", method = RequestMethod.GET)
    CommonResult<JsonNode> getUserByOpenId(@RequestParam(value = "openId", required = true) String openId);


    /**
     * 根据传入的用户id集合，获取用户的权限集合
     */
    @RequestMapping(value = "/api/user/v1/user/getUserRightMapByIds", method = RequestMethod.GET)
    Map<String, Map<String, String>> getUserRightMapByIds(@RequestParam(value = "ids", required = true) String ids);

    /**
     * 获取默认维度信息
     *
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/api/demension/v1/dem/getDefaultDem", method = RequestMethod.GET)
    ObjectNode getDefaultDem();

    /**
     * 获取用户的主岗位(优先获取默认维度的主岗位、主组织，没有时获取其他维度主岗位、主组织)
     *
     * @param userId
     * @return
     */
    @RequestMapping(value = "/api/org/v1/org/getMainPostOrOrgByUserId", method = RequestMethod.GET)
    ObjectNode getMainPostOrOrgByUserId(@RequestParam(value = "userId", required = true) String userId);

    /**
     * 获取用户的主岗位组织关系
     *
     * @param userId
     * @param demId
     * @return
     */
    @RequestMapping(value = "/api/org/v1/org/getSupOrgByCurrMain", method = RequestMethod.GET)
    ObjectNode getSupOrgByCurrMain(@RequestParam(value = "userId", required = true) String userId, @RequestParam(value = "demId", required = true) String demId);

    /**
     * 获取所有维度列表
     *
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/api/demension/v1/dems/getAll", method = RequestMethod.GET)
    List<ObjectNode> getAllDems();

    /**
     * 根据用户账号获取用户组织岗位相关信息
     *
     * @param account
     * @return
     */
    @RequestMapping(value = "/api/user/v1/user/getDetailByAccountOrId", method = RequestMethod.GET)
    Map<String, Object> getDetailByAccountOrId(@RequestParam(value = "account", required = true) String account);

    /**
     * 根据多个用户id获取用户信息(以逗号隔开)
     */
    @RequestMapping(value = "/api/user/v1/user/getUserByIds", method = RequestMethod.GET)
    ArrayNode getUserByIds(@RequestParam(value = "ids", required = false) String ids);

    /**
     * 将第三方通讯录组织框架拉取至本系统
     *
     * @return
     */
    @RequestMapping(value = "/api/org/v1/org/addOrgFromExterUni", method = RequestMethod.POST)
    CommonResult<String> addOrgFromExterUni(@RequestBody ObjectNode org);

    /**
     * 根据手机号获取用户
     *
     * @return
     */
    @RequestMapping(value = "/api/user/v1/user/getUserByMobile", method = RequestMethod.GET)
    CommonResult<JsonNode> getUserByMobile(@RequestParam(value = "mobile", required = true) String mobile);

    /**
     * 将第三方通讯录成员拉取至本系统
     *
     * @return
     */
    @RequestMapping(value = "/api/user/v1/user/addUserFromExterUni", method = RequestMethod.POST)
    JsonNode addUserFromExterUni(@RequestBody ObjectNode newUser);

    /**
     * 组织批量加入用户
     *
     * @return
     */
    @RequestMapping(value = "/api/org/v1/orgUsers/addUsersForOrg", method = RequestMethod.POST)
    CommonResult<String> addUsersForOrg(@RequestParam(value = "orgCode", required = true) String orgCode, @RequestParam(value = "accounts", required = true) String accounts);

    /**
     * 根据签署任务信息获取审批用户的姓名，账号， 主部门等信息
     *
     * @param customSignDatas
     * @return
     */
    @RequestMapping(value = "/api/user/v1/user/getUserInfoBySignData", method = RequestMethod.POST)
    ArrayNode getUserInfoBySignData(@RequestBody ArrayNode customSignDatas) throws Exception;

    /**
     * 根据租户id获取其被禁用菜单别名
     *
     * @param tenantId
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/uc/tenantIgnoreMenu/v1/getIgnoreMenuCodes", method = RequestMethod.GET)
    List<String> getIgnoreMenuCodes(@RequestParam(value = "tenantId", required = true) String tenantId) throws Exception;

    /**
     * 通过租户ID获取租户信息
     *
     * @param id
     * @return
     */
    @RequestMapping(value = "/uc/tenantManage/v1/getJson", method = RequestMethod.GET)
    JsonNode getTenantById(@RequestParam(value = "id", required = true) String id);

    /**
     * 获取当前用户填制单位
     *
     * @param demId
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/api/org/v1/org/getFillOrg", method = RequestMethod.GET)
    CommonResult<Object> getFillOrg(@RequestParam(value = "demId", required = false) String demId) throws Exception;


    /**
     * 根据下属id和维度id获取上级
     *
     * @param underId
     * @param demId
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/api/user/v1/user/superior", method = RequestMethod.GET)
    JsonNode getSuperior(@RequestParam("underId") String underId, @RequestParam("demId") String demId);

    /**
     * <pre>
     * 获取人员的上级岗位
     * 1、先查找主岗位的上级岗位
     * 2、无主岗位查其他岗位，其他岗位只有一个时，查找该岗位的上级岗位，
     * 其他岗位为多个时，抛出异常
     * </pre>
     *
     * @param userId
     * @return
     */
    @RequestMapping(value = "/api/org/v1/org/getSuperiorPost", method = RequestMethod.GET)
    JsonNode getSuperiorPost(@RequestParam("userId") String userId);

    /**
     * 创建用户
     *
     * @param userPolymer
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/api/user/v1/user/saveUser", method = RequestMethod.POST)
    CommonResult<String> saveUserPolymer(@RequestParam(value = "userPolymer", required = true) String userPolymer) throws Exception;

    @RequestMapping(value = "/uc/shiftRule/v1/computeSendDate", method = RequestMethod.GET)
    Long computeSendDate(@RequestParam(value = "userId") String userId, @RequestParam(value = "minute") long minute) throws Exception;

    @RequestMapping(value = "/uc/shiftRule/v1/computeDuration", method = RequestMethod.POST)
    Long computeDuration(@RequestParam(value = "userId") String userId, @RequestBody ObjectNode objectNode) throws Exception;

    /**
     * 获取租户邮件服务器配置
     *
     * @return
     */
    @RequestMapping(value = "/uc/tenantMailServer/v1/getByCurrent", method = RequestMethod.GET)
    ObjectNode getTenantMailServiceInfo(@RequestParam(value = "tenantId", required = false) String tenantId);

    @RequestMapping(value = "/api/org/v1/orgParam/getParamById", method = RequestMethod.GET)
    String getParamKey(@RequestParam(value = "orgId", required = true) String orgId, @RequestParam(value = "alias", required = true) String alias);

    @RequestMapping(value = "/api/org/v1/orgParam/isOrgHasParamKey", method = RequestMethod.GET)
    boolean isOrgHasParamKey(@RequestParam(value = "orgId", required = true) String orgId, @RequestParam(value = "alias", required = true) String alias);

    @RequestMapping(value = "/api/org/v1/orgParam/hasOrgParamKey", method = RequestMethod.GET)
    boolean hasOrgParamKey(@RequestParam(value = "grade", required = true) String grade, @RequestParam(value = "userId", required = true) String userId, @RequestParam(value = "alias", required = true) String alias);

    @RequestMapping(value = "/uc/userUnite/v1/updateUserUnite", method = RequestMethod.POST)
    CommonResult<String> updateUserUnite(@RequestBody ObjectNode userUnite);

    /**
     * 获取还没进行企业微信同步的用户
     *
     * @return
     */
    @RequestMapping(value = "/api/user/v1/users/getUsersNotYetSyncWxWork", method = RequestMethod.GET)
    JsonNode getUsersNotYetSyncWxWork();

    /**
     * 根据微信通讯录的userid获取用户与外部通讯录关系
     *
     * @param wxWorkId
     * @return
     */
    @RequestMapping(value = "/uc/userUnite/v1/getUserUniteByWxWorkId", method = RequestMethod.GET)
    JsonNode getUserUniteByWxWorkId(@RequestParam(value = "wxWorkId", required = true) String wxWorkId);

    /**
     * 根据微信通讯录的userid获取绑定的用户的用户信息
     *
     * @param wxWorkId
     * @return
     */
    @RequestMapping(value = "/api/user/v1/getUserByWxWorkId", method = RequestMethod.GET)
    JsonNode getUserByWxWorkId(@RequestParam(value = "wxWorkId", required = true) String wxWorkId);


    /**
     * 获取还没进行钉钉同步的用户
     *
     * @return
     */
    @RequestMapping(value = "/api/user/v1/users/getUsersNotYetSyncDingtalk", method = RequestMethod.GET)
    ArrayNode getUsersNotYetSyncDingtalk();

    /**
     * 根据钉钉通讯录的userid获取绑定的用户的用户信息
     *
     * @param dingtalkId
     * @return
     */
    @RequestMapping(value = "/api/user/v1/getUserByDingtalkId", method = RequestMethod.GET)
    JsonNode getUserByDingtalkId(@RequestParam(value = "dingtalkId", required = true) String dingtalkId);

    /**
     * 根据愉快政的employeeCode获取绑定的用户的用户信息
     *
     * @param employeeCode
     * @return
     */
    @RequestMapping(value = "/api/user/v1/getUserByYkzEmployeeCode", method = RequestMethod.GET)
    JsonNode getUserByYkzEmployeeCode(@RequestParam(value = "employeeCode", required = true) String employeeCode);

    /**
     * 根据userIds获取钉钉ids
     *
     * @return
     */
    @RequestMapping(value = "/uc/userUnite/v1/getDingtalkIdsByUserIds", method = RequestMethod.GET)
    String getDingtalkIdsByUserIds(@RequestParam(value = "userIds", required = true) String userIds);

    /**
     * 根据userIds获取企业微信ids
     *
     * @return
     */
    @RequestMapping(value = "/uc/userUnite/v1/getWxWorkIdsByUserIds", method = RequestMethod.GET)
    String getWxWorkIdsByUserIds(@RequestParam(value = "userIds", required = true) String userIds);

    /**
     * 根据userIds获取openIds
     *
     * @return
     */
    @RequestMapping(value = "/uc/userUnite/v1/getOpenIdsByUserIds", method = RequestMethod.GET)
    String getOpenIdsByUserIds(@RequestParam(value = "userIds", required = true) String userIds);

    /**
     * @param params
     * @return
     */
    @RequestMapping(value = "/uc/matrix/v1/getUsers", method = RequestMethod.POST)
    ArrayNode getMatrixRoleUsers(@RequestBody Map<String, Object> params);

    /**
     * 根据条件获取矩阵指定角色的用户
     *
     * @param obj
     * @return
     */
    @RequestMapping(value = "/uc/matrix/v1/getRoleUserByConditions", method = RequestMethod.POST)
    ArrayNode getRoleUserByConditions(@RequestBody(required = true) ObjectNode obj);

    @RequestMapping(value = "/api/user/v1/users/getByCompanyRole", method = RequestMethod.GET)
    List<ObjectNode> getByCompanyRole(@RequestParam(value = "company", required = true) String company, @RequestParam(value = "role", required = true) String role);

    @RequestMapping(value = "/api/user/v1/users/getLeaderStep", method = RequestMethod.GET)
    List<ObjectNode> getLeaderStep(@RequestParam(value = "userId", required = true) String userId, @RequestParam(value = "grade", required = true) Integer grade, @RequestParam(value = "res", required = true) boolean res);

    @RequestMapping(value = "/api/user/v1/users/getFgUsers", method = RequestMethod.GET)
    List<ObjectNode> getFgUsers(@RequestParam(value = "orgId", required = true) String orgId, @RequestParam(value = "orgParam", required = true) String orgParam, @RequestParam(value = "userParam", required = true) String userParam);

    @RequestMapping(value = "/api/user/v1/users/getLeaderStepByOrgId", method = RequestMethod.GET)
    List<ObjectNode> getLeaderStepByOrgId(@RequestParam(value = "orgId", required = true) String orgId, @RequestParam(value = "grade", required = true) Integer grade);

    @RequestMapping(value = "/uc/electronicSeal/v1/saveSignatureBatch", method = RequestMethod.POST)
    CommonResult<String> saveSignatureBatch(@RequestBody ObjectNode signatureData);

    /**
     * 根据多个组织id获取组织(以逗号隔开)
     */
    @RequestMapping(value = "/api/org/v1/org/getOrgsByIds", method = RequestMethod.GET)
    ArrayNode getOrgsByIds(@RequestParam(value = "ids", required = true) String ids);

    /**
     * 根据多个组织code获取组织(以逗号隔开)
     */
    @RequestMapping(value = "/api/org/v1/org/getOrgsByCodes", method = RequestMethod.GET)
    ArrayNode getOrgsByCodes(@RequestParam(value = "codes", required = true) String codes);

    @RequestMapping(value = "/api/org/v1/orgpost/findByPostIds", method = RequestMethod.GET)
    ArrayNode findByPostIds(@RequestParam(value = "postIds", required = true) String postIds);

    @RequestMapping(value = "/api/org/v1/orgpost/updateUserPosition", method = RequestMethod.POST)
    boolean updateUserPosition(@RequestBody ArrayNode arrayNode);

    /**
     * 根据父ID查询下级所有组织列表
     *
     * @param parentId 组织父ID
     * @return
     */
    @RequestMapping(value = "/api/org/v1/orgs/getByParentId", method = RequestMethod.GET)
    ArrayNode getOrgListByParentId(@RequestParam(value = "parentId") String parentId);

    /**
     * 根据用户ID查询用户组织岗位角色信息
     *
     * @param userRelObject 查询条件obj
     * @return
     */
    @RequestMapping(value = "/api/user/v1/userPost/getUserPosts", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    ArrayNode getUserPosts(@RequestBody ObjectNode userRelObject);


    /**
     * 根据岗位编码、组织编码获取对应人员
     *
     * @param roleCode 岗位编码
     * @param orgCode  组织编码
     * @return 人员列表
     */
    @RequestMapping(value = "/api/user/v1/users/getByRoleCodeAndOrgCode", method = RequestMethod.GET)
    List<ObjectNode> getByRoleCodeAndOrgCode(@RequestParam(value = "roleCode", required = true) String roleCode, @RequestParam(value = "orgCode", required = true) String orgCode);

    /**
     * 根据群组编码 获取指定群组下人员信息
     *
     * @param code 群组编码
     * @return 人员列表
     */
    @RequestMapping(value = "/api/userGroup/v1/userGroup/getGroupUsers", method = RequestMethod.GET)
    List<ObjectNode> getGroupUsers(@RequestParam(value = "code") String code);

}
