// 传参示例
export const paramsExample = {
  title: '标题', // 图表标题
  xAxisData: ['10:00', '11:00','12:00'], // x轴数据
  yAxisName: '指数', // 公共y轴名称
  height: '400px', // 图表高度 默认200px
  data: [
    {
      name: '柱图',
      type: 'bar', // 图表类型 默认折线图
      useColorIndex: 2, // 图标颜色序号 默认按照数据顺序取颜色
      showYAxis: true,
      yAxisName: '轴1',
      value: [12,33,23]
    },
    {
      name: '折线1',
      type: 'line',
      showYAxis: true,// 是否独立展示y轴
      yAxisName: '轴2', // y轴名称
      position: 'right', // y轴位置
      value: [23,12,43], // y轴数据
    },
    {
      name: '折线2',
      value: [34,33,13]
    },
  ]
}

// y轴基础数据
export const baseYAxis = {
  type: 'value',
  nameTextStyle: {
    color: '#C3E1FA',
    fontSize: 11,
    fontFamily: 'DIN-Regular',
  },
  boundaryGap: false,
  axisLabel: {
    color: '#9AABBA',
    fontSize: 11,
    fontFamily: 'DIN-Regular',
  },
  axisLine: {
    show: true,
    lineStyle: {
      color: '#778FA4',
    },
  },
  splitLine: {
    lineStyle: {
      type: 'dashed',
      color: 'rgba(255, 255, 255, 0.15)',
    },
  },
  axisTick: {
    show: false,
  },
}

// 柱图、折线图基础数据
const lineBaseSeries = (startColor: string=startColorList[0], endColor:String=endColorList[0]) => {

  return {
    type: 'line',
    smooth: true,
    showSymbol: false,
    lineStyle: {
      width: 2,
      color: `rgba(${startColor}, 1)`, // 线条颜色
    },
    itemStyle: {
      color: `rgba(${startColor}, 1)`,
      borderColor: '#646ace',
      borderWidth: 2,
    },
    areaStyle: {
      color: {
        type: 'linear',
        x: 0,
        y: 0,
        x2: 0,
        y2: 1,
        colorStops: [
          {
            offset: 0,
            color: `rgba(${startColor}, 1)`, // 0% 处的颜色
          },
          {
            offset: 0.2,
            color: `rgba(${endColor}, 0.5)`,
          },
          {
            offset: 1,
            color: `rgba(0,0,0,0)`,
          },
        ],
        globalCoord: false, // 缺省为 false
      },
    },
  }

}
const barBaseSeries = (startColor: string=startColorList[0], endColor:String=endColorList[0]) => {
  return {
    type: 'bar',
    barMaxWidth: '30',
    itemStyle: {
      borderColor: `rgba(${startColor}, 0.2)`,
      borderWidth: '1',
      color: {
        type: 'linear',
        x: 0,
        y: 0,
        x2: 0,
        y2: 1,
        colorStops: [
          {
            offset: 0,
            color: `rgba(${startColor}, 1)`, // 0% 处的颜色
          },
          {
            offset: 0.2,
            color: `rgba(${endColor}, 0.5)`,
          },
          {
            offset: 1,
            color: `rgba(0,0,0,0)`,
          },
        ],
        globalCoord: false, // 缺省为 false
      },
    },
  }
}
export const baseSeriesConfig = {
  line: lineBaseSeries,
  bar: barBaseSeries
}

let startColorList = [
  '25, 214, 156',
  '29, 184, 255',
  '255, 191, 70',
  '108, 96, 253',
]
let endColorList = [
  '170, 255, 107',
  '47, 253, 248',
  '253, 222, 165',
  '191, 186, 255',
]
// 图表颜色
export const initColor = (data:any) => {
  let startColor = startColorList
  let endColor = endColorList
  const addColor = () => {
    startColor = startColor.concat(
      startColor.slice(0, data.length - startColor.length)
    )
    endColor = endColor.concat(
      endColor.slice(0, data.length - endColor.length)
    )
  }
  while(data.length > startColor.length || data.length > endColor.length) {
    addColor()
  }
  return { startColor, endColor }
}
