//  token 未设置

import axios from "@/utils/axiosART";
const xcjyPath = "/xcjy";

// 根据PTK查询用户信息
export function getXCJYTK(userInfo) {
    return axios.post(`${xcjyPath}/auth`, userInfo)
        .then(res => {
            if (res.loginStatus && res.token) {
                sessionStorage.setItem('xcjyToken', res.token)
                return true
            }
        })
        .catch(err => {
            console.log(err)
            return false
        })
}

// 根据PTK查询用户信息
export function getRoadData() {
    return axios.get(`${xcjyPath}/bizBaseRoad/v1/roadTree`)
}

// 根据code查询字典信息
export function getDictByCode(data) {
    return axios.post(`${xcjyPath}/sys/sysDictionary/v1/queryDictItemsByCode`, data, {
        headers: { 'Content-type': 'application/x-www-form-urlencoded' }
    })
}

// 查询基本概览
export function getBasicData(queryData) {
    return axios.post(`${xcjyPath}/open/v1/patrol/info`, queryData)
}

// 查询巡查统计
export function getPatrolCountData(queryData) {
    return axios.post(`${xcjyPath}/open/v1/patrol/count`, queryData)
}

// 查询事件类型
export function getTaskTypeData(queryData) {
    return axios.post(`${xcjyPath}/open/v1/task/type`, queryData)
}

// 查询任务统计-突发事件
export function getTaskCountData(queryData) {
    return axios.post(`${xcjyPath}/open/v1/task/count`, queryData)
}

// 查询突发事件详情
export function getEventDetail(id) {
    return axios.get(`${xcjyPath}/event/bizEventInfo/v1/` + id)
}

// 查询救援任务
export function getRescueTaskData(queryData) {
    return axios.post(`${xcjyPath}/base/v1/task`, queryData)
}

// 查询救援任务详情
export function getRescueTaskDetail(id) {
    return axios.get(`${xcjyPath}/event/bizRescueInfo/v1/` + id)
}

// 查询巡查驻点
export function getPatrolPointData(queryData) {
    return axios.post(`${xcjyPath}/base/v1/point/patrol`, queryData)
}

// 查询救援驻点
export function getRescuePointData(queryData) {
    return axios.post(`${xcjyPath}/base/v1/point/rescue`, queryData)
}

// 查询驻点详情
export function getPatrolPointDetail(id) {
    return axios.get(`${xcjyPath}/bizBaseStationary/v1/` + id)
}

// 查询巡查车辆
export function getPatrolCarData(queryData) {
    return axios.post(`${xcjyPath}/base/v1/car/patrol`, queryData)
}

// 查询救援车辆
export function getRescueCarData(queryData) {
    return axios.post(`${xcjyPath}/base/v1/car/rescue`, queryData)
}

// 查询巡查区域
export function getRescueRegionData(queryData) {
    return axios.post(`${xcjyPath}/base/v1/rescue/region`, queryData)
}

// 道路巡查列表
export function getRoadPatrolList(queryData) {
    return axios.post(`${xcjyPath}/patrol/bizInspectionTask/v1/query/open`, queryData)
}

// 道路巡查详情
export function getRoadPatrolDetail(id) {
    return axios.get(`${xcjyPath}/patrol/bizInspectionTask/v1/` + id)
}

// 道路巡查点位详情
export function getRoadPatrolPlanDetail(id) {
    return axios.get(`${xcjyPath}/patrol/bizInspectionPlan/v1/` + id)
}

// 根据监控点编码获取视频流地址
export function getMonitorVideo(data) {
    return axios.post(`${xcjyPath}bizVideoMonitorPointInfo/v1/previewURLs`, data)
}

// 根据救援队伍获取救援区域位置信息
export function getRescueRegionByTeam(data) {
    return axios.get(`${xcjyPath}/bizElectronicFenec/v1/getFenec?teamIds=` + data)
}