import { getMapConfig } from '@/api/gis'

export interface State {
  config: any
  layers: Array<any>
  selectedLayers: Array<any>
  map: any
  boundaryLineFace: Array<any>
}

const initialState: State = {
  config: null, // 地图配置
  layers: [], // 地图静态图层配置
  selectedLayers: [], // 选中地图图层code
  map: null,
  boundaryLineFace: [{ // 地图省份边界  layerIdl边界线 layerIdf 边界面
    code: 'SC',
    layerIdl: '20187ac7367e14034b8c19a40a33fe30',
    layerIdf: '4394876460f6c3bd34d0615bf04cff47'
  }, {
    code: 'AH',
    layerIdl: 'ef01a0169aaec81e77e9f0048ceb9713',
    layerIdf: '3dde510c446230cbd4fdd15c5fb85416'
  }, {
    code: 'YN',
    layerIdl: '06fc0230dad437e85d24600e06516587',
    layerIdf: '031e5e61df73778bce2c2d82a4fc0a1c'
  }, {
    code: 'GZ',
    layerIdl: '6c66cdbaddbcf839a529b03bcee23266',
    layerIdf: 'd960ce4f0fe3eafeebf02a908e25910b'
  }, {
    code: 'CQ',
    layerIdl: 'dfc9779a51de79b2eb40790f613964e2',
    layerIdf: 'b37573d5d73f223aa5cf4293efeda3c0'
  },{
    code: 'XJ',
    layerIdl: 'b6f8c73b2d314bd6e091012fd7698e94',
    layerIdf: '238a5e9de56faa7385873aaadf3ad67d',
  },{
    code: 'HN',
    layerIdl: '4edbe95e3ec8786276bb39ce7c42453f',
    layerIdf: 'c1c5c040257326352d694528b7e33fac'
  }],
}

const state: State = JSON.parse(JSON.stringify(initialState))

const mutations = {
  RESET(state: any) {
    Object.assign(state, JSON.parse(JSON.stringify(initialState)))
  },
  SET_STATE: (state: any, payload: any) => {
    state[payload.key] = payload.value
  },
  setMap: (state: any, map: any) => {
    state.map = map
  }
}

const actions = {
  reset({ commit }: any) {
    commit('RESET')
  },

  async getMapConfig({ commit }: any, params: any) {
    const res = await getMapConfig(params)
    console.log('地图的配置', res)
    if (res && res.data) {
      const { map, layers } = res.data
      // 处理雪碧图，直连请求转成代理，适配https和跨域
      map.spriteUrl = [
        ...map.spriteUrl,
        './mapresource/sprite/sprite',
      ]
      commit('SET_STATE', { key: 'config', value: Object.freeze(map) })
      commit('SET_STATE', { key: 'layers', value: Object.freeze(layers) })
    }
  },
}

export default {
  namespaced: true,
  state,
  mutations,
  actions,
}
