import router from "./";
import { get, set, remove } from "@/utils/cookie";
import NProgress from "nprogress";
import "nprogress/nprogress.css";
import { store } from "@/store";
import { getUserInfoByPTK } from "@/api/user";
NProgress.configure({ showSpinner: false });
const { VITE_AUTH, VITE_TEST_TOKEN, VITE_JSC_URL, VITE_PORTALWEB_URL } =
	import.meta.env;
router.beforeEach(async (to, from) => {
	NProgress.start();
	// 地址中存在tokenKey则跳转去掉 同时保存tokenKey到cookie
	if (window.location.href.indexOf("tokenKey") > -1) {
		// 门户系统跳转,获取对应的参数,跳转路由
		let searchStr = window.location.search;
		searchStr = searchStr.substring(1, searchStr.length);
		// tokenKey
		const tkStr = searchStr
			.split("&")
			.find((e) => e.indexOf("tokenKey") === 0);
		tkStr && set("tokenKey", tkStr.split("=")[1]);
		// token
		const tk = searchStr
			.split("&")
			.find(
				(e) => e.indexOf("token") === 0 && e.indexOf("tokenKey") !== 0
			);
		tk && set("token", tk.split("=")[1]);
		if (!tk) {
			// 获取token
			const tokenKey = tkStr.split("=")[1];
			await store.dispatch("auth/getToken", tokenKey);
		}

		NProgress.done();
		// 开发环境或招路通
		const code = window.location.href
			.split("?")[1]
			.split("&")[0]
			.split("=")[1];
		if (code) {
			if (code == "business") {
				return (window.location.href = `http://183.64.175.153:20003/#/business`);
			} //业务概况
			if (code == "manageGenera") {
				return (window.location.href = `http://183.64.175.153:20003/#/manageGenera`);
			} //经营概况
			if (code == "operationOverview") {
				return (window.location.href = `http://183.64.175.153:20003/#/operationOverview`);
			} //运行监测
			if (code == "videoSurveillance") {
				return (window.location.href = `http://183.64.175.153:20003/#/videoSurveillance`);
			} //视频监控
			if (code == "expressway") {
				return (window.location.href = `http://183.64.175.153:20003/#/expressway`);
			} //高速公路+
			if (code == "charge") {
				return (window.location.href = `http://183.64.175.153:20003/#/charge`);
			} //收费
			if (code == "curingManageyh") {
				return (window.location.href = `http://183.64.175.153:20003/#/curingManageyh`);
			} //养护
			if (code == "electromechanicalMange") {
				return (window.location.href = `http://183.64.175.153:20003/#/electromechanicalMange`);
			} //机电
			if (code == "dataMonitor") {
				return (window.location.href = `http://183.64.175.153:20003/#/data-monitor`);
			} //数据监控
		} else {
			window.location.href = "/";
		}
		// window.location.href = '/dirjsc'
	} else if (window.location.href.indexOf("ptk") > -1) {
		// 门户系统跳转,获取对应的参数,跳转路由
		let searchStr = window.location.search;
		searchStr = searchStr.substring(1, searchStr.length);
		// ptk
		const tkStr = searchStr.split("&").find((e) => e.indexOf("ptk") === 0);
		let ptk = "";
		if (tkStr) {
			ptk = tkStr.split("=")[1];
		}
		if (ptk) {
			// 门户系统跳转根据ptk获取用户信息
			const res = await getUserInfoByPTK(ptk);
			// const res = {
			// 	state: true,
			// 	value: {
			// 		account: "admin",
			// 	},
			// };
			if (res && res.state) {
				const account = res.value.account || "";

				sessionStorage.setItem("TYAccount", account);
				// 根据用户信息免密登录
				const isGetToken = await store.dispatch(
					"auth/getTokenByUserInfo",
					account
				);
				if (isGetToken) {
					NProgress.done();
					const code = window.location.href
						.split("?")[1]
						.split("&")[0]
						.split("=")[1];
					if (code) {
						if (code == "business") {
							return (window.location.href =
								VITE_JSC_URL + `business`);
						} //业务概况
						if (code == "manageGenera") {
							return (window.location.href =
								VITE_JSC_URL + `manageGenera`);
						} //经营概况
						if (code == "operationOverview") {
							return (window.location.href =
								VITE_JSC_URL + `operationOverview`);
						} //运行监测
						if (code == "videoSurveillance") {
							return (window.location.href =
								VITE_JSC_URL + `videoSurveillance`);
						} //视频监控
						if (code == "expressway") {
							return (window.location.href =
								VITE_JSC_URL + `expressway`);
						} //高速公路+
						if (code == "charge") {
							return (window.location.href =
								VITE_JSC_URL + `charge`);
						} //收费
						if (code == "curingManageyh") {
							return (window.location.href =
								VITE_JSC_URL + `curingManageyh`);
						} //养护
						if (code == "electromechanicalMange") {
							return (window.location.href =
								VITE_JSC_URL + `electromechanicalMange`);
						} //机电
						if (code == "dataMonitor") {
							return (window.location.href =
								VITE_JSC_URL + `data-monitor`);
						} //数据监控
					}
				} else {
					window.location.href = VITE_PORTALWEB_URL;
				}
			} else {
				window.location.href = VITE_PORTALWEB_URL;
			}
		} else {
			window.location.href = VITE_PORTALWEB_URL;
		}
	} else {
		if (VITE_AUTH === "FALSE") {
			// 设置无权限下的测试token
			VITE_TEST_TOKEN && set("token", VITE_TEST_TOKEN as string);
			if (!store.state.auth?.userInfo) {
				await store.dispatch("auth/getUserInfo");
			}
		} else {
			const tokenKey = get("tokenKey");
			const token = get("token");
			if (token) {
				// 检查用户信息
				if (!store.state.auth?.userInfo) {
					await store.dispatch("auth/getUserInfo");
					if (!store.state.auth?.userInfo) {
						store.dispatch("auth/logout");
					}
				}
			} else if (tokenKey) {
				// 获取token
				await store.dispatch("auth/getToken", tokenKey);
				if (!store.state.auth?.token) {
					store.dispatch("auth/logout");
				} else {
					return to.fullPath;
				}
			} else {
				store.dispatch("auth/logout");
			}
		}
	}
	NProgress.done();
});
router.afterEach(() => {
	NProgress.done();
});
