import Mock from "mockjs";
const { Random } = Mock;

const baseUrl = "/http-server-base/publish/quota-v1";
const baseUrljw = "/http-server-base/publish/base-v1";
const api = `/bizapi1${baseUrl}`;
const apijw = `/bizapi1${baseUrljw}`;
const basePath = "/user";
//  获取组织树
Mock.mock(`${api}/organizationTree`, "get", {
    "msgState": "SUCCESS",
    "msgType": "ARR",
    "msgDes": "QUERY",
    "msgContent": [
        {
            "authCode": "10010101",
            "level": "1",
            "organizationId": "CQ",
            "organizationName": "重庆",
            "passTime": "",
            "pnode": "-1",
            "provinceId": null,
            "sort": "1"
        },
        {
            "authCode": "10010102",
            "level": "1",
            "organizationId": "SC",
            "organizationName": "四川",
            "passTime": "",
            "pnode": "-1",
            "provinceId": null,
            "sort": "2"
        },
        {
            "authCode": "10010117",
            "level": "1",
            "organizationId": "GZ",
            "organizationName": "贵州",
            "passTime": "",
            "pnode": "-1",
            "provinceId": null,
            "sort": "3"
        },
        {
            "authCode": "10010105",
            "level": "1",
            "organizationId": "YN",
            "organizationName": "云南",
            "passTime": "",
            "pnode": "-1",
            "provinceId": null,
            "sort": "4"
        },
        {
            "authCode": "1001010101",
            "level": "2",
            "organizationId": "101",
            "organizationName": "第一管理中心",
            "passTime": "",
            "pnode": "CQ",
            "provinceId": null,
            "sort": "11"
        },
        {
            "authCode": "1001010102",
            "level": "2",
            "organizationId": "102",
            "organizationName": "第二管理中心",
            "passTime": "",
            "pnode": "CQ",
            "provinceId": null,
            "sort": "12"
        },
        {
            "authCode": "1001010103",
            "level": "2",
            "organizationId": "103",
            "organizationName": "第三管理中心",
            "passTime": "",
            "pnode": "CQ",
            "provinceId": null,
            "sort": "13"
        },
        {
            "authCode": "1001010104",
            "level": "2",
            "organizationId": "104",
            "organizationName": "第四管理中心",
            "passTime": "",
            "pnode": "CQ",
            "provinceId": null,
            "sort": "14"
        },
        {
            "authCode": "1001010105",
            "level": "2",
            "organizationId": "105",
            "organizationName": "第五管理中心",
            "passTime": "",
            "pnode": "CQ",
            "provinceId": null,
            "sort": "15"
        },
        {
            "authCode": "1001010113",
            "level": "2",
            "organizationId": "106",
            "organizationName": "第六管理中心",
            "passTime": "",
            "pnode": "CQ",
            "provinceId": null,
            "sort": "16"
        },
        {
            "authCode": "1001010201",
            "level": "2",
            "organizationId": "201",
            "organizationName": "第一管理中心",
            "passTime": "",
            "pnode": "SC",
            "provinceId": null,
            "sort": "21"
        },
        {
            "authCode": "1001010202",
            "level": "2",
            "organizationId": "202",
            "organizationName": "第二管理中心",
            "passTime": "",
            "pnode": "SC",
            "provinceId": null,
            "sort": "22"
        },
        {
            "authCode": "1001011705",
            "level": "2",
            "organizationId": "705",
            "organizationName": "第一管理中心",
            "passTime": "",
            "pnode": "GZ",
            "provinceId": null,
            "sort": "31"
        },
        {
            "authCode": "1001011702",
            "level": "2",
            "organizationId": "702",
            "organizationName": "第二管理中心",
            "passTime": "",
            "pnode": "GZ",
            "provinceId": null,
            "sort": "32"
        },
        {
            "authCode": "1001010501",
            "level": "2",
            "organizationId": "401",
            "organizationName": "第一管理中心",
            "passTime": "",
            "pnode": "YN",
            "provinceId": null,
            "sort": "41"
        },
        {
            "authCode": "1001010502",
            "level": "2",
            "organizationId": "402",
            "organizationName": "第二管理中心",
            "passTime": "",
            "pnode": "YN",
            "provinceId": null,
            "sort": "42"
        },
        {
            "authCode": "1001010503",
            "level": "2",
            "organizationId": "403",
            "organizationName": "第三管理中心",
            "passTime": "",
            "pnode": "YN",
            "provinceId": null,
            "sort": "43"
        },
        {
            "authCode": "1001010507",
            "level": "2",
            "organizationId": "507",
            "organizationName": "三清管理中心",
            "passTime": "",
            "pnode": "YN",
            "provinceId": null,
            "sort": "43"
        },
        {
            "authCode": "100101010101",
            "level": "3",
            "organizationId": "1430049550537723904",
            "organizationName": "渝遂高速",
            "passTime": "1",
            "pnode": "101",
            "provinceId": "CQ",
            "sort": "111"
        },
        {
            "authCode": "100101010102",
            "level": "3",
            "organizationId": "1430054414412025856",
            "organizationName": "永泸高速",
            "passTime": "1",
            "pnode": "101",
            "provinceId": "CQ",
            "sort": "112"
        },
        {
            "authCode": "100101010103",
            "level": "3",
            "organizationId": "1840240576214208512",
            "organizationName": "渝遂复线",
            "passTime": "1",
            "pnode": "101",
            "provinceId": "CQ",
            "sort": "113"
        },
        {
            "authCode": "100101010201",
            "level": "3",
            "organizationId": "1430052457714683904",
            "organizationName": "潼荣高速",
            "passTime": "1",
            "pnode": "102",
            "provinceId": "CQ",
            "sort": "121"
        },
        {
            "authCode": "100101010202",
            "level": "3",
            "organizationId": "1493834264024846336",
            "organizationName": "大内高速",
            "passTime": "1",
            "pnode": "102",
            "provinceId": "CQ",
            "sort": "122"
        },
        {
            "authCode": "100101010301",
            "level": "3",
            "organizationId": "1430053229818941440",
            "organizationName": "合安高速",
            "passTime": "1",
            "pnode": "103",
            "provinceId": "CQ",
            "sort": "131"
        },
        {
            "authCode": "100101010302",
            "level": "3",
            "organizationId": "1612639944117981184",
            "organizationName": "合璧津高速",
            "passTime": "1",
            "pnode": "103",
            "provinceId": "CQ",
            "sort": "132"
        },
        {
            "authCode": "100101010401",
            "level": "3",
            "organizationId": "1430050859642916864",
            "organizationName": "石黔高速",
            "passTime": "1",
            "pnode": "104",
            "provinceId": "CQ",
            "sort": "141"
        },
        {
            "authCode": "100101010402",
            "level": "3",
            "organizationId": "1430051717893984256",
            "organizationName": "秀松高速",
            "passTime": "1",
            "pnode": "104",
            "provinceId": "CQ",
            "sort": "142"
        },
        {
            "authCode": "100101010403",
            "level": "3",
            "organizationId": "1627915514217107456",
            "organizationName": "黔江过境高速",
            "passTime": "1",
            "pnode": "104",
            "provinceId": "CQ",
            "sort": "143"
        },
        {
            "authCode": "100101010501",
            "level": "3",
            "organizationId": "1494144408961028096",
            "organizationName": "渝筑高速",
            "passTime": "1",
            "pnode": "105",
            "provinceId": "CQ",
            "sort": "151"
        },
        {
            "authCode": "100101011301",
            "level": "3",
            "organizationId": "1732569067509911552",
            "organizationName": "巫镇高速",
            "passTime": "1",
            "pnode": "106",
            "provinceId": "CQ",
            "sort": "161"
        },
        {
            "authCode": "100101020101",
            "level": "3",
            "organizationId": "1551973634565787637",
            "organizationName": "德遂高速",
            "passTime": "1",
            "pnode": "201",
            "provinceId": "SC",
            "sort": "211"
        },
        {
            "authCode": "100101020103",
            "level": "3",
            "organizationId": "1874639935017979904",
            "organizationName": "南潼、南充过境高速",
            "passTime": "1",
            "pnode": "201",
            "provinceId": "SC",
            "sort": "212"
        },
        {
            "authCode": "100101020102",
            "level": "3",
            "organizationId": "1551973634565787638",
            "organizationName": "内大高速",
            "passTime": "1",
            "pnode": "201",
            "provinceId": "SC",
            "sort": "213"
        },
        {
            "authCode": "100101020204",
            "level": "3",
            "organizationId": "41",
            "organizationName": "阆营高速",
            "passTime": "0",
            "pnode": "202",
            "provinceId": "SC",
            "sort": "221"
        },
        {
            "authCode": "100101020205",
            "level": "3",
            "organizationId": "42",
            "organizationName": "泸古高速",
            "passTime": "0",
            "pnode": "202",
            "provinceId": "SC",
            "sort": "222"
        },
        {
            "authCode": "100101170506",
            "level": "3",
            "organizationId": "1856626475273424896",
            "organizationName": "剑黎高速",
            "passTime": "1",
            "pnode": "705",
            "provinceId": "GZ",
            "sort": "311"
        },
        {
            "authCode": "100101170201",
            "level": "3",
            "organizationId": "29",
            "organizationName": "乌长高速",
            "passTime": "0",
            "pnode": "702",
            "provinceId": "GZ",
            "sort": "321"
        },
        {
            "authCode": "100101050101",
            "level": "3",
            "organizationId": "1551973630102081536",
            "organizationName": "昆楚高速",
            "passTime": "1",
            "pnode": "401",
            "provinceId": "YN",
            "sort": "411"
        },
        {
            "authCode": "100101050201",
            "level": "3",
            "organizationId": "25",
            "organizationName": "丘砚高速",
            "passTime": "0",
            "pnode": "402",
            "provinceId": "YN",
            "sort": "421"
        },
        {
            "authCode": "100101050302",
            "level": "3",
            "organizationId": "31",
            "organizationName": "陆寻高速",
            "passTime": "0",
            "pnode": "403",
            "provinceId": "YN",
            "sort": "432"
        },
        {
            "authCode": "100101050303",
            "level": "3",
            "organizationId": "32",
            "organizationName": "昆宜高速",
            "passTime": "0",
            "pnode": "403",
            "provinceId": "YN",
            "sort": "433"
        },
        {
            "authCode": "100101050701",
            "level": "3",
            "organizationId": "1551973635436790752",
            "organizationName": "三清高速",
            "passTime": "0",
            "pnode": "507",
            "provinceId": "YN",
            "sort": "434"
        }
    ]
});

// 获取用户菜单
Mock.mock(`${basePath}/permission/user-menu-list`, "get", {
    "success": true,
    "wrapList": true,
    "code": 0,
    "msg": "操作成功",
    "data": null,
    "dataList": [
        {
            "id": null,
            "code": "ZHSF",
            "name": "智慧收费",
            "parentId": null,
            "icon": null,
            "scope": null,
            "sort": 0,
            "type": null,
            "url": null,
            "externalLink": null,
            "redirect": null,
            "hide": null,
            "moduleCode": null,
            "remark": null,
            "children": [
                {
                    "id": "1440508244535619585",
                    "code": "SF",
                    "name": "收费系统",
                    "parentId": null,
                    "icon": null,
                    "scope": 1,
                    "sort": 4,
                    "type": 1,
                    "url": "/charge",
                    "externalLink": "http://183.64.175.153:20003/?code=charge",
                    "redirect": null,
                    "hide": 0,
                    "moduleCode": "SF",
                    "remark": null,
                    "children": null,
                    "permissionList": null,
                    "isAdmin": null,
                    "smartField": 1
                }
            ],
            "permissionList": null,
            "isAdmin": null,
            "smartField": null
        },
        {
            "id": null,
            "code": "ZHYX",
            "name": "智慧运行",
            "parentId": null,
            "icon": null,
            "scope": null,
            "sort": 0,
            "type": null,
            "url": null,
            "externalLink": null,
            "redirect": null,
            "hide": null,
            "moduleCode": null,
            "remark": null,
            "children": [
                {
                    "id": "1302891804012285954",
                    "code": "GIS",
                    "name": "巡查救援",
                    "parentId": null,
                    "icon": null,
                    "scope": 1,
                    "sort": 2,
                    "type": 1,
                    "url": null,
                    "externalLink": "http://183.64.175.153:28882/#/",
                    "redirect": null,
                    "hide": 0,
                    "moduleCode": "GIS",
                    "remark": "",
                    "children": [
                        {
                            "id": "717430206062657536",
                            "code": "commandCenter",
                            "name": "指挥调度",
                            "parentId": "1302891804012285954",
                            "icon": "",
                            "scope": 1,
                            "sort": 1,
                            "type": 2,
                            "url": "/command-center",
                            "externalLink": null,
                            "redirect": "/command-center/realtime",
                            "hide": 0,
                            "moduleCode": "GIS",
                            "remark": null,
                            "children": [
                                {
                                    "id": "717430914740649984",
                                    "code": "command",
                                    "name": "任务调度",
                                    "parentId": "717430206062657536",
                                    "icon": "",
                                    "scope": 1,
                                    "sort": 4,
                                    "type": 2,
                                    "url": "/command-center/command",
                                    "externalLink": null,
                                    "redirect": "",
                                    "hide": 0,
                                    "moduleCode": "GIS",
                                    "remark": null,
                                    "children": null,
                                    "permissionList": null,
                                    "isAdmin": null,
                                    "smartField": 4
                                },
                                {
                                    "id": "717429970623791104",
                                    "code": "realtime",
                                    "name": "实时监控",
                                    "parentId": "717430206062657536",
                                    "icon": "",
                                    "scope": 1,
                                    "sort": 5,
                                    "type": 2,
                                    "url": "/command-center/realtime",
                                    "externalLink": null,
                                    "redirect": "",
                                    "hide": 0,
                                    "moduleCode": "GIS",
                                    "remark": null,
                                    "children": null,
                                    "permissionList": null,
                                    "isAdmin": null,
                                    "smartField": 4
                                },
                                {
                                    "id": "1349175037511000065",
                                    "code": "hotlines",
                                    "name": "热线列表",
                                    "parentId": "717430206062657536",
                                    "icon": "",
                                    "scope": 1,
                                    "sort": 6,
                                    "type": 2,
                                    "url": "/command-center/hotlines",
                                    "externalLink": "",
                                    "redirect": "",
                                    "hide": 1,
                                    "moduleCode": "GIS",
                                    "remark": "",
                                    "children": null,
                                    "permissionList": null,
                                    "isAdmin": null,
                                    "smartField": 4
                                },
                                {
                                    "id": "717431073297924096",
                                    "code": "events",
                                    "name": "事件列表",
                                    "parentId": "717430206062657536",
                                    "icon": "",
                                    "scope": 1,
                                    "sort": 7,
                                    "type": 2,
                                    "url": "/command-center/events",
                                    "externalLink": null,
                                    "redirect": "",
                                    "hide": 0,
                                    "moduleCode": "GIS",
                                    "remark": null,
                                    "children": null,
                                    "permissionList": null,
                                    "isAdmin": null,
                                    "smartField": 4
                                },
                                {
                                    "id": "1303592313102774274",
                                    "code": "TaskMonitor",
                                    "name": "任务状态",
                                    "parentId": "717430206062657536",
                                    "icon": "",
                                    "scope": 1,
                                    "sort": 8,
                                    "type": 2,
                                    "url": "/command-center/task-monitor",
                                    "externalLink": "",
                                    "redirect": "",
                                    "hide": 0,
                                    "moduleCode": "GIS",
                                    "remark": "",
                                    "children": null,
                                    "permissionList": null,
                                    "isAdmin": null,
                                    "smartField": 4
                                },
                                {
                                    "id": "1423098419981488129",
                                    "code": "cameras",
                                    "name": "视频监控",
                                    "parentId": "717430206062657536",
                                    "icon": "",
                                    "scope": 1,
                                    "sort": 10,
                                    "type": 2,
                                    "url": "/command-center/cameras",
                                    "externalLink": "",
                                    "redirect": "",
                                    "hide": 0,
                                    "moduleCode": "GIS",
                                    "remark": "",
                                    "children": null,
                                    "permissionList": null,
                                    "isAdmin": null,
                                    "smartField": 2
                                },
                                {
                                    "id": "1356166386592448513",
                                    "code": "vehicleStatus",
                                    "name": "出车记录",
                                    "parentId": "717430206062657536",
                                    "icon": "",
                                    "scope": 1,
                                    "sort": 10,
                                    "type": 2,
                                    "url": "/command-center/vehicleStatus",
                                    "externalLink": "",
                                    "redirect": "",
                                    "hide": 0,
                                    "moduleCode": "GIS",
                                    "remark": "",
                                    "children": null,
                                    "permissionList": null,
                                    "isAdmin": null,
                                    "smartField": 4
                                },
                                {
                                    "id": "1423482916069609474",
                                    "code": "monitor",
                                    "name": "监测",
                                    "parentId": "717430206062657536",
                                    "icon": "",
                                    "scope": 1,
                                    "sort": 11,
                                    "type": 2,
                                    "url": "/command-center/monitor",
                                    "externalLink": "",
                                    "redirect": "/command-center/monitor/running-monitor",
                                    "hide": 0,
                                    "moduleCode": "GIS",
                                    "remark": "",
                                    "children": [
                                        {
                                            "id": "1427823137879932930",
                                            "code": "QL.runningMonitor",
                                            "name": "运行监测",
                                            "parentId": "1423482916069609474",
                                            "icon": "",
                                            "scope": 1,
                                            "sort": 1,
                                            "type": 2,
                                            "url": "/command-center/monitor/running-monitor",
                                            "externalLink": "https://edtest.cmylsf.com:11443/ed/index.html#/monitor/running-monitor?token=#token#&showSidebar=false",
                                            "redirect": "",
                                            "hide": 0,
                                            "moduleCode": "GIS",
                                            "remark": "",
                                            "children": null,
                                            "permissionList": null,
                                            "isAdmin": null,
                                            "smartField": 2
                                        },
                                        {
                                            "id": "1427822658236104705",
                                            "code": "QL.weatherMonitor",
                                            "name": "气象监测",
                                            "parentId": "1423482916069609474",
                                            "icon": "",
                                            "scope": 1,
                                            "sort": 2,
                                            "type": 2,
                                            "url": "/command-center/monitor/weather-monitor",
                                            "externalLink": "https://edtest.cmylsf.com:11443/ed/index.html#/monitor/weather-monitor?token=#token#&showSidebar=false",
                                            "redirect": "",
                                            "hide": 0,
                                            "moduleCode": "GIS",
                                            "remark": "",
                                            "children": null,
                                            "permissionList": null,
                                            "isAdmin": null,
                                            "smartField": 4
                                        },
                                        {
                                            "id": "1427823682577416193",
                                            "code": "QL.testBridge",
                                            "name": "桥梁结构监测",
                                            "parentId": "1423482916069609474",
                                            "icon": "",
                                            "scope": 1,
                                            "sort": 3,
                                            "type": 2,
                                            "url": "/command-center/monitor/test-bridge",
                                            "externalLink": "https://edtest.cmylsf.com:11443/ed/index.html#/monitor/test-bridge?token=#token#&showSidebar=false",
                                            "redirect": "",
                                            "hide": 0,
                                            "moduleCode": "GIS",
                                            "remark": "",
                                            "children": null,
                                            "permissionList": null,
                                            "isAdmin": null,
                                            "smartField": 4
                                        },
                                        {
                                            "id": "1427823991118807041",
                                            "code": "QL.videoMonitor",
                                            "name": "视频监测",
                                            "parentId": "1423482916069609474",
                                            "icon": "",
                                            "scope": 1,
                                            "sort": 4,
                                            "type": 2,
                                            "url": "/command-center/monitor/video-monitor",
                                            "externalLink": "https://edtest.cmylsf.com:11443/ed/index.html#/monitor/video-monitor?token=#token#&showSidebar=false",
                                            "redirect": "",
                                            "hide": 0,
                                            "moduleCode": "GIS",
                                            "remark": "",
                                            "children": null,
                                            "permissionList": null,
                                            "isAdmin": null,
                                            "smartField": 4
                                        },
                                        {
                                            "id": "1427824267074650114",
                                            "code": "QL.channelMonitor",
                                            "name": "航道监测",
                                            "parentId": "1423482916069609474",
                                            "icon": "",
                                            "scope": 1,
                                            "sort": 5,
                                            "type": 2,
                                            "url": "/command-center/monitor/channel-monitor",
                                            "externalLink": "https://edtest.cmylsf.com:11443/ed/index.html#/monitor/channel-monitor?token=#token#&showSidebar=false",
                                            "redirect": "",
                                            "hide": 0,
                                            "moduleCode": "GIS",
                                            "remark": "",
                                            "children": null,
                                            "permissionList": null,
                                            "isAdmin": null,
                                            "smartField": 4
                                        }
                                    ],
                                    "permissionList": null,
                                    "isAdmin": null,
                                    "smartField": 4
                                },
                                {
                                    "id": "1357146564080631809",
                                    "code": "rtcConference",
                                    "name": "视频会商",
                                    "parentId": "717430206062657536",
                                    "icon": "",
                                    "scope": 1,
                                    "sort": 11,
                                    "type": 2,
                                    "url": "/command-center/command/chat",
                                    "externalLink": "",
                                    "redirect": "",
                                    "hide": 0,
                                    "moduleCode": "GIS",
                                    "remark": "",
                                    "children": null,
                                    "permissionList": null,
                                    "isAdmin": null,
                                    "smartField": 4
                                },
                                {
                                    "id": "1314751688009773058",
                                    "code": "eventReport",
                                    "name": "统计分析",
                                    "parentId": "717430206062657536",
                                    "icon": "",
                                    "scope": 1,
                                    "sort": 12,
                                    "type": 2,
                                    "url": "/command-center/event-report",
                                    "externalLink": "",
                                    "redirect": "",
                                    "hide": 0,
                                    "moduleCode": "GIS",
                                    "remark": "",
                                    "children": null,
                                    "permissionList": null,
                                    "isAdmin": null,
                                    "smartField": 4
                                }
                            ],
                            "permissionList": null,
                            "isAdmin": null,
                            "smartField": 4
                        },
                        {
                            "id": "1654389896124583937",
                            "code": "cameraPatrol",
                            "name": "视频巡检",
                            "parentId": "1302891804012285954",
                            "icon": "",
                            "scope": 1,
                            "sort": 3,
                            "type": 2,
                            "url": "/camera-patrol",
                            "externalLink": "",
                            "redirect": "/camera-patrol/cameras",
                            "hide": 0,
                            "moduleCode": "GIS",
                            "remark": "",
                            "children": [
                                {
                                    "id": "1654390908944142338",
                                    "code": "cameras",
                                    "name": "视频巡检",
                                    "parentId": "1654389896124583937",
                                    "icon": "",
                                    "scope": 1,
                                    "sort": 1,
                                    "type": 2,
                                    "url": "/camera-patrol/cameras",
                                    "externalLink": "",
                                    "redirect": "",
                                    "hide": 0,
                                    "moduleCode": "GIS",
                                    "remark": "",
                                    "children": null,
                                    "permissionList": null,
                                    "isAdmin": null,
                                    "smartField": 4
                                },
                                {
                                    "id": "1654391202885160962",
                                    "code": "cameraPatrolRecords",
                                    "name": "巡检记录",
                                    "parentId": "1654389896124583937",
                                    "icon": "",
                                    "scope": 1,
                                    "sort": 2,
                                    "type": 2,
                                    "url": "/camera-patrol/records",
                                    "externalLink": "",
                                    "redirect": "",
                                    "hide": 0,
                                    "moduleCode": "GIS",
                                    "remark": "",
                                    "children": null,
                                    "permissionList": null,
                                    "isAdmin": null,
                                    "smartField": 4
                                }
                            ],
                            "permissionList": null,
                            "isAdmin": null,
                            "smartField": 4
                        },
                        {
                            "id": "717431223282040832",
                            "code": "patrol",
                            "name": "道路巡查",
                            "parentId": "1302891804012285954",
                            "icon": "",
                            "scope": 1,
                            "sort": 4,
                            "type": 2,
                            "url": "/patrol",
                            "externalLink": null,
                            "redirect": "/patrol/routes",
                            "hide": 0,
                            "moduleCode": "GIS",
                            "remark": null,
                            "children": [
                                {
                                    "id": "717431581819535360",
                                    "code": "watch",
                                    "name": "巡查记录",
                                    "parentId": "717431223282040832",
                                    "icon": "",
                                    "scope": 1,
                                    "sort": 3,
                                    "type": 2,
                                    "url": "/patrol/tasks",
                                    "externalLink": null,
                                    "redirect": "",
                                    "hide": 0,
                                    "moduleCode": "GIS",
                                    "remark": null,
                                    "children": null,
                                    "permissionList": null,
                                    "isAdmin": null,
                                    "smartField": 4
                                },
                                {
                                    "id": "717431389221289984",
                                    "code": "routeConfiguration",
                                    "name": "线路配置",
                                    "parentId": "717431223282040832",
                                    "icon": "",
                                    "scope": 1,
                                    "sort": 10,
                                    "type": 2,
                                    "url": "/patrol/routes",
                                    "externalLink": null,
                                    "redirect": "",
                                    "hide": 0,
                                    "moduleCode": "GIS",
                                    "remark": null,
                                    "children": null,
                                    "permissionList": null,
                                    "isAdmin": null,
                                    "smartField": 4
                                },
                                {
                                    "id": "1413314211859861505",
                                    "code": "patrolStatistics",
                                    "name": "统计分析",
                                    "parentId": "717431223282040832",
                                    "icon": "",
                                    "scope": 1,
                                    "sort": 10,
                                    "type": 2,
                                    "url": "/patrol/statistics",
                                    "externalLink": "",
                                    "redirect": "",
                                    "hide": 0,
                                    "moduleCode": "GIS",
                                    "remark": "",
                                    "children": null,
                                    "permissionList": null,
                                    "isAdmin": null,
                                    "smartField": 4
                                }
                            ],
                            "permissionList": null,
                            "isAdmin": null,
                            "smartField": 4
                        },
                        {
                            "id": "717432545595097088",
                            "code": "wreckerService",
                            "name": "清障管理",
                            "parentId": "1302891804012285954",
                            "icon": "",
                            "scope": 1,
                            "sort": 5,
                            "type": 2,
                            "url": "/wrecker-service",
                            "externalLink": null,
                            "redirect": "/wrecker-service/scheduling",
                            "hide": 0,
                            "moduleCode": "GIS",
                            "remark": null,
                            "children": [
                                {
                                    "id": "717432709500108800",
                                    "code": "scheduling",
                                    "name": "人车匹配",
                                    "parentId": "717432545595097088",
                                    "icon": "",
                                    "scope": 1,
                                    "sort": 4,
                                    "type": 2,
                                    "url": "/wrecker-service/scheduling",
                                    "externalLink": null,
                                    "redirect": "",
                                    "hide": 0,
                                    "moduleCode": "GIS",
                                    "remark": null,
                                    "children": null,
                                    "permissionList": null,
                                    "isAdmin": null,
                                    "smartField": 4
                                },
                                {
                                    "id": "1597474257709899778",
                                    "code": "smartTerminalConfig",
                                    "name": "车辆终端策略",
                                    "parentId": "717432545595097088",
                                    "icon": "",
                                    "scope": 1,
                                    "sort": 10,
                                    "type": 2,
                                    "url": "/wrecker-service/smart-terminal-config",
                                    "externalLink": "",
                                    "redirect": "",
                                    "hide": 0,
                                    "moduleCode": "GIS",
                                    "remark": "",
                                    "children": null,
                                    "permissionList": null,
                                    "isAdmin": null,
                                    "smartField": 4
                                },
                                {
                                    "id": "717433025712881664",
                                    "code": "wreckerServiceTasks",
                                    "name": "任务单",
                                    "parentId": "717432545595097088",
                                    "icon": "",
                                    "scope": 1,
                                    "sort": 10,
                                    "type": 2,
                                    "url": "/wrecker-service/tasks",
                                    "externalLink": null,
                                    "redirect": "",
                                    "hide": 0,
                                    "moduleCode": "GIS",
                                    "remark": null,
                                    "children": null,
                                    "permissionList": null,
                                    "isAdmin": null,
                                    "smartField": 4
                                },
                                {
                                    "id": "717683482955874304",
                                    "code": "statistics",
                                    "name": "统计分析",
                                    "parentId": "717432545595097088",
                                    "icon": "",
                                    "scope": 1,
                                    "sort": 10,
                                    "type": 2,
                                    "url": "/wrecker-service/statistics",
                                    "externalLink": null,
                                    "redirect": "",
                                    "hide": 0,
                                    "moduleCode": "GIS",
                                    "remark": null,
                                    "children": null,
                                    "permissionList": null,
                                    "isAdmin": null,
                                    "smartField": 4
                                }
                            ],
                            "permissionList": null,
                            "isAdmin": null,
                            "smartField": 4
                        },
                        {
                            "id": "717433230944370688",
                            "code": "damageRecovery",
                            "name": "路损追偿",
                            "parentId": "1302891804012285954",
                            "icon": "",
                            "scope": 1,
                            "sort": 6,
                            "type": 2,
                            "url": "/damage-recovery",
                            "externalLink": null,
                            "redirect": "/damage-recovery/items",
                            "hide": 0,
                            "moduleCode": "GIS",
                            "remark": null,
                            "children": [
                                {
                                    "id": "717433544661532672",
                                    "code": "tasks",
                                    "name": "任务单",
                                    "parentId": "717433230944370688",
                                    "icon": "",
                                    "scope": 1,
                                    "sort": 3,
                                    "type": 2,
                                    "url": "/damage-recovery/tasks",
                                    "externalLink": null,
                                    "redirect": "",
                                    "hide": 0,
                                    "moduleCode": "GIS",
                                    "remark": null,
                                    "children": null,
                                    "permissionList": null,
                                    "isAdmin": null,
                                    "smartField": 4
                                },
                                {
                                    "id": "717433393448484864",
                                    "code": "priceLibrary",
                                    "name": "价格库",
                                    "parentId": "717433230944370688",
                                    "icon": "",
                                    "scope": 1,
                                    "sort": 5,
                                    "type": 2,
                                    "url": "/damage-recovery/items",
                                    "externalLink": null,
                                    "redirect": "",
                                    "hide": 0,
                                    "moduleCode": "GIS",
                                    "remark": null,
                                    "children": null,
                                    "permissionList": null,
                                    "isAdmin": null,
                                    "smartField": 4
                                },
                                {
                                    "id": "1348899011191062530",
                                    "code": "damageRecoverStatistics",
                                    "name": "统计分析",
                                    "parentId": "717433230944370688",
                                    "icon": "",
                                    "scope": 1,
                                    "sort": 10,
                                    "type": 2,
                                    "url": "/damage-recovery/statistics",
                                    "externalLink": "",
                                    "redirect": "",
                                    "hide": 0,
                                    "moduleCode": "GIS",
                                    "remark": "",
                                    "children": null,
                                    "permissionList": null,
                                    "isAdmin": null,
                                    "smartField": 4
                                }
                            ],
                            "permissionList": null,
                            "isAdmin": null,
                            "smartField": 4
                        },
                        {
                            "id": "735153366413344768",
                            "code": "sceneManagement",
                            "name": "现场处置",
                            "parentId": "1302891804012285954",
                            "icon": "",
                            "scope": 1,
                            "sort": 8,
                            "type": 2,
                            "url": "/scene-management",
                            "externalLink": null,
                            "redirect": "/scene-management/tasks",
                            "hide": 0,
                            "moduleCode": "GIS",
                            "remark": null,
                            "children": [
                                {
                                    "id": "735158442154524672",
                                    "code": "sceneManagementTasks",
                                    "name": "任务单",
                                    "parentId": "735153366413344768",
                                    "icon": "",
                                    "scope": 1,
                                    "sort": 10,
                                    "type": 2,
                                    "url": "warning-before/tasks",
                                    "externalLink": null,
                                    "redirect": "",
                                    "hide": 0,
                                    "moduleCode": "GIS",
                                    "remark": null,
                                    "children": null,
                                    "permissionList": null,
                                    "isAdmin": null,
                                    "smartField": 4
                                }
                            ],
                            "permissionList": null,
                            "isAdmin": null,
                            "smartField": 4
                        },
                        {
                            "id": "742388292007231488",
                            "code": "clean",
                            "name": "养护管理",
                            "parentId": "1302891804012285954",
                            "icon": "",
                            "scope": 1,
                            "sort": 9,
                            "type": 2,
                            "url": "/clean",
                            "externalLink": null,
                            "redirect": "/clean/tasks",
                            "hide": 0,
                            "moduleCode": "GIS",
                            "remark": null,
                            "children": [
                                {
                                    "id": "742388471435362304",
                                    "code": "cleanTask",
                                    "name": "任务单",
                                    "parentId": "742388292007231488",
                                    "icon": "",
                                    "scope": 1,
                                    "sort": 2,
                                    "type": 2,
                                    "url": "/clean/tasks",
                                    "externalLink": null,
                                    "redirect": "",
                                    "hide": 0,
                                    "moduleCode": "GIS",
                                    "remark": null,
                                    "children": null,
                                    "permissionList": null,
                                    "isAdmin": null,
                                    "smartField": 4
                                },
                                {
                                    "id": "1431074714791157761",
                                    "code": "repairTask",
                                    "name": "维修任务单",
                                    "parentId": "742388292007231488",
                                    "icon": "",
                                    "scope": 1,
                                    "sort": 3,
                                    "type": 2,
                                    "url": "/clean/repair-task",
                                    "externalLink": "",
                                    "redirect": "",
                                    "hide": 0,
                                    "moduleCode": "GIS",
                                    "remark": "",
                                    "children": null,
                                    "permissionList": null,
                                    "isAdmin": null,
                                    "smartField": 4
                                },
                                {
                                    "id": "1336559617146863618",
                                    "code": "cleanTaskStatistics",
                                    "name": "统计分析",
                                    "parentId": "742388292007231488",
                                    "icon": "",
                                    "scope": 1,
                                    "sort": 10,
                                    "type": 2,
                                    "url": "/clean/cleanTaskStatistics",
                                    "externalLink": "",
                                    "redirect": "",
                                    "hide": 0,
                                    "moduleCode": "GIS",
                                    "remark": "",
                                    "children": null,
                                    "permissionList": null,
                                    "isAdmin": null,
                                    "smartField": 4
                                }
                            ],
                            "permissionList": null,
                            "isAdmin": null,
                            "smartField": 4
                        },
                        {
                            "id": "1324239135634550785",
                            "code": "tollStation",
                            "name": "站务管理",
                            "parentId": "1302891804012285954",
                            "icon": "",
                            "scope": 1,
                            "sort": 10,
                            "type": 2,
                            "url": "/toll-station",
                            "externalLink": "",
                            "redirect": "/toll-station/taskRelated",
                            "hide": 0,
                            "moduleCode": "GIS",
                            "remark": "",
                            "children": [
                                {
                                    "id": "1544506471493603329",
                                    "code": "taskRelated",
                                    "name": "站务任务",
                                    "parentId": "1324239135634550785",
                                    "icon": "",
                                    "scope": 1,
                                    "sort": 1,
                                    "type": 2,
                                    "url": "/toll-station/taskRelated",
                                    "externalLink": "",
                                    "redirect": "/toll-station/taskRelated/traffic-limit-task",
                                    "hide": 0,
                                    "moduleCode": "GIS",
                                    "remark": "",
                                    "children": [
                                        {
                                            "id": "1324239398944567297",
                                            "code": "trafficLimitTask",
                                            "name": "封道限流",
                                            "parentId": "1544506471493603329",
                                            "icon": "",
                                            "scope": 1,
                                            "sort": 2,
                                            "type": 2,
                                            "url": "/toll-station/taskRelated/traffic-limit-task",
                                            "externalLink": "",
                                            "redirect": "",
                                            "hide": 0,
                                            "moduleCode": "GIS",
                                            "remark": "",
                                            "children": null,
                                            "permissionList": null,
                                            "isAdmin": null,
                                            "smartField": 4
                                        },
                                        {
                                            "id": "1325983713970524161",
                                            "code": "assistCarTask",
                                            "name": "协查车",
                                            "parentId": "1544506471493603329",
                                            "icon": "",
                                            "scope": 1,
                                            "sort": 3,
                                            "type": 2,
                                            "url": "/toll-station/taskRelated/assist-car-task",
                                            "externalLink": "",
                                            "redirect": "",
                                            "hide": 0,
                                            "moduleCode": "GIS",
                                            "remark": "",
                                            "children": null,
                                            "permissionList": null,
                                            "isAdmin": null,
                                            "smartField": 4
                                        },
                                        {
                                            "id": "1324239888193351681",
                                            "code": "missionCarTask",
                                            "name": "临免车",
                                            "parentId": "1544506471493603329",
                                            "icon": "",
                                            "scope": 1,
                                            "sort": 4,
                                            "type": 2,
                                            "url": "/toll-station/taskRelated/mission-car-task",
                                            "externalLink": "",
                                            "redirect": "",
                                            "hide": 0,
                                            "moduleCode": "GIS",
                                            "remark": "",
                                            "children": null,
                                            "permissionList": null,
                                            "isAdmin": null,
                                            "smartField": 4
                                        },
                                        {
                                            "id": "1344204075321466882",
                                            "code": "ShuntTask",
                                            "name": "分流",
                                            "parentId": "1544506471493603329",
                                            "icon": "",
                                            "scope": 1,
                                            "sort": 5,
                                            "type": 2,
                                            "url": "/toll-station/taskRelated/shunt-task",
                                            "externalLink": "",
                                            "redirect": "",
                                            "hide": 0,
                                            "moduleCode": "GIS",
                                            "remark": "",
                                            "children": null,
                                            "permissionList": null,
                                            "isAdmin": null,
                                            "smartField": 4
                                        },
                                        {
                                            "id": "1374622693175537666",
                                            "code": "DrainageTask",
                                            "name": "引流",
                                            "parentId": "1544506471493603329",
                                            "icon": "",
                                            "scope": 1,
                                            "sort": 9,
                                            "type": 2,
                                            "url": "/toll-station/taskRelated/drainage-task",
                                            "externalLink": "",
                                            "redirect": "",
                                            "hide": 0,
                                            "moduleCode": "GIS",
                                            "remark": "",
                                            "children": null,
                                            "permissionList": null,
                                            "isAdmin": null,
                                            "smartField": 4
                                        }
                                    ],
                                    "permissionList": null,
                                    "isAdmin": null,
                                    "smartField": 4
                                },
                                {
                                    "id": "1562262159110836226",
                                    "code": "station/incomeIncrease",
                                    "name": "应征不漏",
                                    "parentId": "1324239135634550785",
                                    "icon": "",
                                    "scope": 1,
                                    "sort": 12,
                                    "type": 2,
                                    "url": "station/incomeIncrease",
                                    "externalLink": "",
                                    "redirect": "",
                                    "hide": 0,
                                    "moduleCode": "GIS",
                                    "remark": "",
                                    "children": [
                                        {
                                            "id": "1328172437185626113",
                                            "code": "incomeIncreaseCustom",
                                            "name": "应征不漏配置",
                                            "parentId": "1562262159110836226",
                                            "icon": "",
                                            "scope": 1,
                                            "sort": 10,
                                            "type": 2,
                                            "url": "/toll-station/income-increase/custom",
                                            "externalLink": "",
                                            "redirect": "",
                                            "hide": 0,
                                            "moduleCode": "GIS",
                                            "remark": "",
                                            "children": null,
                                            "permissionList": null,
                                            "isAdmin": null,
                                            "smartField": 4
                                        },
                                        {
                                            "id": "1328172670535729153",
                                            "code": "incomeIncreaseTasks",
                                            "name": "应征不漏奖励",
                                            "parentId": "1562262159110836226",
                                            "icon": "",
                                            "scope": 1,
                                            "sort": 11,
                                            "type": 2,
                                            "url": "/toll-station/income-increase/tasks",
                                            "externalLink": "",
                                            "redirect": "",
                                            "hide": 0,
                                            "moduleCode": "GIS",
                                            "remark": "",
                                            "children": null,
                                            "permissionList": null,
                                            "isAdmin": null,
                                            "smartField": 4
                                        }
                                    ],
                                    "permissionList": null,
                                    "isAdmin": null,
                                    "smartField": 4
                                },
                                {
                                    "id": "1331125882989445121",
                                    "code": "monitorNotes",
                                    "name": "班长日志",
                                    "parentId": "1324239135634550785",
                                    "icon": "",
                                    "scope": 1,
                                    "sort": 13,
                                    "type": 2,
                                    "url": "/toll-station/monitor-notes",
                                    "externalLink": "",
                                    "redirect": "",
                                    "hide": 0,
                                    "moduleCode": "GIS",
                                    "remark": "",
                                    "children": null,
                                    "permissionList": null,
                                    "isAdmin": null,
                                    "smartField": 4
                                },
                                {
                                    "id": "1340910603827109890",
                                    "code": "TollLangsView",
                                    "name": "车道查看",
                                    "parentId": "1324239135634550785",
                                    "icon": "",
                                    "scope": 1,
                                    "sort": 14,
                                    "type": 2,
                                    "url": "/toll-station/toll-langs-view",
                                    "externalLink": "",
                                    "redirect": "",
                                    "hide": 0,
                                    "moduleCode": "GIS",
                                    "remark": "",
                                    "children": null,
                                    "permissionList": null,
                                    "isAdmin": null,
                                    "smartField": 4
                                },
                                {
                                    "id": "1349255964123652098",
                                    "code": "blockAndLimitStatistics",
                                    "name": "统计分析",
                                    "parentId": "1324239135634550785",
                                    "icon": "",
                                    "scope": 1,
                                    "sort": 14,
                                    "type": 2,
                                    "url": "/toll-station/blockAndLimitStatistics",
                                    "externalLink": "",
                                    "redirect": "",
                                    "hide": 0,
                                    "moduleCode": "GIS",
                                    "remark": "",
                                    "children": null,
                                    "permissionList": null,
                                    "isAdmin": null,
                                    "smartField": 4
                                },
                                {
                                    "id": "1397486357448364034",
                                    "code": "StationItemDelivery",
                                    "name": "站务物品交接",
                                    "parentId": "1324239135634550785",
                                    "icon": "",
                                    "scope": 1,
                                    "sort": 16,
                                    "type": 2,
                                    "url": "/toll-station/station-item-delivery",
                                    "externalLink": "",
                                    "redirect": "",
                                    "hide": 0,
                                    "moduleCode": "GIS",
                                    "remark": "",
                                    "children": null,
                                    "permissionList": null,
                                    "isAdmin": null,
                                    "smartField": 4
                                },
                                {
                                    "id": "1427140986679246850",
                                    "code": "assessmentManagement",
                                    "name": "营运考核",
                                    "parentId": "1324239135634550785",
                                    "icon": "",
                                    "scope": 1,
                                    "sort": 17,
                                    "type": 2,
                                    "url": "/assessment-management",
                                    "externalLink": "",
                                    "redirect": "/assessment-management/grading-log",
                                    "hide": 0,
                                    "moduleCode": "GIS",
                                    "remark": "",
                                    "children": [
                                        {
                                            "id": "1427639198586421249",
                                            "code": "assessmentGradingLog",
                                            "name": "考核评分",
                                            "parentId": "1427140986679246850",
                                            "icon": "",
                                            "scope": 1,
                                            "sort": 1,
                                            "type": 2,
                                            "url": "/assessment-management/grading-log",
                                            "externalLink": "",
                                            "redirect": "",
                                            "hide": 0,
                                            "moduleCode": "GIS",
                                            "remark": "",
                                            "children": null,
                                            "permissionList": null,
                                            "isAdmin": null,
                                            "smartField": 4
                                        },
                                        {
                                            "id": "1428247320980054017",
                                            "code": "assessmentRules",
                                            "name": "考核规则",
                                            "parentId": "1427140986679246850",
                                            "icon": "",
                                            "scope": 1,
                                            "sort": 3,
                                            "type": 2,
                                            "url": "/assessment-management/rules",
                                            "externalLink": "",
                                            "redirect": "",
                                            "hide": 0,
                                            "moduleCode": "GIS",
                                            "remark": "",
                                            "children": null,
                                            "permissionList": null,
                                            "isAdmin": null,
                                            "smartField": 4
                                        },
                                        {
                                            "id": "1511980892664074241",
                                            "code": "assessmentExamieList",
                                            "name": "评分审核",
                                            "parentId": "1427140986679246850",
                                            "icon": "",
                                            "scope": 1,
                                            "sort": 4,
                                            "type": 2,
                                            "url": "/assessment-management/examie-list",
                                            "externalLink": "",
                                            "redirect": "",
                                            "hide": 0,
                                            "moduleCode": "GIS",
                                            "remark": "",
                                            "children": null,
                                            "permissionList": null,
                                            "isAdmin": null,
                                            "smartField": 4
                                        },
                                        {
                                            "id": "1374181660826484738",
                                            "code": "assessmentStatistics",
                                            "name": "考核统计",
                                            "parentId": "1427140986679246850",
                                            "icon": "",
                                            "scope": 1,
                                            "sort": 15,
                                            "type": 2,
                                            "url": "/toll-station/assessmentStatistics",
                                            "externalLink": "",
                                            "redirect": "",
                                            "hide": 0,
                                            "moduleCode": "GIS",
                                            "remark": "",
                                            "children": null,
                                            "permissionList": null,
                                            "isAdmin": null,
                                            "smartField": 4
                                        },
                                        {
                                            "id": "1531186086056484865",
                                            "code": "assessmentManagementNew",
                                            "name": "微笑服务考核",
                                            "parentId": "1427140986679246850",
                                            "icon": "",
                                            "scope": 1,
                                            "sort": 18,
                                            "type": 2,
                                            "url": "/assessment-management-new",
                                            "externalLink": "",
                                            "redirect": "/assessment-management/newMode/grading-log",
                                            "hide": 0,
                                            "moduleCode": "GIS",
                                            "remark": "",
                                            "children": [
                                                {
                                                    "id": "1531186310334308354",
                                                    "code": "assessmentGradingLogNew",
                                                    "name": "考核评分",
                                                    "parentId": "1531186086056484865",
                                                    "icon": "",
                                                    "scope": 1,
                                                    "sort": 1,
                                                    "type": 2,
                                                    "url": "/assessment-management/newMode/grading-log",
                                                    "externalLink": "",
                                                    "redirect": "",
                                                    "hide": 0,
                                                    "moduleCode": "GIS",
                                                    "remark": "过车合格率",
                                                    "children": null,
                                                    "permissionList": null,
                                                    "isAdmin": null,
                                                    "smartField": 4
                                                },
                                                {
                                                    "id": "1531194607057690626",
                                                    "code": "assessmentExamineNew",
                                                    "name": "审核配置",
                                                    "parentId": "1531186086056484865",
                                                    "icon": "",
                                                    "scope": 1,
                                                    "sort": 3,
                                                    "type": 2,
                                                    "url": "/assessment-management/newMode/examine",
                                                    "externalLink": "",
                                                    "redirect": "",
                                                    "hide": 0,
                                                    "moduleCode": "GIS",
                                                    "remark": "",
                                                    "children": null,
                                                    "permissionList": null,
                                                    "isAdmin": null,
                                                    "smartField": 4
                                                },
                                                {
                                                    "id": "1531194900440866818",
                                                    "code": "assessmentExamieListNew",
                                                    "name": "评分审核",
                                                    "parentId": "1531186086056484865",
                                                    "icon": "",
                                                    "scope": 1,
                                                    "sort": 4,
                                                    "type": 2,
                                                    "url": "/assessment-management/newMode/examie-list",
                                                    "externalLink": "",
                                                    "redirect": "",
                                                    "hide": 0,
                                                    "moduleCode": "GIS",
                                                    "remark": "",
                                                    "children": null,
                                                    "permissionList": null,
                                                    "isAdmin": null,
                                                    "smartField": 4
                                                }
                                            ],
                                            "permissionList": null,
                                            "isAdmin": null,
                                            "smartField": 4
                                        }
                                    ],
                                    "permissionList": null,
                                    "isAdmin": null,
                                    "smartField": 4
                                }
                            ],
                            "permissionList": null,
                            "isAdmin": null,
                            "smartField": 4
                        },
                        {
                            "id": "1325700672496812033",
                            "code": "complaintAndSuggestion",
                            "name": "投诉建议",
                            "parentId": "1302891804012285954",
                            "icon": "",
                            "scope": 1,
                            "sort": 13,
                            "type": 2,
                            "url": "/complaint-and-suggestion",
                            "externalLink": "",
                            "redirect": "/complaint-and-suggestion/complaints",
                            "hide": 0,
                            "moduleCode": "GIS",
                            "remark": "",
                            "children": [
                                {
                                    "id": "1325701023560056834",
                                    "code": "complaints",
                                    "name": "投诉单",
                                    "parentId": "1325700672496812033",
                                    "icon": "",
                                    "scope": 1,
                                    "sort": 1,
                                    "type": 2,
                                    "url": "/complaint-and-suggestion/complaints",
                                    "externalLink": "",
                                    "redirect": "",
                                    "hide": 0,
                                    "moduleCode": "GIS",
                                    "remark": "",
                                    "children": null,
                                    "permissionList": null,
                                    "isAdmin": null,
                                    "smartField": 4
                                }
                            ],
                            "permissionList": null,
                            "isAdmin": null,
                            "smartField": 4
                        },
                        {
                            "id": "1396702362804666370",
                            "code": "shiftDelivery",
                            "name": "营运交接",
                            "parentId": "1302891804012285954",
                            "icon": "",
                            "scope": 1,
                            "sort": 14,
                            "type": 2,
                            "url": "/service-shift",
                            "externalLink": "",
                            "redirect": "/service-shift/delivery-note",
                            "hide": 0,
                            "moduleCode": "GIS",
                            "remark": "",
                            "children": [
                                {
                                    "id": "1396702722814361602",
                                    "code": "deliveryNote",
                                    "name": "交接日志",
                                    "parentId": "1396702362804666370",
                                    "icon": "",
                                    "scope": 1,
                                    "sort": 1,
                                    "type": 2,
                                    "url": "/service-shift/delivery-note",
                                    "externalLink": "",
                                    "redirect": "",
                                    "hide": 0,
                                    "moduleCode": "GIS",
                                    "remark": "",
                                    "children": null,
                                    "permissionList": null,
                                    "isAdmin": null,
                                    "smartField": 4
                                },
                                {
                                    "id": "1396702932835745794",
                                    "code": "shiftItemDelivery",
                                    "name": "物品管理",
                                    "parentId": "1396702362804666370",
                                    "icon": "",
                                    "scope": 1,
                                    "sort": 2,
                                    "type": 2,
                                    "url": "/service-shift/service-item-delivery",
                                    "externalLink": "",
                                    "redirect": "",
                                    "hide": 0,
                                    "moduleCode": "GIS",
                                    "remark": "",
                                    "children": null,
                                    "permissionList": null,
                                    "isAdmin": null,
                                    "smartField": 4
                                },
                                {
                                    "id": "1396703033041862658",
                                    "code": "positionManagement",
                                    "name": "岗位配置",
                                    "parentId": "1396702362804666370",
                                    "icon": "",
                                    "scope": 1,
                                    "sort": 3,
                                    "type": 2,
                                    "url": "/service-shift/position-management",
                                    "externalLink": "",
                                    "redirect": "",
                                    "hide": 0,
                                    "moduleCode": "GIS",
                                    "remark": "",
                                    "children": null,
                                    "permissionList": null,
                                    "isAdmin": null,
                                    "smartField": 4
                                }
                            ],
                            "permissionList": null,
                            "isAdmin": null,
                            "smartField": 4
                        },
                        {
                            "id": "750003548766339072",
                            "code": "information",
                            "name": "信息管理",
                            "parentId": "1302891804012285954",
                            "icon": "",
                            "scope": 1,
                            "sort": 16,
                            "type": 2,
                            "url": "/information",
                            "externalLink": null,
                            "redirect": "/information/board",
                            "hide": 0,
                            "moduleCode": "GIS",
                            "remark": null,
                            "children": [
                                {
                                    "id": "750005114135117824",
                                    "code": "informationReview",
                                    "name": "信息审核",
                                    "parentId": "750003548766339072",
                                    "icon": "",
                                    "scope": 1,
                                    "sort": 10,
                                    "type": 2,
                                    "url": "/information/review",
                                    "externalLink": null,
                                    "redirect": "",
                                    "hide": 0,
                                    "moduleCode": "GIS",
                                    "remark": null,
                                    "children": null,
                                    "permissionList": null,
                                    "isAdmin": null,
                                    "smartField": 4
                                },
                                {
                                    "id": "750005276479848448",
                                    "code": "informationStatistics",
                                    "name": "信息发布统计",
                                    "parentId": "750003548766339072",
                                    "icon": "",
                                    "scope": 1,
                                    "sort": 10,
                                    "type": 2,
                                    "url": "/information/statistics",
                                    "externalLink": null,
                                    "redirect": "",
                                    "hide": 0,
                                    "moduleCode": "GIS",
                                    "remark": null,
                                    "children": null,
                                    "permissionList": null,
                                    "isAdmin": null,
                                    "smartField": 4
                                },
                                {
                                    "id": "750003802286850048",
                                    "code": "informationBoard",
                                    "name": "信息发布",
                                    "parentId": "750003548766339072",
                                    "icon": "",
                                    "scope": 1,
                                    "sort": 10,
                                    "type": 2,
                                    "url": "/information/board",
                                    "externalLink": null,
                                    "redirect": "",
                                    "hide": 0,
                                    "moduleCode": "GIS",
                                    "remark": null,
                                    "children": null,
                                    "permissionList": null,
                                    "isAdmin": null,
                                    "smartField": 4
                                }
                            ],
                            "permissionList": null,
                            "isAdmin": null,
                            "smartField": 4
                        },
                        {
                            "id": "717433722516799488",
                            "code": "weatherManagement",
                            "name": "气象管理",
                            "parentId": "1302891804012285954",
                            "icon": "",
                            "scope": 1,
                            "sort": 17,
                            "type": 2,
                            "url": "/weather-management",
                            "externalLink": null,
                            "redirect": "/weather-management/weather-information-inquire",
                            "hide": 0,
                            "moduleCode": "GIS",
                            "remark": null,
                            "children": [
                                {
                                    "id": "717434784095141888",
                                    "code": "gisWeatherInformation",
                                    "name": "GIS气象信息",
                                    "parentId": "717433722516799488",
                                    "icon": "",
                                    "scope": 1,
                                    "sort": 10,
                                    "type": 2,
                                    "url": "/weather-management/gis-weather-information",
                                    "externalLink": null,
                                    "redirect": "",
                                    "hide": 1,
                                    "moduleCode": "GIS",
                                    "remark": null,
                                    "children": null,
                                    "permissionList": null,
                                    "isAdmin": null,
                                    "smartField": 4
                                },
                                {
                                    "id": "717434665694134272",
                                    "code": "weatherInformationInquire",
                                    "name": "历史气象",
                                    "parentId": "717433722516799488",
                                    "icon": "",
                                    "scope": 1,
                                    "sort": 10,
                                    "type": 2,
                                    "url": "/weather-management/weather-information-inquire",
                                    "externalLink": null,
                                    "redirect": "",
                                    "hide": 0,
                                    "moduleCode": "GIS",
                                    "remark": null,
                                    "children": null,
                                    "permissionList": null,
                                    "isAdmin": null,
                                    "smartField": 4
                                }
                            ],
                            "permissionList": null,
                            "isAdmin": null,
                            "smartField": 4
                        },
                        {
                            "id": "717435194855915520",
                            "code": "system",
                            "name": "系统管理",
                            "parentId": "1302891804012285954",
                            "icon": "",
                            "scope": 1,
                            "sort": 18,
                            "type": 2,
                            "url": "/system",
                            "externalLink": null,
                            "redirect": "/system/custom-forms",
                            "hide": 0,
                            "moduleCode": "GIS",
                            "remark": null,
                            "children": [
                                {
                                    "id": "717436907880972288",
                                    "code": "customFormsAdd",
                                    "name": "新增自定义表单",
                                    "parentId": "717435194855915520",
                                    "icon": "",
                                    "scope": 1,
                                    "sort": 7,
                                    "type": 2,
                                    "url": "/system/custom-forms/add",
                                    "externalLink": null,
                                    "redirect": null,
                                    "hide": 1,
                                    "moduleCode": "GIS",
                                    "remark": null,
                                    "children": null,
                                    "permissionList": null,
                                    "isAdmin": null,
                                    "smartField": 4
                                },
                                {
                                    "id": "1337270767161425921",
                                    "code": "baseData",
                                    "name": "基础数据管理",
                                    "parentId": "717435194855915520",
                                    "icon": "",
                                    "scope": 1,
                                    "sort": 9,
                                    "type": 2,
                                    "url": "/system/base-data",
                                    "externalLink": "",
                                    "redirect": "/system/base-data/base-event-data",
                                    "hide": 0,
                                    "moduleCode": "GIS",
                                    "remark": "",
                                    "children": [
                                        {
                                            "id": "1473176957052653569",
                                            "code": "baseEventData",
                                            "name": "事件来源及类型",
                                            "parentId": "1337270767161425921",
                                            "icon": "",
                                            "scope": 1,
                                            "sort": 2,
                                            "type": 2,
                                            "url": "/system/base-data/base-event-data",
                                            "externalLink": "",
                                            "redirect": "",
                                            "hide": 0,
                                            "moduleCode": "GIS",
                                            "remark": "",
                                            "children": null,
                                            "permissionList": null,
                                            "isAdmin": null,
                                            "smartField": 4
                                        },
                                        {
                                            "id": "1473176605167325186",
                                            "code": "dictionaryCustom",
                                            "name": "数据字典",
                                            "parentId": "1337270767161425921",
                                            "icon": "",
                                            "scope": 1,
                                            "sort": 3,
                                            "type": 2,
                                            "url": "/system/base-data/dictionary-custom",
                                            "externalLink": "",
                                            "redirect": "",
                                            "hide": 0,
                                            "moduleCode": "GIS",
                                            "remark": "",
                                            "children": null,
                                            "permissionList": null,
                                            "isAdmin": null,
                                            "smartField": 4
                                        },
                                        {
                                            "id": "1546322300493332482",
                                            "code": "eventType",
                                            "name": "事件类型",
                                            "parentId": "1337270767161425921",
                                            "icon": "",
                                            "scope": 1,
                                            "sort": 4,
                                            "type": 2,
                                            "url": "/system/event-type",
                                            "externalLink": "",
                                            "redirect": "",
                                            "hide": 0,
                                            "moduleCode": "GIS",
                                            "remark": "",
                                            "children": null,
                                            "permissionList": null,
                                            "isAdmin": null,
                                            "smartField": 4
                                        },
                                        {
                                            "id": "1552212223963144194",
                                            "code": "eventTypeApply",
                                            "name": "事件类型应用",
                                            "parentId": "1337270767161425921",
                                            "icon": "",
                                            "scope": 1,
                                            "sort": 5,
                                            "type": 2,
                                            "url": "/system/event-type-apply",
                                            "externalLink": "",
                                            "redirect": "",
                                            "hide": 0,
                                            "moduleCode": "GIS",
                                            "remark": "",
                                            "children": null,
                                            "permissionList": null,
                                            "isAdmin": null,
                                            "smartField": 4
                                        }
                                    ],
                                    "permissionList": null,
                                    "isAdmin": null,
                                    "smartField": 4
                                },
                                {
                                    "id": "720216720282746880",
                                    "code": "workTeam",
                                    "name": "中队管理",
                                    "parentId": "717435194855915520",
                                    "icon": "",
                                    "scope": 1,
                                    "sort": 10,
                                    "type": 2,
                                    "url": "/system/workteam",
                                    "externalLink": null,
                                    "redirect": "",
                                    "hide": 0,
                                    "moduleCode": "GIS",
                                    "remark": null,
                                    "children": null,
                                    "permissionList": null,
                                    "isAdmin": null,
                                    "smartField": 4
                                },
                                {
                                    "id": "717435660817924096",
                                    "code": "customForms",
                                    "name": "自定义表单",
                                    "parentId": "717435194855915520",
                                    "icon": "",
                                    "scope": 1,
                                    "sort": 10,
                                    "type": 2,
                                    "url": "/system/custom-forms",
                                    "externalLink": null,
                                    "redirect": null,
                                    "hide": 0,
                                    "moduleCode": "GIS",
                                    "remark": null,
                                    "children": null,
                                    "permissionList": null,
                                    "isAdmin": null,
                                    "smartField": 4
                                },
                                {
                                    "id": "1333961628540620802",
                                    "code": "AppVersonManagement",
                                    "name": "app版本管理",
                                    "parentId": "717435194855915520",
                                    "icon": "",
                                    "scope": 1,
                                    "sort": 10,
                                    "type": 2,
                                    "url": "/system/app-verson-management",
                                    "externalLink": "",
                                    "redirect": "",
                                    "hide": 0,
                                    "moduleCode": "GIS",
                                    "remark": "",
                                    "children": null,
                                    "permissionList": null,
                                    "isAdmin": null,
                                    "smartField": 4
                                },
                                {
                                    "id": "717437778563956736",
                                    "code": "customFormsIdDesign",
                                    "name": "设计自定义表单",
                                    "parentId": "717435194855915520",
                                    "icon": null,
                                    "scope": 1,
                                    "sort": 10,
                                    "type": 2,
                                    "url": "/system/custom-forms/:id/design",
                                    "externalLink": null,
                                    "redirect": null,
                                    "hide": 1,
                                    "moduleCode": "GIS",
                                    "remark": null,
                                    "children": null,
                                    "permissionList": null,
                                    "isAdmin": null,
                                    "smartField": 4
                                },
                                {
                                    "id": "1339040956018266113",
                                    "code": "optionManagement",
                                    "name": "公司配置",
                                    "parentId": "717435194855915520",
                                    "icon": "",
                                    "scope": 1,
                                    "sort": 10,
                                    "type": 2,
                                    "url": "/system/optionManagement",
                                    "externalLink": "",
                                    "redirect": "",
                                    "hide": 0,
                                    "moduleCode": "GIS",
                                    "remark": "",
                                    "children": null,
                                    "permissionList": null,
                                    "isAdmin": null,
                                    "smartField": 4
                                },
                                {
                                    "id": "729700828436234240",
                                    "code": "plan",
                                    "name": "预案管理",
                                    "parentId": "717435194855915520",
                                    "icon": "",
                                    "scope": 1,
                                    "sort": 10,
                                    "type": 2,
                                    "url": "/emergency-management/plan",
                                    "externalLink": null,
                                    "redirect": "",
                                    "hide": 0,
                                    "moduleCode": "GIS",
                                    "remark": null,
                                    "children": null,
                                    "permissionList": null,
                                    "isAdmin": null,
                                    "smartField": 4
                                },
                                {
                                    "id": "720682281915645952",
                                    "code": "vehicle",
                                    "name": "车辆管理",
                                    "parentId": "717435194855915520",
                                    "icon": "",
                                    "scope": 1,
                                    "sort": 10,
                                    "type": 2,
                                    "url": "/system/vehicle",
                                    "externalLink": null,
                                    "redirect": "",
                                    "hide": 1,
                                    "moduleCode": "GIS",
                                    "remark": null,
                                    "children": null,
                                    "permissionList": null,
                                    "isAdmin": null,
                                    "smartField": 4
                                },
                                {
                                    "id": "1354673506761768962",
                                    "code": "vehicleManagement",
                                    "name": "车辆管理",
                                    "parentId": "717435194855915520",
                                    "icon": "",
                                    "scope": 1,
                                    "sort": 12,
                                    "type": 2,
                                    "url": "/system/vehicleManagement",
                                    "externalLink": "",
                                    "redirect": "",
                                    "hide": 0,
                                    "moduleCode": "GIS",
                                    "remark": "",
                                    "children": null,
                                    "permissionList": null,
                                    "isAdmin": null,
                                    "smartField": 4
                                },
                                {
                                    "id": "1376437760602882049",
                                    "code": "noticeConfig",
                                    "name": "通知配置",
                                    "parentId": "717435194855915520",
                                    "icon": "",
                                    "scope": 1,
                                    "sort": 13,
                                    "type": 2,
                                    "url": "/system/notice-config",
                                    "externalLink": "",
                                    "redirect": "",
                                    "hide": 0,
                                    "moduleCode": "GIS",
                                    "remark": "",
                                    "children": null,
                                    "permissionList": null,
                                    "isAdmin": null,
                                    "smartField": 4
                                },
                                {
                                    "id": "1419905486256009217",
                                    "code": "reminderConfig",
                                    "name": "催单配置",
                                    "parentId": "717435194855915520",
                                    "icon": "",
                                    "scope": 1,
                                    "sort": 14,
                                    "type": 2,
                                    "url": "/system/reminder-config",
                                    "externalLink": "",
                                    "redirect": "",
                                    "hide": 0,
                                    "moduleCode": "GIS",
                                    "remark": "",
                                    "children": null,
                                    "permissionList": null,
                                    "isAdmin": null,
                                    "smartField": 4
                                },
                                {
                                    "id": "1402923768240365570",
                                    "code": "flow",
                                    "name": "规则中心",
                                    "parentId": "717435194855915520",
                                    "icon": "",
                                    "scope": 1,
                                    "sort": 16,
                                    "type": 2,
                                    "url": "/system/flow",
                                    "externalLink": "",
                                    "redirect": "",
                                    "hide": 0,
                                    "moduleCode": "GIS",
                                    "remark": "",
                                    "children": null,
                                    "permissionList": null,
                                    "isAdmin": null,
                                    "smartField": 4
                                },
                                {
                                    "id": "1434771787109605378",
                                    "code": "operateFlow",
                                    "name": "设计规则",
                                    "parentId": "717435194855915520",
                                    "icon": "",
                                    "scope": 1,
                                    "sort": 18,
                                    "type": 2,
                                    "url": "/system/flow/:type/:id",
                                    "externalLink": "",
                                    "redirect": "",
                                    "hide": 1,
                                    "moduleCode": "GIS",
                                    "remark": "",
                                    "children": null,
                                    "permissionList": null,
                                    "isAdmin": null,
                                    "smartField": 4
                                },
                                {
                                    "id": "1405335412128014338",
                                    "code": "EventTaskInfo",
                                    "name": "事件任务信息",
                                    "parentId": "717435194855915520",
                                    "icon": "",
                                    "scope": 1,
                                    "sort": 19,
                                    "type": 2,
                                    "url": "/system/event-task-info",
                                    "externalLink": "",
                                    "redirect": "",
                                    "hide": 0,
                                    "moduleCode": "GIS",
                                    "remark": "",
                                    "children": null,
                                    "permissionList": null,
                                    "isAdmin": null,
                                    "smartField": 4
                                },
                                {
                                    "id": "1418452384852131842",
                                    "code": "operationNote",
                                    "name": "操作日志",
                                    "parentId": "717435194855915520",
                                    "icon": "",
                                    "scope": 1,
                                    "sort": 20,
                                    "type": 2,
                                    "url": "/system/operation-note",
                                    "externalLink": "",
                                    "redirect": "",
                                    "hide": 0,
                                    "moduleCode": "GIS",
                                    "remark": "",
                                    "children": null,
                                    "permissionList": null,
                                    "isAdmin": null,
                                    "smartField": 4
                                },
                                {
                                    "id": "1418489462839230466",
                                    "code": "authority",
                                    "name": "权限配置",
                                    "parentId": "717435194855915520",
                                    "icon": "",
                                    "scope": 1,
                                    "sort": 22,
                                    "type": 2,
                                    "url": "/system/authority",
                                    "externalLink": "",
                                    "redirect": "",
                                    "hide": 0,
                                    "moduleCode": "GIS",
                                    "remark": "",
                                    "children": null,
                                    "permissionList": null,
                                    "isAdmin": null,
                                    "smartField": 4
                                },
                                {
                                    "id": "1441334020337762306",
                                    "code": "PostMessageTest",
                                    "name": "PostMessageTest",
                                    "parentId": "717435194855915520",
                                    "icon": "",
                                    "scope": 1,
                                    "sort": 23,
                                    "type": 2,
                                    "url": "/system/test-postmessage",
                                    "externalLink": "http://36.110.103.178:29081/test-postmsg.html",
                                    "redirect": "",
                                    "hide": 0,
                                    "moduleCode": "GIS",
                                    "remark": "",
                                    "children": null,
                                    "permissionList": null,
                                    "isAdmin": null,
                                    "smartField": 4
                                },
                                {
                                    "id": "1542020136916684801",
                                    "code": "WorkflowManagement",
                                    "name": "流程配置",
                                    "parentId": "717435194855915520",
                                    "icon": "",
                                    "scope": 1,
                                    "sort": 24,
                                    "type": 2,
                                    "url": "/system/workflow",
                                    "externalLink": "",
                                    "redirect": "/system/workflow/config",
                                    "hide": 0,
                                    "moduleCode": "GIS",
                                    "remark": "",
                                    "children": [
                                        {
                                            "id": "1542020360632471553",
                                            "code": "WorkflowConfig",
                                            "name": "审批流配置",
                                            "parentId": "1542020136916684801",
                                            "icon": "",
                                            "scope": 1,
                                            "sort": 1,
                                            "type": 2,
                                            "url": "/system/workflow/config",
                                            "externalLink": "",
                                            "redirect": "",
                                            "hide": 0,
                                            "moduleCode": "GIS",
                                            "remark": "",
                                            "children": null,
                                            "permissionList": null,
                                            "isAdmin": null,
                                            "smartField": 4
                                        },
                                        {
                                            "id": "1542020901907402753",
                                            "code": "ChildWorkflowConfig",
                                            "name": "子流程配置",
                                            "parentId": "1542020136916684801",
                                            "icon": "",
                                            "scope": 1,
                                            "sort": 2,
                                            "type": 2,
                                            "url": "/system/child-workflow/config",
                                            "externalLink": "",
                                            "redirect": "",
                                            "hide": 0,
                                            "moduleCode": "GIS",
                                            "remark": "",
                                            "children": null,
                                            "permissionList": null,
                                            "isAdmin": null,
                                            "smartField": 4
                                        },
                                        {
                                            "id": "1542046335466409985",
                                            "code": "WorkflowCustomForms",
                                            "name": "流程自定义表单",
                                            "parentId": "1542020136916684801",
                                            "icon": "",
                                            "scope": 1,
                                            "sort": 3,
                                            "type": 2,
                                            "url": "/system/wrokflow-form/config",
                                            "externalLink": "",
                                            "redirect": "",
                                            "hide": 0,
                                            "moduleCode": "GIS",
                                            "remark": "",
                                            "children": null,
                                            "permissionList": null,
                                            "isAdmin": null,
                                            "smartField": 4
                                        }
                                    ],
                                    "permissionList": null,
                                    "isAdmin": null,
                                    "smartField": 4
                                },
                                {
                                    "id": "1542344841976549377",
                                    "code": "WDLC",
                                    "name": "我的流程",
                                    "parentId": "717435194855915520",
                                    "icon": "",
                                    "scope": 1,
                                    "sort": 25,
                                    "type": 2,
                                    "url": "/system/myflow",
                                    "externalLink": "",
                                    "redirect": "/system/myflow/todo",
                                    "hide": 0,
                                    "moduleCode": "GIS",
                                    "remark": "",
                                    "children": [
                                        {
                                            "id": "1542344981286162434",
                                            "code": "WDLC_TODO",
                                            "name": "我的待办",
                                            "parentId": "1542344841976549377",
                                            "icon": "",
                                            "scope": 1,
                                            "sort": 1,
                                            "type": 2,
                                            "url": "/system/myflow/todo",
                                            "externalLink": "",
                                            "redirect": "",
                                            "hide": 0,
                                            "moduleCode": "GIS",
                                            "remark": "",
                                            "children": null,
                                            "permissionList": null,
                                            "isAdmin": null,
                                            "smartField": 4
                                        },
                                        {
                                            "id": "1542345092435218434",
                                            "code": "WDLC_INITIATE",
                                            "name": "我发起的",
                                            "parentId": "1542344841976549377",
                                            "icon": "",
                                            "scope": 1,
                                            "sort": 2,
                                            "type": 2,
                                            "url": "/system/myflow/initiate",
                                            "externalLink": "",
                                            "redirect": "",
                                            "hide": 0,
                                            "moduleCode": "GIS",
                                            "remark": "",
                                            "children": null,
                                            "permissionList": null,
                                            "isAdmin": null,
                                            "smartField": 4
                                        },
                                        {
                                            "id": "1542345194054815746",
                                            "code": "WDLC_DEAL",
                                            "name": "我处理的",
                                            "parentId": "1542344841976549377",
                                            "icon": "",
                                            "scope": 1,
                                            "sort": 3,
                                            "type": 2,
                                            "url": "/system/myflow/deal",
                                            "externalLink": "",
                                            "redirect": "",
                                            "hide": 0,
                                            "moduleCode": "GIS",
                                            "remark": "",
                                            "children": null,
                                            "permissionList": null,
                                            "isAdmin": null,
                                            "smartField": 4
                                        },
                                        {
                                            "id": "1542345321909784578",
                                            "code": "WDLC_INITIATEPROCESS",
                                            "name": "发起流程",
                                            "parentId": "1542344841976549377",
                                            "icon": "",
                                            "scope": 1,
                                            "sort": 4,
                                            "type": 2,
                                            "url": "/system/initiate/process",
                                            "externalLink": "",
                                            "redirect": "",
                                            "hide": 0,
                                            "moduleCode": "GIS",
                                            "remark": "",
                                            "children": null,
                                            "permissionList": null,
                                            "isAdmin": null,
                                            "smartField": 4
                                        },
                                        {
                                            "id": "1542345446434476034",
                                            "code": "WDLC_PROCESSRECORDS",
                                            "name": "流程记录",
                                            "parentId": "1542344841976549377",
                                            "icon": "",
                                            "scope": 1,
                                            "sort": 5,
                                            "type": 2,
                                            "url": "/system/process/records",
                                            "externalLink": "",
                                            "redirect": "",
                                            "hide": 0,
                                            "moduleCode": "GIS",
                                            "remark": "",
                                            "children": null,
                                            "permissionList": null,
                                            "isAdmin": null,
                                            "smartField": 4
                                        }
                                    ],
                                    "permissionList": null,
                                    "isAdmin": null,
                                    "smartField": 4
                                }
                            ],
                            "permissionList": null,
                            "isAdmin": null,
                            "smartField": 4
                        }
                    ],
                    "permissionList": null,
                    "isAdmin": null,
                    "smartField": 2
                },
                {
                    "id": "1544622723727220738",
                    "code": "SPJK",
                    "name": "视频监控",
                    "parentId": null,
                    "icon": null,
                    "scope": 1,
                    "sort": 2,
                    "type": 1,
                    "url": "/videoSurveillance",
                    "externalLink": "http://183.64.175.153:20003/?code=videoSurveillance",
                    "redirect": null,
                    "hide": 0,
                    "moduleCode": "SPJK",
                    "remark": null,
                    "children": null,
                    "permissionList": null,
                    "isAdmin": null,
                    "smartField": 2
                },
                {
                    "id": "1440516354075602946",
                    "code": "LDJSC",
                    "name": "运行监测",
                    "parentId": null,
                    "icon": null,
                    "scope": 1,
                    "sort": 7,
                    "type": 1,
                    "url": "/operationOverview",
                    "externalLink": "http://183.64.175.153:20003/?code=operationOverview",
                    "redirect": null,
                    "hide": 0,
                    "moduleCode": "LDJSC",
                    "remark": null,
                    "children": null,
                    "permissionList": null,
                    "isAdmin": null,
                    "smartField": 2
                },
                {
                    "id": "1850728065378840577",
                    "code": "AQSC",
                    "name": "安全生产",
                    "parentId": null,
                    "icon": "",
                    "scope": 1,
                    "sort": 33,
                    "type": 1,
                    "url": "",
                    "externalLink": "http://183.64.175.153:35002/fvue/safety",
                    "redirect": "",
                    "hide": 0,
                    "moduleCode": "AQSC",
                    "remark": "",
                    "children": null,
                    "permissionList": null,
                    "isAdmin": null,
                    "smartField": 2
                },
                {
                    "id": "1638719957237874690",
                    "code": "SJJK",
                    "name": "数据监控",
                    "parentId": null,
                    "icon": null,
                    "scope": 1,
                    "sort": 100,
                    "type": 1,
                    "url": "/data-monitor",
                    "externalLink": "http://183.64.175.153:20003/?code=dataMonitor",
                    "redirect": null,
                    "hide": 0,
                    "moduleCode": "SJJK",
                    "remark": null,
                    "children": null,
                    "permissionList": null,
                    "isAdmin": null,
                    "smartField": 2
                }
            ],
            "permissionList": null,
            "isAdmin": null,
            "smartField": null
        },
        {
            "id": null,
            "code": "ZHYH",
            "name": "智慧养护",
            "parentId": null,
            "icon": null,
            "scope": null,
            "sort": 0,
            "type": null,
            "url": null,
            "externalLink": null,
            "redirect": null,
            "hide": null,
            "moduleCode": null,
            "remark": null,
            "children": [
                {
                    "id": "1440506777556824065",
                    "code": "HY",
                    "name": "养护系统",
                    "parentId": null,
                    "icon": null,
                    "scope": 1,
                    "sort": 5,
                    "type": 1,
                    "url": "/curingManageyh",
                    "externalLink": "http://183.64.175.153:20003?code=curingManageyh",
                    "redirect": null,
                    "hide": 0,
                    "moduleCode": "HY",
                    "remark": null,
                    "children": [
                        {
                            "id": "1806148266480398338",
                            "code": "gzt",
                            "name": "工作台",
                            "parentId": "1440506777556824065",
                            "icon": "",
                            "scope": 1,
                            "sort": 2,
                            "type": 2,
                            "url": "/homeyh",
                            "externalLink": "",
                            "redirect": "",
                            "hide": 0,
                            "moduleCode": "HY",
                            "remark": "",
                            "children": null,
                            "permissionList": null,
                            "isAdmin": null,
                            "smartField": 4
                        }
                    ],
                    "permissionList": null,
                    "isAdmin": null,
                    "smartField": 3
                },
                {
                    "id": "1440508084007022594",
                    "code": "JD",
                    "name": "机电系统",
                    "parentId": null,
                    "icon": null,
                    "scope": 1,
                    "sort": 6,
                    "type": 1,
                    "url": "/electromechanicalMange",
                    "externalLink": "http://183.64.175.153:20003?code=electromechanicalMange",
                    "redirect": null,
                    "hide": 0,
                    "moduleCode": "JD",
                    "remark": null,
                    "children": null,
                    "permissionList": null,
                    "isAdmin": null,
                    "smartField": 3
                },
                {
                    "id": "1719532649858494466",
                    "code": "YHCY",
                    "name": "养护产业",
                    "parentId": null,
                    "icon": null,
                    "scope": 1,
                    "sort": 7,
                    "type": 1,
                    "url": null,
                    "externalLink": "http://111.9.41.17:9004/#/cqjlLogin",
                    "redirect": null,
                    "hide": 0,
                    "moduleCode": "YHCY",
                    "remark": null,
                    "children": null,
                    "permissionList": null,
                    "isAdmin": null,
                    "smartField": 3
                }
            ],
            "permissionList": null,
            "isAdmin": null,
            "smartField": null
        },
        {
            "id": null,
            "code": "ZHFW",
            "name": "智慧服务",
            "parentId": null,
            "icon": null,
            "scope": null,
            "sort": 0,
            "type": null,
            "url": null,
            "externalLink": null,
            "redirect": null,
            "hide": null,
            "moduleCode": null,
            "remark": null,
            "children": [
                {
                    "id": "1544622708652892162",
                    "code": "YWGK",
                    "name": "总体概况",
                    "parentId": null,
                    "icon": null,
                    "scope": 1,
                    "sort": 1,
                    "type": 1,
                    "url": "/business",
                    "externalLink": "http://183.64.175.153:20003/?code=business",
                    "redirect": null,
                    "hide": 0,
                    "moduleCode": "YWGK",
                    "remark": null,
                    "children": null,
                    "permissionList": null,
                    "isAdmin": null,
                    "smartField": 4
                },
                {
                    "id": "1548901833102098433",
                    "code": "JYGK",
                    "name": "经营概况",
                    "parentId": null,
                    "icon": null,
                    "scope": 1,
                    "sort": 2,
                    "type": 1,
                    "url": "manageGenera",
                    "externalLink": "http://183.64.175.153:20003/?code=manageGenera",
                    "redirect": null,
                    "hide": 0,
                    "moduleCode": "JYGK",
                    "remark": null,
                    "children": null,
                    "permissionList": null,
                    "isAdmin": null,
                    "smartField": 4
                },
                {
                    "id": "1440600670432473089",
                    "code": "GS",
                    "name": "服务区",
                    "parentId": null,
                    "icon": null,
                    "scope": 1,
                    "sort": 3,
                    "type": 1,
                    "url": "",
                    "externalLink": "http://183.64.175.153:21080/servicearea/index.html#/cqHome",
                    "redirect": "",
                    "hide": 0,
                    "moduleCode": "GS",
                    "remark": "http://183.64.175.153:20003?code=expressway路由/expressway",
                    "children": null,
                    "permissionList": null,
                    "isAdmin": null,
                    "smartField": 4
                },
                {
                    "id": "1546668011379810306",
                    "code": "BI",
                    "name": "BI平台",
                    "parentId": null,
                    "icon": null,
                    "scope": 1,
                    "sort": 8,
                    "type": 1,
                    "url": null,
                    "externalLink": "http://183.64.175.153:15180/view/user/sso.do",
                    "redirect": null,
                    "hide": 0,
                    "moduleCode": "BI",
                    "remark": null,
                    "children": null,
                    "permissionList": null,
                    "isAdmin": null,
                    "smartField": 4
                },
                {
                    "id": "1302891804016480262",
                    "code": "QXGL",
                    "name": "权限管理",
                    "parentId": null,
                    "icon": null,
                    "scope": 1,
                    "sort": 11,
                    "type": 1,
                    "url": null,
                    "externalLink": "http://183.64.175.153:28880/#/QXGL",
                    "redirect": null,
                    "hide": 0,
                    "moduleCode": "QXGL",
                    "remark": "",
                    "children": [
                        {
                            "id": "719678167228350464",
                            "code": "QXGL_JSGL",
                            "name": "角色管理",
                            "parentId": "1302891804016480262",
                            "icon": "",
                            "scope": 1,
                            "sort": 5,
                            "type": 2,
                            "url": "/QXGL/roles",
                            "externalLink": null,
                            "redirect": "",
                            "hide": 0,
                            "moduleCode": "QXGL",
                            "remark": null,
                            "children": null,
                            "permissionList": null,
                            "isAdmin": null,
                            "smartField": 4
                        },
                        {
                            "id": "719678285834878976",
                            "code": "QXGL_YHGL",
                            "name": "用户管理",
                            "parentId": "1302891804016480262",
                            "icon": "",
                            "scope": 1,
                            "sort": 6,
                            "type": 2,
                            "url": "/QXGL/users",
                            "externalLink": null,
                            "redirect": "/QXGL/users/list",
                            "hide": 0,
                            "moduleCode": "QXGL",
                            "remark": null,
                            "children": [
                                {
                                    "id": "1366275263312896001",
                                    "code": "QXGL_YHGL_LIST",
                                    "name": "用户管理",
                                    "parentId": "719678285834878976",
                                    "icon": "",
                                    "scope": 1,
                                    "sort": 1,
                                    "type": 2,
                                    "url": "/QXGL/users/list",
                                    "externalLink": "",
                                    "redirect": "",
                                    "hide": 0,
                                    "moduleCode": "QXGL",
                                    "remark": "",
                                    "children": null,
                                    "permissionList": null,
                                    "isAdmin": null,
                                    "smartField": 4
                                },
                                {
                                    "id": "1544507552337879041",
                                    "code": "QXGL_YHGL_YHXX",
                                    "name": "员工台账",
                                    "parentId": "719678285834878976",
                                    "icon": "",
                                    "scope": 1,
                                    "sort": 2,
                                    "type": 2,
                                    "url": "/QXGL/user/userInfos",
                                    "externalLink": "",
                                    "redirect": "",
                                    "hide": 0,
                                    "moduleCode": "QXGL",
                                    "remark": "",
                                    "children": null,
                                    "permissionList": null,
                                    "isAdmin": null,
                                    "smartField": 4
                                },
                                {
                                    "id": "1366275529441484801",
                                    "code": "QXGL_YHGL_YHTJ",
                                    "name": "用户统计",
                                    "parentId": "719678285834878976",
                                    "icon": "",
                                    "scope": 1,
                                    "sort": 3,
                                    "type": 2,
                                    "url": "/QXGL/user/statistics",
                                    "externalLink": "",
                                    "redirect": "",
                                    "hide": 0,
                                    "moduleCode": "QXGL",
                                    "remark": "",
                                    "children": null,
                                    "permissionList": null,
                                    "isAdmin": null,
                                    "smartField": 4
                                },
                                {
                                    "id": "1395196493034057730",
                                    "code": "QXGL_YHGL_YHTJ_ZXYH",
                                    "name": "在线用户",
                                    "parentId": "719678285834878976",
                                    "icon": "",
                                    "scope": 1,
                                    "sort": 4,
                                    "type": 2,
                                    "url": "/QXGL/user/statistics/online",
                                    "externalLink": "",
                                    "redirect": "",
                                    "hide": 0,
                                    "moduleCode": "QXGL",
                                    "remark": "",
                                    "children": null,
                                    "permissionList": null,
                                    "isAdmin": null,
                                    "smartField": 4
                                },
                                {
                                    "id": "1395196679961604097",
                                    "code": "QXGL_YHGL_YHTJ_HYYH",
                                    "name": "活跃用户",
                                    "parentId": "719678285834878976",
                                    "icon": "",
                                    "scope": 1,
                                    "sort": 5,
                                    "type": 2,
                                    "url": "/QXGL/user/statistics/active",
                                    "externalLink": "",
                                    "redirect": "",
                                    "hide": 0,
                                    "moduleCode": "QXGL",
                                    "remark": "",
                                    "children": null,
                                    "permissionList": null,
                                    "isAdmin": null,
                                    "smartField": 4
                                }
                            ],
                            "permissionList": null,
                            "isAdmin": null,
                            "smartField": 4
                        },
                        {
                            "id": "1364035800524324865",
                            "code": "QXGL_RZGL",
                            "name": "日志管理",
                            "parentId": "1302891804016480262",
                            "icon": "",
                            "scope": 1,
                            "sort": 7,
                            "type": 2,
                            "url": "/QXGL/logs",
                            "externalLink": "",
                            "redirect": "/QXGL/logs/login",
                            "hide": 0,
                            "moduleCode": "QXGL",
                            "remark": "",
                            "children": [
                                {
                                    "id": "1364036400469180417",
                                    "code": "QXGL_RZGL_DL",
                                    "name": "登录日志",
                                    "parentId": "1364035800524324865",
                                    "icon": "",
                                    "scope": 1,
                                    "sort": 1,
                                    "type": 2,
                                    "url": "/QXGL/logs/login",
                                    "externalLink": "",
                                    "redirect": "",
                                    "hide": 0,
                                    "moduleCode": "QXGL",
                                    "remark": "",
                                    "children": null,
                                    "permissionList": null,
                                    "isAdmin": null,
                                    "smartField": 4
                                },
                                {
                                    "id": "1364039680188416002",
                                    "code": "QXGL_RZGL_CZ",
                                    "name": "操作日志",
                                    "parentId": "1364035800524324865",
                                    "icon": "",
                                    "scope": 1,
                                    "sort": 2,
                                    "type": 2,
                                    "url": "/QXGL/logs/operation",
                                    "externalLink": "",
                                    "redirect": "",
                                    "hide": 0,
                                    "moduleCode": "QXGL",
                                    "remark": "",
                                    "children": null,
                                    "permissionList": null,
                                    "isAdmin": null,
                                    "smartField": 4
                                }
                            ],
                            "permissionList": null,
                            "isAdmin": null,
                            "smartField": 4
                        },
                        {
                            "id": "1288392001408618497",
                            "code": "QXGL_ZZJGGL",
                            "name": "组织机构管理",
                            "parentId": "1302891804016480262",
                            "icon": "",
                            "scope": 1,
                            "sort": 9,
                            "type": 2,
                            "url": "/QXGL/orgs",
                            "externalLink": "",
                            "redirect": "",
                            "hide": 0,
                            "moduleCode": "QXGL",
                            "remark": "",
                            "children": null,
                            "permissionList": null,
                            "isAdmin": null,
                            "smartField": 4
                        },
                        {
                            "id": "1539526980356018178",
                            "code": "QXGL_SJWH",
                            "name": "数据维护",
                            "parentId": "1302891804016480262",
                            "icon": "",
                            "scope": 1,
                            "sort": 11,
                            "type": 2,
                            "url": "/QXGL/data",
                            "externalLink": "",
                            "redirect": "/QXGL/business",
                            "hide": 0,
                            "moduleCode": "QXGL",
                            "remark": "",
                            "children": [
                                {
                                    "id": "1539527565713084418",
                                    "code": "QXGL_YWGK",
                                    "name": "总体概况",
                                    "parentId": "1539526980356018178",
                                    "icon": "",
                                    "scope": 1,
                                    "sort": 1,
                                    "type": 2,
                                    "url": "/QXGL/business",
                                    "externalLink": "",
                                    "redirect": "/QXGL/business/kgMileage",
                                    "hide": 0,
                                    "moduleCode": "QXGL",
                                    "remark": "",
                                    "children": [
                                        {
                                            "id": "1541973120859103234",
                                            "code": "QXGL_LDXX",
                                            "name": "路段信息",
                                            "parentId": "1539527565713084418",
                                            "icon": "",
                                            "scope": 1,
                                            "sort": 1,
                                            "type": 2,
                                            "url": "/QXGL/business/roadInfo",
                                            "externalLink": "",
                                            "redirect": "",
                                            "hide": 0,
                                            "moduleCode": "QXGL",
                                            "remark": "",
                                            "children": null,
                                            "permissionList": null,
                                            "isAdmin": null,
                                            "smartField": 4
                                        },
                                        {
                                            "id": "1541251726856802305",
                                            "code": "QXGL_CDSFRY",
                                            "name": "路段收费员数量和车道数",
                                            "parentId": "1539527565713084418",
                                            "icon": "",
                                            "scope": 1,
                                            "sort": 2,
                                            "type": 2,
                                            "url": "/QXGL/business/laneTollCollector",
                                            "externalLink": "",
                                            "redirect": "",
                                            "hide": 0,
                                            "moduleCode": "QXGL",
                                            "remark": "",
                                            "children": null,
                                            "permissionList": null,
                                            "isAdmin": null,
                                            "smartField": 4
                                        },
                                        {
                                            "id": "1539528057386237954",
                                            "code": "QXGL_NDLC",
                                            "name": "路段年度里程开通情况",
                                            "parentId": "1539527565713084418",
                                            "icon": "",
                                            "scope": 1,
                                            "sort": 3,
                                            "type": 2,
                                            "url": "/QXGL/business/Mileage",
                                            "externalLink": "",
                                            "redirect": "",
                                            "hide": 0,
                                            "moduleCode": "QXGL",
                                            "remark": "",
                                            "children": null,
                                            "permissionList": null,
                                            "isAdmin": null,
                                            "smartField": 4
                                        }
                                    ],
                                    "permissionList": null,
                                    "isAdmin": null,
                                    "smartField": 4
                                },
                                {
                                    "id": "1541254009573199874",
                                    "code": "QXGL_YXJC",
                                    "name": "运行监测",
                                    "parentId": "1539526980356018178",
                                    "icon": "",
                                    "scope": 1,
                                    "sort": 2,
                                    "type": 2,
                                    "url": "/QXGL/operationMonitoring",
                                    "externalLink": "",
                                    "redirect": "/QXGL/operationMonitoring/investmentStatistics",
                                    "hide": 0,
                                    "moduleCode": "QXGL",
                                    "remark": "http://183.64.175.153:28880/#/QXGL/operationMonitoring/investmentStatistics",
                                    "children": [
                                        {
                                            "id": "1541254524952498178",
                                            "code": "QXGL_TZZXTJ",
                                            "name": "投诉咨询统计",
                                            "parentId": "1541254009573199874",
                                            "icon": "",
                                            "scope": 1,
                                            "sort": 1,
                                            "type": 2,
                                            "url": "/QXGL/operationMonitoring/investmentStatistics",
                                            "externalLink": "",
                                            "redirect": "",
                                            "hide": 0,
                                            "moduleCode": "QXGL",
                                            "remark": "",
                                            "children": null,
                                            "permissionList": null,
                                            "isAdmin": null,
                                            "smartField": 4
                                        },
                                        {
                                            "id": "1552585710320488450",
                                            "code": "QXGL_SSSJ",
                                            "name": "实时事件",
                                            "parentId": "1541254009573199874",
                                            "icon": "",
                                            "scope": 1,
                                            "sort": 3,
                                            "type": 2,
                                            "url": "/QXGL/operationMonitoring/events",
                                            "externalLink": "",
                                            "redirect": "",
                                            "hide": 0,
                                            "moduleCode": "QXGL",
                                            "remark": "",
                                            "children": null,
                                            "permissionList": null,
                                            "isAdmin": null,
                                            "smartField": 4
                                        }
                                    ],
                                    "permissionList": null,
                                    "isAdmin": null,
                                    "smartField": 2
                                },
                                {
                                    "id": "1552557992388415490",
                                    "code": "QXGL_JYGK",
                                    "name": "经营概况",
                                    "parentId": "1539526980356018178",
                                    "icon": "",
                                    "scope": 1,
                                    "sort": 3,
                                    "type": 2,
                                    "url": "/manage",
                                    "externalLink": "",
                                    "redirect": "",
                                    "hide": 0,
                                    "moduleCode": "QXGL",
                                    "remark": "http://183.64.175.153:28880/#/QXGL/manage/data",
                                    "children": [
                                        {
                                            "id": "1552558620841873409",
                                            "code": "QXGL_JYSJ",
                                            "name": "经营数据",
                                            "parentId": "1552557992388415490",
                                            "icon": "",
                                            "scope": 1,
                                            "sort": 1,
                                            "type": 2,
                                            "url": "/manage/data",
                                            "externalLink": "",
                                            "redirect": "",
                                            "hide": 0,
                                            "moduleCode": "QXGL",
                                            "remark": "",
                                            "children": null,
                                            "permissionList": null,
                                            "isAdmin": null,
                                            "smartField": 4
                                        },
                                        {
                                            "id": "1570220837418692610",
                                            "code": "QXGL_NYS",
                                            "name": "年预算",
                                            "parentId": "1552557992388415490",
                                            "icon": "",
                                            "scope": 1,
                                            "sort": 2,
                                            "type": 2,
                                            "url": "/manage/annualBudget",
                                            "externalLink": "",
                                            "redirect": "",
                                            "hide": 0,
                                            "moduleCode": "QXGL",
                                            "remark": "",
                                            "children": null,
                                            "permissionList": null,
                                            "isAdmin": null,
                                            "smartField": 4
                                        }
                                    ],
                                    "permissionList": null,
                                    "isAdmin": null,
                                    "smartField": 4
                                },
                                {
                                    "id": "1556827059861389313",
                                    "code": "QXGL_GSGL",
                                    "name": "高速公路 +",
                                    "parentId": "1539526980356018178",
                                    "icon": "",
                                    "scope": 1,
                                    "sort": 4,
                                    "type": 2,
                                    "url": "/highway",
                                    "externalLink": "",
                                    "redirect": "",
                                    "hide": 0,
                                    "moduleCode": "QXGL",
                                    "remark": "",
                                    "children": [
                                        {
                                            "id": "1556827335053869058",
                                            "code": "QXGL_YPSJ",
                                            "name": "油品销售数据",
                                            "parentId": "1556827059861389313",
                                            "icon": "",
                                            "scope": 1,
                                            "sort": 1,
                                            "type": 2,
                                            "url": "/highway/oil",
                                            "externalLink": "",
                                            "redirect": "",
                                            "hide": 0,
                                            "moduleCode": "QXGL",
                                            "remark": "",
                                            "children": null,
                                            "permissionList": null,
                                            "isAdmin": null,
                                            "smartField": 4
                                        }
                                    ],
                                    "permissionList": null,
                                    "isAdmin": null,
                                    "smartField": 4
                                }
                            ],
                            "permissionList": null,
                            "isAdmin": null,
                            "smartField": 4
                        },
                        {
                            "id": "1407522925936627714",
                            "code": "QXGL_QXZYGL",
                            "name": "权限资源管理",
                            "parentId": "1302891804016480262",
                            "icon": "",
                            "scope": 1,
                            "sort": 12,
                            "type": 2,
                            "url": "/QXGL/auth",
                            "externalLink": "",
                            "redirect": "/QXGL/resources",
                            "hide": 0,
                            "moduleCode": "QXGL",
                            "remark": "",
                            "children": [
                                {
                                    "id": "719677936654876672",
                                    "code": "QXGL_ZYGL",
                                    "name": "资源管理",
                                    "parentId": "1407522925936627714",
                                    "icon": "",
                                    "scope": 1,
                                    "sort": 5,
                                    "type": 2,
                                    "url": "/QXGL/resources",
                                    "externalLink": null,
                                    "redirect": "",
                                    "hide": 0,
                                    "moduleCode": "QXGL",
                                    "remark": null,
                                    "children": null,
                                    "permissionList": null,
                                    "isAdmin": null,
                                    "smartField": 4
                                }
                            ],
                            "permissionList": null,
                            "isAdmin": null,
                            "smartField": 4
                        }
                    ],
                    "permissionList": null,
                    "isAdmin": null,
                    "smartField": 4
                },
                {
                    "id": "1570304659581579266",
                    "code": "YHYWXT",
                    "name": "养护业务系统",
                    "parentId": null,
                    "icon": null,
                    "scope": 1,
                    "sort": 30,
                    "type": 1,
                    "url": null,
                    "externalLink": "http://183.64.175.153:8888/fvue/login",
                    "redirect": null,
                    "hide": 0,
                    "moduleCode": "YHYWXT",
                    "remark": null,
                    "children": null,
                    "permissionList": null,
                    "isAdmin": null,
                    "smartField": 4
                },
                {
                    "id": "1570314865875165186",
                    "code": "SFYWXT",
                    "name": "收费业务系统",
                    "parentId": null,
                    "icon": null,
                    "scope": 1,
                    "sort": 30,
                    "type": 1,
                    "url": null,
                    "externalLink": "http://183.64.175.153:6005/platform.html",
                    "redirect": null,
                    "hide": 0,
                    "moduleCode": "SFYWXT",
                    "remark": null,
                    "children": null,
                    "permissionList": null,
                    "isAdmin": null,
                    "smartField": 4
                },
                {
                    "id": "1570314136942817281",
                    "code": "JDYWXT",
                    "name": "机电业务系统",
                    "parentId": null,
                    "icon": null,
                    "scope": 1,
                    "sort": 32,
                    "type": 1,
                    "url": null,
                    "externalLink": "http://183.64.175.153:8891/",
                    "redirect": null,
                    "hide": 0,
                    "moduleCode": "JDYWXT",
                    "remark": null,
                    "children": null,
                    "permissionList": null,
                    "isAdmin": null,
                    "smartField": 4
                }
            ],
            "permissionList": null,
            "isAdmin": null,
            "smartField": null
        }
    ]
});

Mock.mock(/\/mngSectionLenChild/, "get", function (options) {
    return {
        "msgState": "SUCCESS",
        "msgType": "ARR",
        "msgDes": "QUERY",
        "msgContent": [
            {
                "canguLen": 462.043,
                "kongguLen": 683.612,
                "mngSectionLen": 1245.822,
                "orgCode": "CQ",
                "orgName": "重庆",
                "quanziLen": 100.167,
                "sectionCount": "16"
            },
            {
                "canguLen": 509.235,
                "kongguLen": 18.771,
                "mngSectionLen": 714.488,
                "orgCode": "SC",
                "orgName": "四川",
                "quanziLen": 186.482,
                "sectionCount": "6"
            },
            {
                "canguLen": 234.249,
                "kongguLen": 74.4,
                "mngSectionLen": 308.649,
                "orgCode": "GZ",
                "orgName": "贵州",
                "quanziLen": 0,
                "sectionCount": "3"
            },
            {
                "canguLen": 195.711,
                "kongguLen": 108.571,
                "mngSectionLen": 304.282,
                "orgCode": "YN",
                "orgName": "云南",
                "quanziLen": 0,
                "sectionCount": "2"
            }
        ]
    }
});

Mock.mock(`${api}/investMileage`, "get", function (options) {
    return {
        "msgState": "SUCCESS",
        "msgType": "ARR",
        "msgDes": "QUERY",
        "msgContent": [
            {
                "sectionLength": 3541.89
            }
        ]
    }
});

Mock.mock(/\/mngSectionLen/, "get", function (options) {
    return {
        "msgState": "SUCCESS",
        "msgType": "ARR",
        "msgDes": "QUERY",
        "msgContent": [{
            "mngSectionLen": 2141,
            "sectionCount": "29",
            "totalMngSectionLen": 2140.66,
            "totalSectionCount": "29"
        }]
    }
});

Mock.mock(/\/mngPrivinceCount/, "get", function (options) {
    return {
        "msgState": "SUCCESS",
        "msgType": "ARR",
        "msgDes": "QUERY",
        "msgContent": [
            {
                "count(distinct province)": "6"
            }
        ]
    }
});

// 基础设施统计-收费站
Mock.mock(/\/stationCount/, "get", function (options) {
    const isChild = options.url.indexOf('stationCountQueryChild') > -1;
    let msgContent = []
    if (isChild) {
        msgContent = [
            {
                "orgCode": "AH",
                "orgName": "安徽",
                "stationCount": 0
            },
            {
                "orgCode": "CQ",
                "orgName": "重庆",
                "stationCount": 63
            },
            {
                "orgCode": "GZ",
                "orgName": "贵州",
                "stationCount": 5
            },
            {
                "orgCode": "HN",
                "orgName": "湖南",
                "stationCount": 0
            },
            {
                "orgCode": "SC",
                "orgName": "四川",
                "stationCount": 16
            },
            {
                "orgCode": "YN",
                "orgName": "云南",
                "stationCount": 5
            }
        ]
    } else {
        msgContent = [
            {
                "stationCount": "89",
                "totalcount": "89"
            }
        ]
    }

    return {
        "msgState": "SUCCESS",
        "msgType": "ARR",
        "msgDes": "QUERY",
        "msgContent": msgContent
    }

});

// 车道分类
Mock.mock(/\/StationLaneTypeCount/, "get", function (options) {
    return {
        "msgState": "SUCCESS",
        "msgType": "ARR",
        "msgDes": "QUERY",
        "msgContent": [
            {
                "etccount": 338,
                "mixturecount": 252,
                "orgCode": "QG",
                "orgName": "全国"
            }
        ]
    }
});

Mock.mock(/\/controlProSecCount/, "get", function (options) {

    return {
        "msgState": "SUCCESS",
        "msgType": "ARR",
        "msgDes": "QUERY",
        "msgContent": [
            {
                "projectCount": "39",
                "sectionCount": "29"
            }
        ]
    }
});

// 基础设施统计-路段
Mock.mock(/\/sectionCount/, "get", function (options) {
    const isChild = options.url.indexOf('sectionCountlevelChild') > -1;
    let msgContent = []
    if (isChild) {
        msgContent = [
            {
                "orgCode": "CQ",
                "orgName": "重庆",
                "sectionCount": 12
            },
            {
                "orgCode": "GZ",
                "orgName": "贵州",
                "sectionCount": 1
            },
            {
                "orgCode": "SC",
                "orgName": "四川",
                "sectionCount": 3
            },
            {
                "orgCode": "YN",
                "orgName": "云南",
                "sectionCount": 1
            }
        ]
    } else {
        msgContent = [
            {
                "sectionCount": "17"
            }
        ]
    }

    return {
        "msgState": "SUCCESS",
        "msgType": "ARR",
        "msgDes": "QUERY",
        "msgContent": msgContent
    }
});

// 基础设施统计-服务区
Mock.mock(/\/serviceAreaCount/, "get", function (options) {
    const isChild = options.url.indexOf('serviceAreaCountQueryChild') > -1;

    const params = new URLSearchParams(options.url.split('?')[1]);
    const level = params.get('level');
    const type = params.get('type');
    let msgContent = []
    if (isChild) {
        msgContent = [
            {
                "areaCount": 0,
                "orgCode": "AH",
                "orgName": "安徽"
            },
            {
                "areaCount": 20,
                "orgCode": "CQ",
                "orgName": "重庆"
            },
            {
                "areaCount": 2,
                "orgCode": "GZ",
                "orgName": "贵州"
            },
            {
                "areaCount": 0,
                "orgCode": "HN",
                "orgName": "湖南"
            },
            {
                "areaCount": 4,
                "orgCode": "SC",
                "orgName": "四川"
            },
            {
                "areaCount": 1,
                "orgCode": "YN",
                "orgName": "云南"
            }
        ]
    } else if (type === '0') {
        msgContent = [
            {
                "areaCount": "27"
            }
        ]
    } else if (type === '1') {
        msgContent = [
            {
                "areaCount": "5",
                "areaType": "停车区"
            },
            {
                "areaCount": "22",
                "areaType": "服务区"
            }
        ]
    }
    return {
        "msgState": "SUCCESS",
        "msgType": "ARR",
        "msgDes": "QUERY",
        "msgContent": msgContent
    }
});

// 基础设施统计- 互通
Mock.mock(/\/hutongCount/, "get", function (options) {
    const isChild = options.url.indexOf('hutongCountChild') > -1;

    const params = new URLSearchParams(options.url.split('?')[1]);
    const level = params.get('level');
    const type = params.get('type');
    let msgContent = []
    if (isChild) {
        msgContent = [
            {
                "hutongCount": 0,
                "orgCode": "AH",
                "orgName": "安徽"
            },
            {
                "hutongCount": 83,
                "orgCode": "CQ",
                "orgName": "重庆"
            },
            {
                "hutongCount": 10,
                "orgCode": "GZ",
                "orgName": "贵州"
            },
            {
                "hutongCount": 0,
                "orgCode": "HN",
                "orgName": "湖南"
            },
            {
                "hutongCount": 20,
                "orgCode": "SC",
                "orgName": "四川"
            },
            {
                "hutongCount": 7,
                "orgCode": "YN",
                "orgName": "云南"
            }
        ]
    } else if (type === '1') {
        msgContent = [
            {
                "hutongCount": "60",
                "hutongType": "匝道互通"
            },
            {
                "hutongCount": "31",
                "hutongType": "枢纽互通"
            },
            {
                "hutongCount": "29",
                "hutongType": "立交互通"
            }
        ]
    } else {
        msgContent = [
            {
                "hutongCount": "120"
            }
        ]
    }

    return {
        "msgState": "SUCCESS",
        "msgType": "ARR",
        "msgDes": "QUERY",
        "msgContent": msgContent
    }
});

// 基础设施统计- 隧道
Mock.mock(/\/tunnelCount/, "get", function (options) {
    const isChild = options.url.indexOf('tunnelCountQueryChild') > -1;

    const params = new URLSearchParams(options.url.split('?')[1]);
    const level = params.get('level');
    const type = params.get('type');
    let msgContent = []
    if (isChild) {
        msgContent = [
            {
                "orgCode": "AH",
                "orgName": "安徽",
                "tunnelCount": 0
            },
            {
                "orgCode": "CQ",
                "orgName": "重庆",
                "tunnelCount": 128
            },
            {
                "orgCode": "GZ",
                "orgName": "贵州",
                "tunnelCount": 40
            },
            {
                "orgCode": "HN",
                "orgName": "湖南",
                "tunnelCount": 0
            },
            {
                "orgCode": "SC",
                "orgName": "四川",
                "tunnelCount": 26
            },
            {
                "orgCode": "YN",
                "orgName": "云南",
                "tunnelCount": 45
            }
        ]
    } else if (type === '0') {
        msgContent = [
            {
                "tunnelCount": "239"
            }
        ]
    } else if (type === '1') {
        msgContent = [
            {
                "tunnelCount": "50",
                "tunnelType": "特长隧道"
            },
            {
                "tunnelCount": "77",
                "tunnelType": "长隧道"
            },
            {
                "tunnelCount": "58",
                "tunnelType": "中隧道"
            },
            {
                "tunnelCount": "54",
                "tunnelType": "短隧道"
            }
        ]
    }
    return {
        "msgState": "SUCCESS",
        "msgType": "ARR",
        "msgDes": "QUERY",
        "msgContent": msgContent
    }
});

// 基础设施统计-桥梁
Mock.mock(/\/bridgeCount/, "get", function (options) {
    const isChild = options.url.indexOf('bridgeCountQueryChild') > -1;

    const params = new URLSearchParams(options.url.split('?')[1]);
    const level = params.get('level');
    const type = params.get('type');
    let msgContent = []
    if (isChild) {
        msgContent = [
            {
                "bridgeCount": 0,
                "orgCode": "AH",
                "orgName": "安徽"
            },
            {
                "bridgeCount": 979,
                "orgCode": "CQ",
                "orgName": "重庆"
            },
            {
                "bridgeCount": 104,
                "orgCode": "GZ",
                "orgName": "贵州"
            },
            {
                "bridgeCount": 0,
                "orgCode": "HN",
                "orgName": "湖南"
            },
            {
                "bridgeCount": 140,
                "orgCode": "SC",
                "orgName": "四川"
            },
            {
                "bridgeCount": 195,
                "orgCode": "YN",
                "orgName": "云南"
            }
        ]
    } else if (type === '0') {
        msgContent = [
            {
                "bridgeCount": "1418"
            }
        ]
    } else if (type === '1') {
        msgContent = [
            {
                "bridgeCount": "61",
                "bridgeType": "特大桥"
            },
            {
                "bridgeCount": "912",
                "bridgeType": "大桥"
            },
            {
                "bridgeCount": "398",
                "bridgeType": "中桥"
            },
            {
                "bridgeCount": "47",
                "bridgeType": "小桥"
            }
        ]
    }
    return {
        "msgState": "SUCCESS",
        "msgType": "ARR",
        "msgDes": "QUERY",
        "msgContent": msgContent
    }
});

// 基础设施统计- 边坡
Mock.mock(/\/sideslopeCount/, "get", function (options) {
    const isChild = options.url.indexOf('sideslopeCountChild') > -1;

    const params = new URLSearchParams(options.url.split('?')[1]);
    const level = params.get('level');
    const riskType = params.get('riskType');
    let msgContent = []
    if (isChild) {
        msgContent = [
            {
                "orgCode": "AH",
                "orgName": "安徽",
                "slopeCount": 0
            },
            {
                "orgCode": "CQ",
                "orgName": "重庆",
                "slopeCount": 936
            },
            {
                "orgCode": "GZ",
                "orgName": "贵州",
                "slopeCount": 385
            },
            {
                "orgCode": "HN",
                "orgName": "湖南",
                "slopeCount": 0
            },
            {
                "orgCode": "SC",
                "orgName": "四川",
                "slopeCount": 95
            },
            {
                "orgCode": "YN",
                "orgName": "云南",
                "slopeCount": 99
            }
        ]
    } else if (riskType === '0') {
        msgContent = [
            {
                "slopeCount": "1515"
            }
        ]
    } else if (riskType === '1') {
        msgContent = [
            {
                "riskType": "其他边坡",
                "slopeCount": "712"
            },
            {
                "riskType": "高边坡",
                "slopeCount": "803"
            }
        ]
    }


    return {
        "msgState": "SUCCESS",
        "msgType": "ARR",
        "msgDes": "QUERY",
        "msgContent": msgContent
    }
});

// 机电主要设备统计
Mock.mock(/\/deviceCount/, "get", function (options) {
    return {
        "msgState": "SUCCESS",
        "msgType": "ARR",
        "msgDes": "QUERY",
        "msgContent": [
            {
                "deviceCount": 13056,
                "seqNum": 1,
                "systemType": "收费系统"
            },
            {
                "deviceCount": 14236,
                "seqNum": 2,
                "systemType": "监控系统"
            },
            {
                "deviceCount": 4787,
                "seqNum": 3,
                "systemType": "通信系统"
            },
            {
                "deviceCount": 7031,
                "seqNum": 4,
                "systemType": "供配电系统"
            },
            {
                "deviceCount": 20921,
                "seqNum": 5,
                "systemType": "隧道机电系统"
            }
        ]
    }
});

// 各类劳务关系人员统计
Mock.mock(/\/staffEmplyModeCount/, "get", function (options) {
    return {
        "msgState": "SUCCESS",
        "msgType": "ARR",
        "msgDes": "QUERY",
        "msgContent": [
            {
                "delegateCount": 1,
                "employCount": 142,
                "onPayrollCount": 220,
                "outsourceCount": 1404
            }
        ]
    }
})

// 人员占比
Mock.mock(/\/staffEmployModeCountChild/, "get", function (options) {
    return {
        "msgState": "SUCCESS",
        "msgType": "ARR",
        "msgDes": "QUERY",
        "msgContent": [
            {
                "delegateCount": 0,
                "employCount": 142,
                "onPayrollCount": 158,
                "orgCode": "CQ",
                "orgName": "运营公司",
                "outsourceCount": 975
            },
            {
                "delegateCount": 1,
                "employCount": 0,
                "onPayrollCount": 29,
                "orgCode": "SC",
                "orgName": "四川指挥部",
                "outsourceCount": 242
            },
            {
                "delegateCount": 0,
                "employCount": 0,
                "onPayrollCount": 14,
                "orgCode": "YN",
                "orgName": "云南指挥部",
                "outsourceCount": 107
            },
            {
                "delegateCount": 0,
                "employCount": 0,
                "onPayrollCount": 11,
                "orgCode": "GZGS",
                "orgName": "贵州指挥部",
                "outsourceCount": 80
            },
            {
                "delegateCount": 0,
                "employCount": 0,
                "onPayrollCount": 6,
                "orgCode": "TFJC",
                "orgName": "天府机场公司",
                "outsourceCount": 0
            },
            {
                "delegateCount": 0,
                "employCount": 0,
                "onPayrollCount": 2,
                "orgCode": "YR",
                "orgName": "渝蓉公司",
                "outsourceCount": 0
            }
        ]
    }
})

// 每车道收费人员配置
Mock.mock(/\/coastLaneStaffConfigQueryChild/, "get", function (options) {
    return {
        "msgState": "SUCCESS",
        "msgType": "ARR",
        "msgDes": "QUERY",
        "msgContent": [
            {
                "etclanes": 254,
                "laneCount": 432,
                "mixedlanes": 178,
                "orgCode": "CQ",
                "orgName": "重庆",
                "sdStaffPerLane": 2.09,
                "staffLaneAver": 1.97,
                "tollStaff": 851
            },
            {
                "etclanes": 18,
                "laneCount": 28,
                "mixedlanes": 10,
                "orgCode": "GZ",
                "orgName": "贵州",
                "sdStaffPerLane": 2,
                "staffLaneAver": 1.75,
                "tollStaff": 49
            },
            {
                "etclanes": 39,
                "laneCount": 74,
                "mixedlanes": 35,
                "orgCode": "SC",
                "orgName": "四川",
                "sdStaffPerLane": 1.16,
                "staffLaneAver": 1.54,
                "tollStaff": 114
            },
            {
                "etclanes": 27,
                "laneCount": 56,
                "mixedlanes": 29,
                "orgCode": "YN",
                "orgName": "云南",
                "sdStaffPerLane": 2.33,
                "staffLaneAver": 1.62,
                "tollStaff": 91
            }
        ]
    }
})

Mock.mock(/\/bizapi1\/http-server-base\/publish\/quota-v1\/qingfenAmount/, "get", function (options) {
    return {
        "msgState": "SUCCESS",
        "msgType": "ARR",
        "msgDes": "QUERY",
        "msgContent": [
            {
                "amountRate": 12.69,
                "budget": 241850,
                "clearEndDate": "2025-01-30",
                "clearStartDate": "2025-01-01",
                "qingfenAmount": 30699.05
            }
        ]
    }
})

Mock.mock(/\/bizapi1\/http-server-base\/publish\/quota-v1\/qingfenNext/, "get", function (options) {
    return {
        "msgState": "SUCCESS",
        "msgType": "ARR",
        "msgDes": "QUERY",
        "msgContent": [
            {
                "amountRate": 0,
                "budget": 0,
                "orgCode": "AH",
                "orgName": "安徽",
                "qingfenAmount": 0,
                "timeFlag": "2025"
            },
            {
                "amountRate": 0.13,
                "budget": 192000,
                "orgCode": "CQ",
                "orgName": "重庆",
                "qingfenAmount": 24235.92,
                "timeFlag": "2025"
            },
            {
                "amountRate": 0,
                "budget": 0,
                "orgCode": "GZ",
                "orgName": "贵州",
                "qingfenAmount": 0,
                "timeFlag": "2025"
            },
            {
                "amountRate": 0,
                "budget": 0,
                "orgCode": "HN",
                "orgName": "湖南",
                "qingfenAmount": 0,
                "timeFlag": "2025"
            },
            {
                "amountRate": 0,
                "budget": 11000,
                "orgCode": "SC",
                "orgName": "四川",
                "qingfenAmount": 1189.52,
                "timeFlag": "2025"
            },
            {
                "amountRate": 0.14,
                "budget": 38850,
                "orgCode": "YN",
                "orgName": "云南",
                "qingfenAmount": 5273.61,
                "timeFlag": "2025"
            }
        ]
    }
})

Mock.mock(/\/bizapi1\/http-server-base\/publish\/quota-v1\/yearFlowNext/, "get", function (options) {
    return {
        "msgState": "SUCCESS",
        "msgType": "ARR",
        "msgDes": "QUERY",
        "msgContent": [
            {
                "enflowCount": 522.39,
                "exflowCount": 508.06,
                "feeSum": 19295691826,
                "flowCount": 1030.45,
                "orgCode": "CQ",
                "orgName": "重庆",
                "timeFlag": "2025"
            },
            {
                "enflowCount": 0,
                "exflowCount": 0,
                "feeSum": 0,
                "flowCount": 0,
                "orgCode": "GZ",
                "orgName": "贵州",
                "timeFlag": "2025"
            },
            {
                "enflowCount": 0,
                "exflowCount": 0,
                "feeSum": 0,
                "flowCount": 0,
                "orgCode": "SC",
                "orgName": "四川",
                "timeFlag": "2025"
            }
        ]
    }
})

// 人员占比
Mock.mock(/\/mileageIncreaseChild/, "get", function (options) {
    const params = new URLSearchParams(options.url.split('?')[1]);
    const level = params.get('level');
    const cangu = params.get('cangu');
    let msgContent = []
    if (cangu === '0') {
        msgContent = [
            {
                "orgCode": "AH",
                "orgName": "安徽",
                "passLength": 55.384,
                "passYear": "2025"
            },
            {
                "orgCode": "CQ",
                "orgName": "重庆",
                "passLength": 124.031,
                "passYear": "2019"
            },
            {
                "orgCode": "CQ",
                "orgName": "重庆",
                "passLength": 242.541,
                "passYear": "2020"
            },
            {
                "orgCode": "CQ",
                "orgName": "重庆",
                "passLength": 226.037,
                "passYear": "2021"
            },
            {
                "orgCode": "CQ",
                "orgName": "重庆",
                "passLength": 20.384,
                "passYear": "2022"
            },
            {
                "orgCode": "CQ",
                "orgName": "重庆",
                "passLength": 48.691,
                "passYear": "2023"
            },
            {
                "orgCode": "GZ",
                "orgName": "贵州",
                "passLength": 114.871,
                "passYear": "2024"
            },
            {
                "orgCode": "HN",
                "orgName": "湖南",
                "passLength": 207.604,
                "passYear": "2025"
            },
            {
                "orgCode": "SC",
                "orgName": "四川",
                "passLength": 83.032,
                "passYear": "2022"
            },
            {
                "orgCode": "SC",
                "orgName": "四川",
                "passLength": 337.445,
                "passYear": "2025"
            },
            {
                "orgCode": "YN",
                "orgName": "云南",
                "passLength": 108.571,
                "passYear": "2022"
            },
            {
                "orgCode": "YN",
                "orgName": "云南",
                "passLength": 193.705,
                "passYear": "2024"
            }
        ]
    } else if (cangu === '1') {
        msgContent = [
            {
                "orgCode": null,
                "orgName": null,
                "passLength": 18.771,
                "passYear": "2023"
            },
            {
                "orgCode": null,
                "orgName": null,
                "passLength": 161.636,
                "passYear": "2024"
            },
            {
                "orgCode": null,
                "orgName": null,
                "passLength": 443.468,
                "passYear": "2025"
            },
            {
                "orgCode": "AH",
                "orgName": "安徽",
                "passLength": 55.384,
                "passYear": "2025"
            },
            {
                "orgCode": "CQ",
                "orgName": "重庆",
                "passLength": 202.661,
                "passYear": "2019"
            },
            {
                "orgCode": "CQ",
                "orgName": "重庆",
                "passLength": 242.541,
                "passYear": "2020"
            },
            {
                "orgCode": "CQ",
                "orgName": "重庆",
                "passLength": 226.037,
                "passYear": "2021"
            },
            {
                "orgCode": "CQ",
                "orgName": "重庆",
                "passLength": 20.384,
                "passYear": "2022"
            },
            {
                "orgCode": "CQ",
                "orgName": "重庆",
                "passLength": 48.691,
                "passYear": "2023"
            },
            {
                "orgCode": "CQ",
                "orgName": "重庆",
                "passLength": 383.413,
                "passYear": "2025"
            },
            {
                "orgCode": "GZ",
                "orgName": "贵州",
                "passLength": 234.249,
                "passYear": "2023"
            },
            {
                "orgCode": "GZ",
                "orgName": "贵州",
                "passLength": 114.871,
                "passYear": "2024"
            },
            {
                "orgCode": "HN",
                "orgName": "湖南",
                "passLength": 207.604,
                "passYear": "2025"
            },
            {
                "orgCode": "SC",
                "orgName": "四川",
                "passLength": 189.677,
                "passYear": "2020"
            },
            {
                "orgCode": "SC",
                "orgName": "四川",
                "passLength": 83.032,
                "passYear": "2022"
            },
            {
                "orgCode": "SC",
                "orgName": "四川",
                "passLength": 319.558,
                "passYear": "2024"
            },
            {
                "orgCode": "SC",
                "orgName": "四川",
                "passLength": 337.445,
                "passYear": "2025"
            },
            {
                "orgCode": "YN",
                "orgName": "云南",
                "passLength": 304.282,
                "passYear": "2022"
            },
            {
                "orgCode": "YN",
                "orgName": "云南",
                "passLength": 193.705,
                "passYear": "2024"
            }
        ]
    }
    return {
        "msgState": "SUCCESS",
        "msgType": "ARR",
        "msgDes": "QUERY",
        "msgContent": msgContent
    }
})


export default Mock;
