import { createApp, defineComponent, h, toRef } from "vue";
import App from "./App.vue";

import "@/styles/index.css";
import "@/styles/tailwind.css";

import router from "./router";
import "./router/helper";
import { store, key } from "./store";

import vueWaves from "@/directives/waves/index";
import Module from "@/components/module/index.vue";
import Modulen from "@/components/modulen/index.vue"; //新版蓝色的外层
import SvgIcon from "./components/svgIcon.vue";
import Switcher from "@/components/switcher.vue";
import dateSwitcher from "@/components/dateSwitcher/index.vue"; //新版时间选择（跟随上面新版Modulen）
import NewDateSwitcher from "@/components/newDataSwitcher/index.vue";
import Empty from "@/components/empty.vue";
import Ect from "@/components/ect.vue";
import Loading from "@/components/Loading.vue";

// import { ElTable, ElTableColumn, ElDatePicker } from 'element-plus'
import ElementPlus from "element-plus";
import "element-plus/lib/theme-chalk/index.css";

import "animate.css";

import "vite-plugin-svg-icons/register";

import * as dayjs from "dayjs";
import "dayjs/locale/zh-cn"; // 导入本地化语言
// import locale from 'element-plus/lib/locale'
import locale from "element-plus/lib/locale/lang/zh-cn";

import "./assets/font/font.css";
import webtracker from "webtracker";

// import "./mocks/mock_module01";
// import "./mocks/mock_module02";

// 设置语言
dayjs.locale("zh-cn");

// import  Socket  from './utils/socket'
// const socket = new Socket({
//     url:'ws://10.104.14.40:60000/api',
//     onOpen(res){
//         console.log('999999999999999999', res)
//     },
//     onClose(res){
//       console.log(this, 222222222)
//     },
//     onError(res){
//         console.log(res,23333333333)
//     }
// })
const app = createApp(App);

app.component("Module", Module);
app.component("Modulen", Modulen);
app.component("Switcher", Switcher);
app.component("dateSwitcher", dateSwitcher);
app.component("NewDateSwitcher", NewDateSwitcher);
app.component("Empty", Empty);
app.component("Ect", Ect);
app.component("Loading", Loading);

// app.component(ElTable.name, ElTable)
// app.component(ElTableColumn.name, ElTableColumn)
// app.component(ElDatePicker.name, ElDatePicker)
// app.component('ElTable', ElTable)
// app.component('ElTableColumn', ElTableColumn)
// app.component('ElDatePicker', ElDatePicker)

app.use(ElementPlus, { locale });

app.component("SvgIcon", SvgIcon);

app.use(vueWaves);

app.use(router);
app.use(store, key);

// 用户行为数据上报
if (import.meta.env.VITE_APP_STATISTICS_REPORT_URL) {
	app.use(webtracker, {
		// 上报地址，必传
		reportUrl: import.meta.env.VITE_APP_STATISTICS_REPORT_URL,
		// 业务系统编码，与后端协商，必传
		appCode: "ZTJ_JSC",
		appName: "驾驶舱",
		// 用户id，如果需要统计用户在想状态，则必传
		userId: () => {
			return store.state.auth?.userInfo?.userCode;
		},

		// 页面展示相关的统计，可以为一个对象（如下），或者是true（默认）或者false，显式传false则不统计
		pv: {
			// 统计页面跳转情况，默认为true
			route: true,
			// 页面周期性上报，单位为ms
			interval: 120000,
		},
		beforeReport: (data: any, opts: any) => {
			// console.log("beforeReport", data, opts);
			if (!store.state.auth?.userInfo?.userCode) {
				// 未获取到用户id 不上报
				console.log("未获取到用户id 不进行上报");
				return false; // 返回false不上报
			}
		},
	});
}

app.mount("#app");
