import moment from "moment";
import axios from "@/utils/axiosCrossDomain";
import { parseStake } from "@/utils/road";
import { getLonLatByPos } from "@/api/gis";

const baseUrl = "/http-server-base/publish/quota-v1";

const api = `/bizapi1${baseUrl}`;
const apis = `/bizapi1/server-haikang/ronglian/getCameraUrl`;
// const vehicleApi = `/bizapi1/server-haikang/haikang/getCameras`;
const vehicleApi = `/bizapi2/http-server-plus/haikang/getCameras`;

/**
 * 道路救援事件
 * @param {string|Number} params 参数
 */
export function getDlxcEventCount(params) {
  return axios.get(`${api}/dlxcEventCount`, {
    params,
  });
}
/**
 * 实时事件列表
 * @param {string|Number} sectionId
 * @param {string|Number} queryDate
 */
export function getLiveEventList(params) {
  // return axios.get(`${api}/runtime-event-list`, {
  //   params
  // });
  return axios
    .get(`${api}/event-list-page`, {
      params,
    })
    .then(async (res) => {
      const { msgContent } = res;
      if (msgContent) {
        res.msgContent = await Promise.all(
          msgContent.map(async (item) => await formatEventInfo(item))
        );
      }
      return res;
    });
}

/**
 * 事件统计-总数
 * @param {string|Number} params 参数
 */
export function getEventStatistics(params) {
  return axios.get(`${api}/eventBlockCount`, { params });
}

/**
 * 事件统计-详情列表
 * @param {string|Number} params 参数
 */
export function getEventStatisticsList(params) {
  return axios.get(`${api}/eventLineCount`, {
    params,
  });
}

/**
 * 气象
 * @param {string|Number} params 参数
 */
export function getWeatherData(params) {
  return axios.post(`/bizapi1/proxy-weather-server/monitor`, params);
}

export function getLatlng(code) {
  return axios.get(`${api}/sectionWeather-latlng?sectionid=${code}`);
}

/**
 * 投诉咨询
 * @param {string|Number} params 参数
 */
export function getComplainList(params) {
  return axios.get(`${api}/complaintList`, {
    params,
  });
}
/**
 * 故障事件
 * @param {string|Number} params 参数
 */
export function getFaulttoxz(params) {
  return axios.get(`${api}/faulttoxz-list-page`, {
    params,
  });
}

//new接口
export function getcomplaintsAdvisoryCount(params) {
  return axios.get(`${api}/complaintsAdvisoryCount`, {
    params,
  });
}

//获取车牌选择下拉框接口
export function getVideoCameraResourceCar(params) {
  return axios.get(
    `${vehicleApi}?level=${params.level}&dimension=${params.dimension}`
  );
  // return axios.get(`${vehicleApi}`,{params})
}

// 获取视频路径
export function getVideoUrls(code) {
  return axios.get(`${apis}?cameraIndexCode=${code}`);
}

async function formatEventInfo(event) {
  if (!event) {
    return event;
  }
  const { eventHappenDt, lng, lat, eventDesc } = event;
  const t = moment(eventHappenDt);
  if (t.isValid()) {
    event.eventHappenDtTxt = t.format("YYYY年M月D日 H时mm分");
  }

  if ((lng && lat) || !eventDesc) {
    return event;
  }
  const formatedRoadNo = eventDesc.match(/[gs]\d{1,4}/i)?.[0]?.toUpperCase();
  const formatedStake =
    formatedRoadNo && eventDesc.match(/k\d+(\+\d{1,3})?/i)?.[0]?.toUpperCase();
  if (formatedStake) {
    event.roadNo = formatedRoadNo;
    const stake = parseStake(formatedStake);
    event.stake = stake;
    event.formatedStake = formatedStake;
    const res = await getLonLatByPos({
      // layerName: "gis_lx",
      // lxdm: formatedRoadNo,
      // sxxfx: 1,
      // m: stake,
      routeCode: formatedRoadNo,
      upDown: '1',
      stakeNum: stake,
    });
    if (res.msgState === 'SUCCESS' && res?.msgContent) {
      // const [lng, lat] = res.data.split(",");
      const lng = res.msgContent.lon
      const lat = res.msgContent.lat
      event.lat = lat;
      event.lng = lng;
    }
  }
  return event;
}
