import axios from "@/utils/axios";
import originAxios from "axios";

// const basePath = `${process.env.VUE_APP_GIS_SERVICE_BASE}`
const basePath = "https://hope.cmet1965.com:31002";
const basePath2 = "https://digit-adm.hope.cmet1965.com:58000";

let mapConfigFileName = "zsy_sjgtmap_tjyl";

// 通过应用渠道获取地图配置
export function getMapConfig(params) {
    return originAxios
        .get(
            `https://map.hope.cmet1965.com:58000/minemapapi/zsxz/zsy_sjgtmap_tjyl.json`,
            { params }
        )
        .then((res) => res.data);
}

// 通过经纬度获取桩号
export function getPosByLonLat(params) {
    return axios.get(`${basePath}/util/getZH02`, { params });
}

// 废弃
// 通过桩号获取经纬度
// export function getLonLatByPos(params) {
//   return axios.get(`${basePath}/util/getGPS02`, { params });
// }

// 通过桩号获取 02坐标系经纬度
export function getLonLatByPos(params) {
    return axios.get(`${basePath2}/route/mappingPoint`, {
        params: {
            pointType: "02",
            ...params,
        },
    });
}
