export type Options = {
    sessionId?: string | (() => string);
    appCode: string;
    appName?: string;
    appVersion?: string;
    pv: boolean | PvOptions;
    reportUrl: string;
    userId?: string | (() => string);
    extData?: () => Record<string, unknown>;
    debug?: boolean;
    captureException: boolean;
    beforeReport?: (reportData: ReportData, globalOptions: Options) => void | boolean | Promise<void | boolean>;
};
export type PvOptions = {
    route: boolean;
    interval: number;
};
export declare enum Type {
    PV = "PV"
}
export type ReportData = {
    type: Type;
    base: BaseInfo;
    data?: Record<string, unknown>;
    extData?: Record<string, unknown>;
};
export type BaseInfo = {
    sessionId: string;
    appCode: string;
    appName?: string;
    appVersion?: string;
    sdkVersion?: string;
    userId: string | (() => string);
    url: string;
    title: string;
    t: number;
};
