import type { Ref } from 'vue';
import type { BaseOptions, BaseResult, FormatOptions, FRPlaceholderType } from './core/types';
import type { ServiceParams } from './core/utils/types';
export interface LoadMoreResult<R, P extends unknown[], LR extends unknown[]> extends Omit<BaseResult<R, P>, 'queries' | 'refresh' | 'mutate'> {
    dataList: Ref<LR>;
    noMore: Ref<boolean>;
    loadingMore: Ref<boolean>;
    refreshing: Ref<boolean>;
    reloading: Ref<boolean>;
    loadMore: () => void;
    reload: () => void;
    refresh: () => void;
}
export declare type LoadMoreExtendsOption = {
    listKey?: string;
};
export declare type LoadMoreGenericExtendsOption<R> = {
    isNoMore?: (data: R) => boolean;
};
export declare type LoadMoreService<R, P extends unknown[], LR> = ((r: {
    data: R;
    dataList: LR;
}, ...args: P) => Promise<R>) | ((r: {
    data: R;
    dataList: LR;
}, ...args: P) => ServiceParams);
export declare type LoadMoreFormatOptions<R, P extends unknown[], FR> = Omit<FormatOptions<R, P, FR>, 'queryKey'> & LoadMoreGenericExtendsOption<R> & LoadMoreExtendsOption;
export declare type LoadMoreBaseOptions<R, P extends unknown[]> = Omit<BaseOptions<R, P>, 'queryKey'> & LoadMoreGenericExtendsOption<R> & LoadMoreExtendsOption;
export declare type LoadMoreMixinOptions<R, P extends unknown[], FR> = LoadMoreBaseOptions<R, P> | LoadMoreFormatOptions<R, P, FR>;
declare function useLoadMore<R, P extends unknown[] = any, LR extends unknown[] = any[]>(service: LoadMoreService<R, P, LR>): LoadMoreResult<R, P, LR>;
declare function useLoadMore<R, P extends unknown[] = any, FR = FRPlaceholderType, LR extends unknown[] = any[]>(service: LoadMoreService<R, P, LR>, options: LoadMoreFormatOptions<R, P, FR>): LoadMoreResult<FR, P, LR>;
declare function useLoadMore<R, P extends unknown[] = any, LR extends unknown[] = any[]>(service: LoadMoreService<R, P, LR>, options: LoadMoreBaseOptions<R, P>): LoadMoreResult<R, P, LR>;
export default useLoadMore;
