import type { Ref } from 'vue';
import type { Query } from '../types';
export declare type PartialRecord<T> = {
    [P in keyof T]: Partial<T[P]>;
};
export declare type RefObject = {
    [key: string]: Ref<any>;
};
export declare type UnRef<T> = T extends Ref<infer V> ? V : T;
export declare type UnWrapRefObject<T> = {
    [P in keyof T]: UnRef<T[P]>;
};
export declare type ServiceObject = Partial<RequestInit> & {
    [key: string]: any;
    url: string;
};
export declare type ServiceParams = string | ServiceObject;
export declare type IService<R, P extends unknown[]> = ((...args: P) => ServiceParams) | ServiceParams | Query<R, P> | Promise<R>;
