import type { RefObject, UnRef } from './types';
export declare const objectToString: () => string;
export declare const toTypeString: (val: unknown) => string;
export declare const isString: (val: unknown) => val is string;
export declare const isPlainObject: (val: unknown) => val is Record<string, any>;
export declare const isArray: (val: unknown) => val is any[];
export declare const isObject: (val: unknown) => val is Record<any, any>;
export declare const isPromise: (fn: unknown) => fn is Promise<unknown>;
export declare const isFunction: (fn: unknown) => fn is Function;
export declare const isNil: (val: unknown) => boolean;
export declare const isServer: boolean;
export declare const isDocumentVisibility: () => boolean;
export declare const isOnline: () => boolean;
export declare const unRefObject: <T extends RefObject>(val: T) => { [K in keyof T]: UnRef<T[K]>; };
export declare const resolvedPromise: Promise<null>;
export declare const requestProxy: (url: string, ...rest: any[]) => Promise<any>;
export declare const get: (source: Record<string, any>, path: string, defaultValue?: any) => any;
export declare function omit<T, K extends keyof T>(object: T, keys: Array<K>): Pick<T, Exclude<keyof T, K>>;
export declare const warning: (message: string, throwError?: boolean) => Error | undefined;
