import type { State } from '../types';
import type { UnWrapRefObject } from './types';
declare type CacheResultType<T> = {
    data: T;
    timer?: number;
    cacheTime: number;
};
declare type CacheKey = string;
export declare type CacheDataType<R, P extends unknown[]> = {
    queries?: {
        [key: string]: UnWrapRefObject<State<R, P>>;
    };
    latestQueriesKey?: string;
};
declare type GetCacheReturn<R, P extends unknown[]> = Omit<CacheResultType<CacheDataType<R, P>>, 'timer'> | undefined;
export declare const getCache: <R, P extends unknown[]>(cacheKey: CacheKey) => GetCacheReturn<R, P>;
export declare const setCache: <R, P extends unknown[]>(cacheKey: CacheKey, data: CacheDataType<R, P>, cacheTime: number) => void;
export declare const clearCache: (cacheKey?: string | undefined) => void;
export {};
