import CoordinateSequenceFactory from '../CoordinateSequenceFactory'
import hasInterface from '../../../../../hasInterface'
import CoordinateArraySequence from './CoordinateArraySequence'
import CoordinateSequence from '../CoordinateSequence'
import Serializable from '../../../../../java/io/Serializable'

export default class CoordinateArraySequenceFactory {
  readResolve () {
    return CoordinateArraySequenceFactory.instance()
  }
  create () {
    if (arguments.length === 1) {
      if (arguments[0] instanceof Array) {
        const coordinates = arguments[0]
        return new CoordinateArraySequence(coordinates)
      } else if (hasInterface(arguments[0], CoordinateSequence)) {
        const coordSeq = arguments[0]
        return new CoordinateArraySequence(coordSeq)
      }
    } else if (arguments.length === 2) {
      const size = arguments[0]
      let dimension = arguments[1]
      if (dimension > 3) dimension = 3
      if (dimension < 2) return new CoordinateArraySequence(size)
      return new CoordinateArraySequence(size, dimension)
    }
  }
  interfaces_ () {
    return [CoordinateSequenceFactory, Serializable]
  }
  getClass () {
    return CoordinateArraySequenceFactory
  }
  static instance () {
    return CoordinateArraySequenceFactory.instanceObject
  }

  static get serialVersionUID () { return -4099577099607551657 }
  static get instanceObject () { return new CoordinateArraySequenceFactory() }
}
