package com.artfess.base.enums;

import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

/**
 * 工程状态
 */
@Getter
public enum ProductStatusEnum {
    /**
     * 删除
     */

    ONT("1", "在建"),

    TWO("2", "已建"),

    THREE("3", "规划"),

    ;

    ProductStatusEnum(String type, String desc){
        this.type = type;
        this.desc = desc;
    }

    private String type;

    private String desc;

    public static String getDesc(String type){
        if(StringUtils.isEmpty(type)){
            return null;
        }
        ProductStatusEnum[] values = values();
        for (ProductStatusEnum state : values) {
            if (state.getType().equals(type)) {
                return state.getDesc();
            }
        }
        return null;
    }


    public static String getType(String desc){
        if(StringUtils.isEmpty(desc)){
            return null;
        }
        ProductStatusEnum[] values = values();
        for (ProductStatusEnum state : values) {
            if (state.getDesc().equals(desc)) {
                return state.getType();
            }
        }
        return null;
    }
}
