package com.artfess.base.conf;

import com.alibaba.xxpt.gateway.shared.client.http.ExecutableClient;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Component;

/**
 * @author 陈实
 * @Package com.artfess.base.conf
 * @date 2023/4/13 10:19
 * @Description:
 */
@Component
public class YkzDingConfig {

    @Value("${yukuiz.web.appKey}")
    private  String webAppKey ;

    @Value("${yukuiz.web.appSecret}")
    private String webAppSecret;

    @Value("${yukuiz.web.domainName}")
    private String webDomainName;

    @Value("${yukuiz.uc.appId}")
    private String ucAppId;

    @Value("${yukuiz.uc.appSecret}")
    private String ucAppSecret;

    @Value("${yukuiz.uc.domainName}")
    private String ucDomainName;

    public String getWebAppKey() {
        return webAppKey;
    }

    public void setWebAppKey(String webAppKey) {
        this.webAppKey = webAppKey;
    }

    public String getWebAppSecret() {
        return webAppSecret;
    }

    public void setWebAppSecret(String webAppSecret) {
        this.webAppSecret = webAppSecret;
    }

    public String getWebDomainName() {
        return webDomainName;
    }

    public void setWebDomainName(String webDomainName) {
        this.webDomainName = webDomainName;
    }

    public String getUcAppId() {
        return ucAppId;
    }

    public void setUcAppId(String ucAppId) {
        this.ucAppId = ucAppId;
    }

    public String getUcAppSecret() {
        return ucAppSecret;
    }

    public void setUcAppSecret(String ucAppSecret) {
        this.ucAppSecret = ucAppSecret;
    }

    public String getUcDomainName() {
        return ucDomainName;
    }

    public void setUcDomainName(String ucDomainName) {
        this.ucDomainName = ucDomainName;
    }


    @Bean
    public ExecutableClient getExecutableClient(){
        ExecutableClient executableClient = ExecutableClient.getInstance();
        executableClient.setDomainName(webDomainName);
        executableClient.setProtocal("https");
        //应用App Key
        executableClient.setAccessKey(webAppKey);
        //应用App Secret
        executableClient.setSecretKey(webAppSecret);
        executableClient.init();
        return executableClient;
    }

}
