package com.artfess.rabbitmq.config;

import org.springframework.amqp.core.AmqpTemplate;
import org.springframework.amqp.rabbit.connection.CorrelationData;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.UUID;

/**
 * @author 周渝森
 * @date 2020/8/20 10:12
 */
@Component
public class RabbitMqTemplate {

    @Autowired
    private RabbitTemplate rabbitTemplate;
    @Autowired
    private AmqpTemplate amqpTemplate;

    /**
     * 消息队列发送消息
     * @param exchange 交换机
     * @param routingKey 主题
     * @param object 发送内容
     */
    public void sendMessage(String exchange,String routingKey,Object object) {

        rabbitTemplate.convertAndSend(exchange,routingKey,object,message -> {
            //设置10秒过期
            message.getMessageProperties().setExpiration("10000");
            return message;
        });

    }

    /**
     * 消息队列发送不过期消息
     * @param exchange 交换机
     * @param routingKey 主题
     * @param object 发送内容
     */
    public void sendNotTTLMessage(String exchange,String routingKey,Object object) {
        CorrelationData correlationId = new CorrelationData(UUID.randomUUID().toString());
        rabbitTemplate.convertAndSend(exchange,routingKey,object,correlationId);
    }
}
