package com.artfess.base.enums;

import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

/**
 *  水库水源地
 */
@Getter
public enum WaterTypeEnum {
    /**
     * 删除
     */
    ONE("1", "既取又用"),

    TWO("2", "只取不用"),

    THREE("3", "只用不取"),


    ;

    WaterTypeEnum(String type, String desc){
        this.type = type;
        this.desc = desc;
    }

    private String type;

    private String desc;


    public static String getType(String desc){
        if(StringUtils.isEmpty(desc)){
            return null;
        }
        WaterTypeEnum[] values = values();
        for (WaterTypeEnum state : values) {
            if (state.getDesc().equals(desc)) {
                return state.getType();
            }
        }
        return null;
    }
}
