package com.artfess.base.enums;

import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

/**
 * 监测站类型
 */
@Getter
public enum STTypeEnum {
    /**
     *
     */
    PP("PP", "雨量站", "1"),

    ZZ("ZZ", "河道水位站", "3"),

    ZQ("ZQ", "河道水文站", "11"),

    RR("RR", "水库水文站", "2"),

    SS("SS", "生态流量站", "10"),

    WY("1", "位移点", "6"),

    SL("5", "渗流点", "4"),

    SY("3", "渗压点","5"),

    CYG("4", "测压管","12"),

    SP("7", "视频站","7"),

    AA("9","管道水表","9")
    ;

    STTypeEnum(String sttp, String desc, String type){
        this.sttp = sttp;
        this.desc = desc;
        this.type = type;
    }

    private String sttp;

    private String type;

    private String desc;

    public static String getDesc(String type){
        if(StringUtils.isEmpty(type)){
            return null;
        }
        STTypeEnum[] values = values();
        for (STTypeEnum state : values) {
            if (state.getType().equals(type)) {
                return state.getDesc();
            }
        }
        return null;
    }

    public static String getType(String sttp){
        if(StringUtils.isEmpty(sttp)){
            return null;
        }
        STTypeEnum[] values = values();
        for (STTypeEnum state : values) {
            if (state.getSttp().equals(sttp)) {
                return state.getType();
            }
        }
        return null;
    }

    public static String findBySttp(String sttp){
        if(StringUtils.isEmpty(sttp)){
            return null;
        }
        STTypeEnum[] values = values();
        for (STTypeEnum state : values) {
            if (state.getSttp().equals(sttp)) {
                return state.getDesc();
            }
        }
        return null;
    }
}
