package com.artfess.base.enums;

import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

/**
 * 基础对象
 */
@Getter
public enum BaseObjectEnum {
    /**
     * 删除
     */

    RES("1", "水库"),

    RV("2", "河流"),

    DIKE("3", "堤防"),

    HYST("4", "水电站"),

    ;

    BaseObjectEnum(String type, String desc){
        this.type = type;
        this.desc = desc;
    }

    private String type;

    private String desc;

    public static String getDesc(String type){
        if(StringUtils.isEmpty(type)){
            return null;
        }
        BaseObjectEnum[] values = values();
        for (BaseObjectEnum state : values) {
            if (state.getType().equals(type)) {
                return state.getDesc();
            }
        }
        return null;
    }
}
