import req from '@/request.js'
const portal = window.context.portal
export default {
    // 添加
    addData(data, cb) {
        req.post(portal + `/majorProjects/municipalMajorProjectManagement/v1/`, data).then(res => {
            cb(res.data)
        })
    },
    //修改
    editData(data, cb) {
        req.put(portal + `/majorProjects/municipalMajorProjectManagement/v1/`, data).then(res => {
            cb(res.data)
        })
    },
    //删除
    delDate(ids, cb) {
        req.remove(portal + `/majorProjects/municipalMajorProjectManagement/v1/?ids=` + ids).then(res => {
            cb(res.data)
        })
    },
    //查询
    pageQuery(data, cb) {
        req.post(portal + `/majorProjects/municipalMajorProjectManagement/v1/query`, data).then(res => {
            cb(res.data)
        })
    },
    //排序
    sortData(data, cb) {
        req.post(portal + `/majorProjects/municipalMajorProjectManagement/v1/updateSequence`, data).then(res => {
            cb(res.data)
        })
    },
    // id查询
    detailId(id, cb) {
        req.get(portal + `/majorProjects/municipalMajorProjectManagement/v1/` + id).then(rep => {
            cb(rep.data)
        })
    },
    //储备查询
    reserveProject(data, cb) {
        req.post(portal + `	/majorProjects/municipalMajorProjectManagement/v1/queryReserveProject`, data).then(res => {
            cb(res.data)
        })
    },


    /*具体措施申请*/
    // 查询
    measureQuery(data, cb) {
        req.post(portal + `/majorProjects/pilotSpecificMeasures/v1/query`, data).then(res => {
            cb(res.data)
        })
    },
    //保存
    measureSave(data, cb) {
        req.put(portal + `/majorProjects/pilotSpecificMeasures/v1/iterationAddSave`, data).then(res => {
            cb(res.data)
        })
    },
    //提交
    measureSubmit(data, cb) {
        req.put(portal + `/majorProjects/pilotSpecificMeasures/v1/iterationSaveAndCommit`, data).then(res => {
            cb(res.data)
        })
    },
    /*具体措施审核*/
    //查询
    auditQuery(data, cb) {
        req.post(portal + `/majorProjects/pilotSpecificMeasures/v1/iterationListByPage`, data).then(res => {
            cb(res.data)
        })
    },
    //保存
    auditSave(data, cb) {
        req.post(portal + `/majorProjects/pilotSpecificMeasures/v1/iteration`, data).then(res => {
            cb(res.data)
        })
    },
    //更新迭代查询

    // 迭代申请详情查询.
    measureQueryInfo(data, cb) {
        req.post(portal + `/majorProjects/pilotSpecificMeasures/v1/queryInfo`, data).then(res => {
            cb(res.data)
        })
    },
    // 根据项目详情id查询月度计划
    getMonthDetails(data, cb) {
        req.post(portal + `/majorProjects/pilotSpecificSchedule/v1/query`, data).then(res => {
            cb(res.data)
        })
    },
    // 查询举措列表
    getMeasuresList(data,cb) {
        req.post(portal + `/majorProjects/pilotSpecificMeasuresHistory/v1/addInfo`, data).then(res => {
            cb(res.data)
        })
    },
    // 查询更新迭代接口
    getUpdateMeasures(data,cb) {
        req.post(portal + `/majorProjects/pilotSpecificMeasuresHistory/v1/iterateInfo`, data).then(res => {
            cb(res.data)
        })
    },
    // 删除举措迭代
    deleteMeasuresById(id,cb) {
        req.post(portal + `/majorProjects/pilotSpecificMeasuresHistory/v1/delete/${id}`).then(res => {
            cb(res.data)
        })
    },
    // 查询历史
    getHistoryById(id,cb) {
        req.post(portal + `/majorProjects/pilotSpecificMeasuresHistory/v1/findByHis/${id}`).then(res => {
            cb(res.data)
        })
    },
    // 迭代审核列表查询
    getMeasuresAuditList(data,isAffirm,isInput,cb) {
        req.post(portal + `/majorProjects/pilotSpecificMeasuresHistory/v1/queryList?isAffirm=${isAffirm}&isInput=${isInput}`,data).then(res => {
            cb(res.data)
        })
    },
    // 审核查询迭代举措列表
    gteAuditMeasuresDetail(data,cb){
        req.post(portal + `/majorProjects/pilotSpecificMeasuresHistory/v1/auditInfo`, data).then(res => {
            cb(res.data)
        })
    },
    // 保存并上报时判断是否存在审核数据
    isSaveAndReport(id,cb) {
        req.post(portal + `/majorProjects/pilotSpecificMeasuresHistory/v1/ifExist/${id}`).then(res => {
            cb(res.data)
        })
    },
    // 删除新增迭代数据
    deleteAddById(id,isAffirm,cb) {
        req.post(portal + `/majorProjects/pilotSpecificMeasuresHistory/v1/deleteById/?id=${id}&isAffirm=${isAffirm}`).then(res => {
            cb(res.data)
        })
    }
}
