import req from '@/request.js'
const portal = window.context.portal
export default {
  // 文件录入
  documentEntry(data, cb) {
    req
      .post(portal + `/bizMeetingDocumentsConsidered/v1/insertInfo`, data)
      .then(res => {
        cb(res.data)
      })
  },
  // 根据id查询录入信息
  getEntryById(id, cb) {
    req
      .post(portal + `/bizMeetingDocumentsConsidered/v1/findByModel?id=${id}`)
      .then(res => {
        cb(res.data)
      })
  },
  // 修改
  updateDocumentEntry(data, cb) {
    req
      .post(portal + `/bizMeetingDocumentsConsidered/v1/updateInfo`, data)
      .then(res => {
        cb(res.data)
      })
  },
  // 分发
  distributeById(data, cb) {
    req
      .post(portal + `/bizMeetingDocumentsConsidered/v1/updateByStatus`, data)
      .then(res => {
        cb(res.data)
      })
  },
  // 更新页面查询
  queryAudit(data,isAffirm, cb) {
    req
      .post(portal + `/bizMeetingDocumentsConsidered/v1/queryAudit?isAffirm=${isAffirm}`, data)
      .then(res => {
        cb(res.data)
      })
  },

  // 更新录入
  addEntry(data,cb) {
    req
      .post(portal + `/fill/bizMeetingDocumentsPush/v1/insertInfo`, data)
      .then(res => {
        cb(res.data)
      })
  },
  // 修改
  updateEntry(data,cb) {
    req
      .post(portal + `/fill/bizMeetingDocumentsPush/v1/updateInfo`, data)
      .then(res => {
        cb(res.data)
      })
  },
  // 查询历史及详情
  getHistroyDetail(data,cb) {
    let {id,unitId} = data
    req
      .post(portal + `/bizMeetingDocumentsConsidered/v1/findByHis?id=${id}&unitId=${unitId}`, data)
      .then(res => {
        cb(res.data)
      })
  },
  //修改审核状态
  
  updateStatus(data,cb) {
    req
      .post(portal + `/fill/bizMeetingDocumentsPush/v1/updateByStatus`, data)
      .then(res => {
        cb(res.data)
      })
  } 
}
