import req from '@/request.js'
const portal = window.context.portal
export default {
	// 添加
	addData(data, cb) {
		req.post(portal + `/qf/invest/productivity/`, data).then(res => {
			cb(res.data)
		})
	},
	//修改
	editData(data, cb) {
		req.put(portal + `/qf/invest/productivity/detail/batchUpdate`, data).then(res => {
			cb(res.data)
		})
	},
	//删除
	delDate(ids, cb) {
		req.remove(portal + `/qf/invest/productivity/?ids=` + ids).then(res => {
			cb(res.data)
		})
	},
	//查询
	pageQuery(data, cb) {
		req.post(portal + `/qf/invest/productivity/query`, data).then(res => {
			cb(res.data)
		})
	},

	// id查询
	detailId(id, cb) {
		req.get(portal + `/qf/invest/productivity/` + id).then(rep => {
			cb(rep.data)
		})
	},
	//修改状态
	editStatus(data, cb) {
		req.put(portal + `/qf/invest/productivity/updateStatus`, data).then(res => {
			cb(res.data)
		})
	},
	//导入
	importExcel(data, cb) {
		req.post(portal + `/qf/invest/productivity/importExcel`, data).then(res => {
			cb(res.data)
		})
	},
	//导出
	export (data, cb) {
		req.post(portal + `/qf/invest/productivity/export`, data, 'blob').then(res => {
			cb(res.data)
		})
	},
	/*二级页面*/
	//批量添加
	saveData(data, cb) {
		req.post(portal + `/qf/invest/productivity/detail/batchSave`, data).then(res => {
			cb(res.data)
		})
	},
	//表格查询
	detailQuery(data, cb) {
		req.post(portal + `/qf/invest/productivity/detail/query`, data).then(res => {
			cb(res.data)
		})
	},
	//批量删除
	dleDetail(ids, cb) {
		req.remove(portal + `/qf/invest/productivity/detail/?ids=` + ids).then(res => {
			cb(res.data)
		})
	},

}
