import req from '@/request.js'
const portal = window.context.portal
export default {
    getProject(data) {
        return new Promise((resolve, reject) => {
            req.post(portal + `/majorProjects/BizMeetingMunicipal/v1/query`, data)
                .then(res => {
                    resolve(res && res.data || [])
                })
                .catch(err => {
                    reject(err)
                })
        })
    },
    // 删除数据
    delDataByIds(ids) {
        return new Promise((resolve, reject) => {
            req.remove(portal + `/majorProjects/BizMeetingMunicipal/v1/?ids=${ids}`)
                .then(res => {
                    resolve(res && res.data || [])
                })
                .catch(err => {
                    reject(err)
                })
        })
    },
    addData(data) {
        return new Promise((resolve, reject) => {
            req.post(portal + `/majorProjects/BizMeetingMunicipal/v1/`, data)
                .then(res => {
                    resolve(res && res.data || {})
                })
                .catch(err => {
                    reject(err)
                })
        })
    },
    editData(data) {
        return new Promise((resolve, reject) => {
            req.put(portal + `/majorProjects/BizMeetingMunicipal/v1/`, data)
                .then(res => {
                    resolve(res && res.data || {})
                })
                .catch(err => {
                    reject(err)
                })
        })
    },
    getDataById(id) {
        return new Promise((resolve, reject) => {
            req.get(portal + `/majorProjects/BizMeetingMunicipal/v1/` + id)
                .then(res => {
                    resolve(res && res.data || {})
                })
                .catch(err => {
                    reject(err)
                })
        })
    },
    publishPorject(data) {
        return new Promise((resolve, reject) => {
            req.post(portal + `/majorProjects/BizMeetingMunicipal/v1/sendBatch`, data)
                .then(res => {
                    resolve(res && res.data || {})
                })
                .catch(err => {
                    reject(err)
                })
        })
    },
    getProjectState(data) {
        return new Promise((resolve, reject) => {
            req.post(portal + `/majorProjects/BizMeetingMunicipal/v1/queryPage`, data)
                .then(res => {
                    resolve(res && res.data || [])
                })
                .catch(err => {
                    reject(err)
                })
        })
    },
    getProjectByGroup(data) {
        return new Promise((resolve, reject) => {
            req.post(portal + `/majorProjects/BizMeetingMunicipal/v1/queryGroupPage`, data)
                .then(res => {
                    resolve(res && res.data || [])
                })
                .catch(err => {
                    reject(err)
                })
        })
    },
    // 推进信息保存
    propelAdd(data) {
        return new Promise((resolve, reject) => {
            req.post(portal + `/majorProjects/bizMeetingMunicipalDetails/v1/`, data)
                .then(res => {
                    resolve(res && res.data || [])
                })
                .catch(err => {
                    reject(err)
                })
        })
    },
    // 推进信息修改
    propelUpdate(data) {
        return new Promise((resolve, reject) => {
            req.put(portal + `/majorProjects/bizMeetingMunicipalDetails/v1/`, data)
                .then(res => {
                    resolve(res && res.data || [])
                })
                .catch(err => {
                    reject(err)
                })
        })
    },
    // 推进详情
    getPropelDataById(id) {
        return new Promise((resolve, reject) => {
            req.get(portal + `/majorProjects/bizMeetingMunicipalDetails/v1/${id}`)
                .then(res => {
                    resolve(res && res.data || [])
                })
                .catch(err => {
                    reject(err)
                })
        })
    },

    // 推进撤回 
    propelRevocation({ id, status }) {
        return new Promise((resolve, reject) => {
            req.post(portal + `/majorProjects/bizMeetingMunicipalDetails/v1/cancel?id=${id}&status=${status}`)
                .then(res => {
                    resolve(res && res.data || [])
                })
                .catch(err => {
                    reject(err)
                })
        })
    },
    // 推进历史查询
    historyById(id) {
        return new Promise((resolve, reject) => {
            req.get(portal + `/majorProjects/bizMeetingMunicipalDetails/v1/selectHistory/${id}`)
                .then(res => {
                    resolve(res && res.data || [])
                })
                .catch(err => {
                    reject(err)
                })
        })
    },

    taskImplementation(data) {
        return new Promise((resolve, reject) => {
            req.post(portal + `/majorProjects/BizMeetingMunicipal/v1/queryList`, data)
              .then(res => {
                  resolve(res && res.data || [])
              })
              .catch(err => {
                  reject(err)
              })
        })
    },

    // 项目调整 
    projectAdjustment(ids) {
        return new Promise((resolve, reject) => {
            req.post(portal + `/majorProjects/BizMeetingMunicipal/v1/closeProject?ids=${ids}`)
                .then(res => {
                    resolve(res && res.data || [])
                })
                .catch(err => {
                    reject(err)
                })
        })  
    }

}