import req from '@/request.js'
import qs from 'qs'
import {Promise} from 'q'
const portal = window.context.portal
export default {
  //区县填报发布列表
  majorProjectsList(data,isAffirm) {
    return new Promise((resolve, reject) => {
      req
        .post(portal + `/bizCountyReformSituationFill/v1/queryPage?isAffirm=${isAffirm}`, data)
        .then(res => {
          resolve((res && res.data) || [])
        })
        .catch(err => {
          reject(err)
        })
    })
  },

  bizCountyReformMessageLog(data,isAffirm) {
    return new Promise((resolve, reject) => {
      req
        .post(portal + `/bizCountyReformMessageLog/v1/query`, data)
        .then(res => {
          resolve((res && res.data) || [])
        })
        .catch(err => {
          reject(err)
        })
    })
  },

  //区县发布
  districtPutOut(data) {
    let result = data.map(orgIds => `orgIds=${orgIds}`).join('&');
    return new Promise((resolve, reject) => {
      req
        .post(portal + `/bizCountyReformMessageLog/v1/sandMessage?${result}`)
        .then(res => {
          resolve((res && res.data) || [])
        })
        .catch(err => {
          reject(err)
        })
    })
  },

  //区县更新 列表
  booksList(data,isAffirm) {
    return new Promise((resolve, reject) => {
      req
        .post(portal + `/bizCountyReformSituationFill/v1/queryPage`, data)
        .then(res => {
          resolve((res && res.data) || [])
        })
        .catch(err => {
          reject(err)
        })
    })
  },

  //区县核准 列表
  checkAndApproveData(data) {
    return new Promise((resolve, reject) => {
      req
        .post(portal + `/bizCountyReformSituationFill/v1/managerialPage`, data)
        .then(res => {
          resolve((res && res.data) || [])
        })
        .catch(err => {
          reject(err)
        })
    })
  },

  //区县更新
  renewalOfDistrictsAndFirst(data){  //设置是否为主组织
    return new Promise((resolve, reject) => {
      req.post(portal+`/bizCountyReformSituationFill/v1/`,data).then(response => {
        resolve(response.data)
      }),error => {
        reject(error)
      }
    })
  },

  renewalOfDistrictsAndCounties(data){  //设置是否为主组织
    return new Promise((resolve, reject) => {
      req.put(portal+`/bizCountyReformSituationFill/v1/`,data).then(response => {
        resolve(response.data)
      }),error => {
        reject(error)
      }
    })
  },

  //区县回显
  countiesAreDisplayed(id) {
    return new Promise((resolve, reject) => {
      req
        .get(portal + `/bizCountyReformSituationFill/v1/${id}`)
        .then(res => {
          resolve((res && res.data) || [])
        })
        .catch(err => {
          reject(err)
        })
    })
  },

  //区县更新
  updateByStatus(data){
    return new Promise((resolve, reject) => {
      req.post(portal+`/bizCountyReformSituationFill/v1/updateByStatus`,data).then(response => {
        resolve(response.data)
      }),error => {
        reject(error)
      }
    })
  },

  //审核修改
  updateForm(data){
    return new Promise((resolve, reject) => {
      req.put(portal+`/bizCountyReformSituationFill/v1/updateForm`,data).then(response => {
        resolve(response.data)
      }),error => {
        reject(error)
      }
    })
  },

  //历史驳回
  turnDownChange(data){
    return new Promise((resolve, reject) => {
      req.post(portal+`/bizCountyReformSituationFill/v1/rejectNode`,data).then(response => {
        resolve(response.data)
      }),error => {
        reject(error)
      }
    })
  },

  //区县历史数据回显
  countyHistory(data) {
    return new Promise((resolve, reject) => {
      req
        .post(portal + `/bizCountyReformSituationFill/v1/history`,data)
        .then(res => {
          resolve((res && res.data) || [])
        })
        .catch(err => {
          reject(err)
        })
    })
  },

}
