import req from '@/request.js'
const portal = window.context.portal
export default {


    // 添加
    addData(data, cb) {
        req.post(portal + `/majorProjects/municipalMajorProjectManagement/v1/`, data).then(res => {
            cb(res.data)
        })
    },
    //修改
    editData(data, cb) {
        req.put(portal + `/majorProjects/municipalMajorProjectManagement/v1/`, data).then(res => {
            cb(res.data)
        })
    },
    // 项目状态更新
    updateStatus(data, cb) {
        req.post(portal + `/majorProjects/municipalMajorProjectManagement/v1/updateStatus`, data).then(res => {
            cb(res.data)
        })
    },
    // 录入、审核、确认项目列表查询
    queryProjectStatus(isAffirm, data, cb) {
        req.post(portal + `/majorProjects/municipalMajorProjectManagement/v1/queryList?isAffirm=` + isAffirm, data).then(res => {
            cb(res.data)
        })
    },
    // 下发项目
    sendProject(data, cb) {
        req.request({
            method: 'post',
            url: portal + `/majorProjects/municipalMajorProjectManagement/v1/sendProject`,
            data,
            headers: {
                'Content-type': 'application/x-www-form-urlencoded'
            }
        }).then(res => {
            cb(res.data)
        })
    },
    // 撤回
    revocation(data, cb) {
        req.request({
            method: 'post',
            url: portal + `/majorProjects/municipalMajorProjectManagement/v1/revocation`,
            data,
            headers: {
                'Content-type': 'application/x-www-form-urlencoded'
            }
        }).then(res => {
            cb(res.data)
        })
    },
    //删除
    delDate(ids, cb) {
        req.remove(portal + `/majorProjects/municipalMajorProjectManagement/v1/?ids=` + ids).then(res => {
            cb(res.data)
        })
    },
    // 关闭项目
    lockProject(ids, cb) {
        req.post(portal + `/majorProjects/municipalMajorProjectManagement/v1/closeProject?` + ids).then(res => {
            cb(res.data)
        })
    },
    // 判断是否删除量化目标
    deleteLhmb(id, cb) {
        req.remove(portal + `/majorProjects/pilotQuantitativeObjectives/v1/${id}`).then(res => {
            cb(res.data)
        })
    },
    // 判断是否删除具体举措
    deleteJtjc(id, cb) {
        req.remove(portal + `/majorProjects/pilotSpecificMeasures/v1/${id}`).then(res => {
            cb(res.data)
        })
    },
    // 判断是否删除进度计划
    deleteJdjh(id, cb) {
        req.remove(portal + `/majorProjects/pilotSpecificSchedule/v1/${id}`).then(res => {
            cb(res.data)
        })
    },
    // 删除月度计划
    deleteMonth(id, cb) {
        req.remove(portal + `/majorProjects/pilotSpecificSchedule/v1/ggbDeleteById/${id}`).then(res => {
            cb(res.data)
        })
    },
    //查询
    pageQuery(data, cb) {
        req.post(portal + `/majorProjects/municipalMajorProjectManagement/v1/query`, data).then(res => {
            cb(res.data)
        })
    },
    //排序
    sortData(data, cb) {
        req.post(portal + `/majorProjects/municipalMajorProjectManagement/v1/updateSequence`, data).then(res => {
            cb(res.data)
        })
    },
    // id查询
    detailId(id, cb) {
        req.get(portal + `/majorProjects/municipalMajorProjectManagement/v1/` + id).then(rep => {
            cb(rep.data)
        })
    },
    //储备查询
    reserveProject(data, cb) {
        req.post(portal + `/majorProjects/municipalMajorProjectManagement/v1/queryReserveProject`, data).then(res => {
            cb(res.data)
        })
    },
    //带权限查询
    authorityQuery(data, cb) {
        req.post(portal + `/majorProjects/municipalMajorProjectManagement/v1/queryList`, data).then(res => {
            cb(res.data)
        })
    },

    /*
    重大项目推进
    */
    //目标查询
    targetQuery(data, cb) {
        req.post(portal + `/majorProjects/pilotQuantitativeObjectives/v1/query`, data).then(res => {
            cb(res.data)
        })
    },
    //保存
    targetSave(data, cb) {
        req.put(portal + `/majorProjects/pilotQuantitativeObjectivesPush/v1/objectivesPushSaveSaveAndCommit`, data)
            .then(res => {
                cb(res.data)
            })
    },
    //计划查询
    planQuery(data, cb) {
        req.post(portal + `/majorProjects/pilotSpecificSchedule/v1/query`, data).then(res => {
            cb(res.data)
        })
    },
    //计划保存
    planSave(data, cb) {
        req.put(portal + `/majorProjects/pilotSpecificSchedulePush/v1/schedulePushSaveSaveAndCommit`, data).then(
            res => {
                cb(res.data)
            })
    },



    /* 
    重大项目推进
    */
    //保存
    savaBoostData(data, cb) {
        req.put(portal + `/majorProjects/bizPilotProjectFill/v1/saveVo`, data).then(res => {
            cb(res.data)
        })
    },
    //审核
    aduitBoostData(data, cb) {
        req.put(portal + `/majorProjects/bizPilotProjectFill/v1/commitVo`, data).then(res => {
            cb(res.data)
        })
    },
    //根据id查询
    boostDetailId(data, cb) {
        req.post(portal + `/majorProjects/bizPilotProjectFill/v1/examineInit`, data).then(rep => {
            cb(rep.data)
        })
    },
    //根据记录id查询详情
    getDetailsId(id, cb) {
        req.get(portal + `/majorProjects/bizPilotProjectFill/v1/getDetails?id=` + id).then(rep => {
            cb(rep.data)
        })
    },
    //id查询历史数据
    historyDetails(id, cb) {
        req.get(portal + `/majorProjects/bizPilotProjectFill/v1/getHistoryDetails?projectId=` + id).then(rep => {
            cb(rep.data)
        })
    },
    //判断是否审核中
    AuditOrNot(id, cb) {
        req.get(portal + `/majorProjects/bizPilotProjectFill/v1/haveExamine?projectId=` + id).then(rep => {
            cb(rep.data)
        })
    },



    /*
    项目推进审核
    */
    //列表
    listQuery(data, cb) {
        req.post(portal + `/majorProjects/bizPilotProjectFill/v1/queyrList`, data).then(
            res => {
                cb(res.data)
            })
    },
    //目标查询
    auditTargetQuery(data, cb) {
        req.post(portal + `/majorProjects/pilotQuantitativeObjectivesPush/v1/objectivesPushListByPage`, data).then(
            res => {
                cb(res.data)
            })
    },

    //目标审核驳回
    auditTargetSave(data, cb) {
        req.put(portal + `/majorProjects/bizPilotProjectFill/v1/examineVo`, data).then(res => {
            cb(res.data)
        })
    },
    //计划查询
    auditPlanQuery(data, cb) {
        req.post(portal + `/majorProjects/pilotSpecificSchedulePush/v1/schedulePushListByPage`, data).then(res => {
            cb(res.data)
        })
    },
    //计划审核驳回
    auditPlanSave(data, cb) {
        req.post(portal + `/majorProjects/pilotSpecificSchedulePush/v1/schedulePushExamine`, data).then(res => {
            cb(res.data)
        })
    },

    // 专项小组列表查询
    getGroupTableData(data,code,cb) {
        req.post(portal + `/majorProjects/municipalMajorProjectManagement/v1/queryListGroup?code=${code}`, data).then(res => {
            cb(res.data)
        })
    },

    // 作战图专项小组审核查询
    getGroupAuditTableData(data,cb) {
        req.post(portal + `/majorProjects/municipalMajorProjectManagement/v1/groupList`, data).then(res => {
            cb(res.data)
        })
    },


    // 加快实施一批同步数据查询
    quickenSynchronizationList(data,cb) {
        req.post(portal + `/majorProjects/municipalMajorProjectManagement/v1/relevancy`, data).then(res => {
            cb(res.data)
        })
    },
    // 加快实施一批数据同步
    quickenSynchronization(data,cb) {
        req.post(portal + `/majorProjects/municipalMajorProjectManagement/v1/push`, data).then(res => {
            cb(res.data)
        })
    },

    // 两个一批同步数据查询
    twoBatchesSynchronizationList(data, cb) {
        req.post(portal + `/bizMunicipalNotSatrtProjectManagement/v1/relevancy`, data).then(res => {
            cb(res.data)
        })
    },

    // 两个一批数据同步
    twoBatchesSynchronization(data,cb) {
        req.post(portal + `/bizMunicipalNotSatrtProjectManagement/v1/push`, data).then(res => {
            cb(res.data)
        })
    },

}
