package com.artfess.uc.manager.impl;

import com.artfess.uc.model.UserUnite;
import com.artfess.uc.dao.UserUniteDao;
import com.artfess.uc.manager.UserUniteManager;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.StringUtil;

import org.springframework.stereotype.Service;

/**
 * 用户与外部通讯录关系表 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author pangquan
 * @since 2020-10-30
 */
@Service
public class UserUniteManagerImpl extends BaseManagerImpl<UserUniteDao, UserUnite> implements UserUniteManager {

	@Override
	public void updateUserUnite(UserUnite userUnite) {
		QueryWrapper<UserUnite> queryWrapper = new QueryWrapper<UserUnite>().eq("user_id_", userUnite.getUserId());
		UserUnite exist = this.getOne(queryWrapper);
		if(BeanUtils.isNotEmpty(exist)){
			if(StringUtil.isNotEmpty(userUnite.getOpenId())){
				exist.setOpenId(userUnite.getOpenId());
			}
			if(StringUtil.isNotEmpty(userUnite.getWxWorkId())){
				exist.setWxWorkId(userUnite.getWxWorkId());
			}
			if(StringUtil.isNotEmpty(userUnite.getDingtalkId())){
				exist.setDingtalkId(userUnite.getDingtalkId());
			}
			this.update(exist);
		}else{
			this.create(userUnite);
		}
	}

}
