package com.artfess.ljzc.welfare.manager;

import com.alibaba.fastjson.JSONObject;
import com.artfess.base.manager.BaseManager;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.ljzc.welfare.model.AssetPubilcInfo;
import com.artfess.ljzc.welfare.vo.AssetPubilcInfoVo;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.sun.star.awt.DeviceInfo;

import java.util.List;

/**
 * 公益资产信息 服务类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2023-11-27
 */
public interface AssetPubilcInfoManager extends BaseManager<AssetPubilcInfo> {

    /**
     * 分页查询
     * @param
     * @Return: java.lang.String
     * @Author: chens
     * @Date: 2023/10/9 11:17
     */
    PageList<AssetPubilcInfoVo> queryPubilcInfoVoPage(QueryFilter<AssetPubilcInfo> queryFilter);


    /**
     * 保存公益资产信息
     * @param PubilcInfo
     * @Return: java.lang.String
     * @Author: chens
     * @Date: 2023/10/9 11:17
     */
    String insertPubilcInfo(AssetPubilcInfo PubilcInfo) throws Exception;

    /**
     * 修改公益资产信息
     * @param PubilcInfo
     * @Return: java.lang.String
     * @Author: chens
     * @Date: 2023/10/9 11:17
     */
    Boolean updatePubilcInfo(AssetPubilcInfo PubilcInfo) throws Exception;

    /**
     * 删除公益资产信息
     * @param id
     * @Return: java.lang.String
     * @Author: chens
     * @Date: 2023/10/9 11:17
     */
    Boolean deletePubilcInfo(String id);

    /**
     * 删除公益资产信息
     * @param ids 公益id集合
     * @Return: java.lang.String
     * @Author: chens
     * @Date: 2023/10/9 11:17
     */
    Boolean deleteBachPubilcInfo(List<String> ids);

    /**
     * 根据ID查询公益资产信息
     * @param id
     * @Return: java.lang.String
     * @Author: chens
     * @Date: 2023/10/9 11:17
     */
    AssetPubilcInfo findPubilcInfo(String id);

    /**
     * 审核公益资产信息入库
     * @param status 入库审核状态（0：未审核，1：已审核）
     * @param idList 资产ID集合
     * @Return: java.lang.String
     * @Author: chens
     * @Date: 2023/10/9 11:17
     */
    Boolean auditLoan(String status,String msg,List<String> idList);

    JSONObject publicStatistics(String fullId);
}
