package com.artfess.ljzc.business.model;

import com.alibaba.excel.annotation.ExcelProperty;
import com.artfess.base.entity.BizDelModel;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.FieldRepeat;
import com.artfess.base.valid.UpdateGroup;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Null;
import java.math.BigDecimal;

/**
 * 经营性资产的基础信息
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2023-11-27
 */
@Data
@FieldRepeat(message = "资产名称已重复",fields = {"name","projectId"})
@ApiModel(value="BizAssetBusinessInfo对象", description="经营性资产的基础信息")
public class BizAssetBusinessInfo extends BizDelModel<BizAssetBusinessInfo> {

    private static final long serialVersionUID = 1L;

    @NotNull(message = "修改必须指定id",groups = {UpdateGroup.class})
    @Null(message = "新增不能指定id",groups = {AddGroup.class})
    @ApiModelProperty(value = "主键ID")
    @TableId(value = "id_", type = IdType.ASSIGN_ID)
    private String id;
    @ExcelProperty("项目")
    @NotBlank(message = "请选择项目", groups = {AddGroup.class, UpdateGroup.class})
    @ApiModelProperty(value = "项目ID")
    @TableField("project_id_")
    private String projectId;

    @NotBlank(message = "请选择楼栋", groups = {AddGroup.class, UpdateGroup.class})
    @ApiModelProperty(value = "楼栋ID")
    @TableField("building_id_")
    private String buildingId;

    @ApiModelProperty(value = "户号（唯一）")
    @TableField("asset_no_")
    private String assetNo;

    @ApiModelProperty(value = "数据来源（0：手工录入，1：三方系统导入,，2：excel导入）")
    @TableField("source_")
    private String source;

    @ApiModelProperty(value = "所在楼层")
    @TableField("asset_floor_")
    private Integer assetFloor;

    @NotBlank(message = "请填写资产名称", groups = {AddGroup.class, UpdateGroup.class})
    @ApiModelProperty(value = "资产名称")
    @TableField("name_")
    private String name;

    @NotBlank(message = "请填写资产门牌号", groups = {AddGroup.class, UpdateGroup.class})
    @ApiModelProperty(value = "资产门牌号")
    @TableField("code_")
    private String code;

    @ApiModelProperty(value = "资产详细地址")
    @TableField("address_")
    private String address;

    @NotBlank(message = "请选择资产类型", groups = {AddGroup.class, UpdateGroup.class})
    @ApiModelProperty(value = "资产类型（字典：物业资产，商品房）")
    @TableField("asset_type_")
    private String assetType;

    @ApiModelProperty(value = "资产业态（字典：餐饮，零售，品牌商家，车位，配套设施，超市，住宅，写字楼，行政服务，厂房，仓库，学校，酒店，医院）")
    @TableField("asset_business_")
    private String assetBusiness;

    @ApiModelProperty(value = "资产来源（字典：自建，购买，划拨，置换，出让）")
    @TableField("asset_src_")
    private String assetSrc;

    @ApiModelProperty(value = "资产属性（字典：政府资产，企业资产）")
    @TableField("asset_nature_")
    private String assetNature;

    @ApiModelProperty(value = "资产归属（字典：自持，代管）")
    @TableField("asset_belong_")
    private String assetBelong;

    @ApiModelProperty(value = "所属单位ID")
    @TableField("belongs_org_id_")
    private String belongsOrgId;

    @ApiModelProperty(value = "所属单位")
    @TableField("belongs_org_name_")
    private String belongsOrgName;

    @ApiModelProperty(value = "所属单位fullid")
    @TableField("belongs_org_full_id_")
    private String belongsOrgFullId;

    @ApiModelProperty(value = "装修状态（字典：1：毛坯，2：简装，3：精装）")
    @TableField("asset_decorate_")
    private String assetDecorate;

    @ApiModelProperty(value = "建筑面积（㎡）")
    @TableField("structure_area_")
    private BigDecimal structureArea;

    @ApiModelProperty(value = "未确权面积（㎡）")
    @TableField("unconfirm_area_")
    private BigDecimal unconfirmArea;

    @ApiModelProperty(value = "可出租面积（㎡）")
    @TableField("hire_area_")
    private BigDecimal hireArea;

    @ApiModelProperty(value = "账面价值（元）")
    @TableField("book_value_")
    private BigDecimal bookValue;

    @ApiModelProperty(value = "是否账外资产（字典：0：否，1：是）")
    @TableField("is_out_asset_")
    private String isOutAsset;

    @ApiModelProperty(value = "租赁单价（元/㎡/月)）")
    @TableField("hire_price_")
    private BigDecimal hirePrice;

    @ApiModelProperty(value = "租赁底价（元/㎡/月)）")
    @TableField("hire_base_price_")
    private BigDecimal hireBasePrice;

    @ApiModelProperty(value = "资产状态（字典：闲置，自用，出租，借用，被占用，存量，新增，其他）")
    @TableField("asset_status_")
    private String assetStatus;

    @ApiModelProperty(value = "资产情况")
    @TableField("asset_situation_")
    private String assetSituation;

    @ApiModelProperty(value = "资产审核状态（-1：草稿，0：未审核，1：不通过，2：已审核）")
    @TableField("asset_audit_")
    private String assetAudit;

    @ApiModelProperty(value = "审核意见")
    @TableField("audit_msg_")
    private String assetMsg;

    @ApiModelProperty(value = "备注")
    @TableField("remark_")
    private String remark;

    @ApiModelProperty(value = "租户ID")
    @TableField("tenant_id_")
    private String tenantId;

    @ApiModelProperty(value = "项目名称")
    @TableField(exist = false)
    private String projectName;

    @ApiModelProperty(value = "楼栋名称")
    @TableField(exist = false)
    private String buildingName;

    @ApiModelProperty(value = "使用信息")
    @TableField(exist = false)
    private BizAssetBusinessUse assetBusinessUse;

    @ApiModelProperty(value = "权属信息")
    @TableField(exist = false)
    private BizAssetBusinessWarrents assetBusinessWarrents;
}
