/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.portal.kh.controller;

import com.alibaba.fastjson.JSON;
import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.annotation.PowerLogInfo;
import com.artfess.base.controller.BaseController;
import com.artfess.base.enums.LogType;
import com.artfess.base.enums.OperationType;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.model.CommonResult;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.UpdateGroup;
import com.artfess.i18n.util.I18nUtil;
import com.artfess.portal.kh.manager.KhSubjectManager;
import com.artfess.portal.kh.model.KhSubject;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u7ee9\u6548\u8003\u6838-\u8003\u6838\u79d1\u76ee\u4fe1\u606f"})
@RequestMapping(value={"/kh/subject/"})
@ApiGroup(group={"group_system"})
public class KhSubjectController
extends BaseController<KhSubjectManager, KhSubject> {
    private static final Logger log = LoggerFactory.getLogger(KhSubjectController.class);

    @PostMapping(value={"/"})
    @ApiOperation(value="\u6dfb\u52a0\u5b9e\u4f53\u7684\u63a5\u53e3")
    public CommonResult<String> create(@ApiParam(name="model", value="\u5b9e\u4f53\u4fe1\u606f") @RequestBody @Validated(value={AddGroup.class}) KhSubject t) {
        String id = ((KhSubjectManager)this.baseService).insertTree(t);
        if (t.getSn() == null) {
            t.setSn(((KhSubjectManager)this.baseService).getNextSequence(null));
        }
        ((KhSubjectManager)this.baseService).updateById((Object)t);
        if (!StringUtils.isNotBlank((CharSequence)id)) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, null);
        }
        return new CommonResult();
    }

    @PutMapping(value={"/"})
    @ApiOperation(value="\u66f4\u65b0\u5b9e\u4f53")
    public CommonResult<String> updateById(@ApiParam(name="model", value="\u5b9e\u4f53\u4fe1\u606f") @RequestBody @Validated(value={UpdateGroup.class}) KhSubject t) {
        KhSubject byId = (KhSubject)((Object)((KhSubjectManager)this.baseService).getById((Serializable)((Object)t.getId())));
        String id = ((KhSubjectManager)this.baseService).updateTree(t, byId.getName());
        if (t.getSn() == null) {
            t.setSn(((KhSubjectManager)this.baseService).getNextSequence(null));
        }
        ((KhSubjectManager)this.baseService).updateById((Object)t);
        if (!StringUtils.isNotBlank((CharSequence)id)) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, null);
        }
        return new CommonResult();
    }

    @DeleteMapping(value={"/{id}"})
    @ApiOperation(value="\u6839\u636eid\u5220\u9664")
    public CommonResult<String> deleteById(@ApiParam(name="id", value="\u5b9e\u4f53id") @PathVariable String id) {
        boolean result = ((KhSubjectManager)this.baseService).removeById((Serializable)((Object)id));
        if (!result) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, null);
        }
        return new CommonResult();
    }

    @DeleteMapping(value={"/"})
    @ApiOperation(value="\u6839\u636eid\u96c6\u5408\u6279\u91cf\u5220\u9664")
    public CommonResult<String> deleteByIds(String ... ids) {
        boolean result = ((KhSubjectManager)this.baseService).removeByIds(Arrays.asList(ids));
        if (!result) {
            return new CommonResult(false, I18nUtil.getMessage((String)"delete.fail", (Locale)LocaleContextHolder.getLocale()), null);
        }
        return new CommonResult(true, I18nUtil.getMessage((String)"option.success", (Locale)LocaleContextHolder.getLocale()), null);
    }

    @PostMapping(value={"/getTree"})
    @ApiOperation(value="\u83b7\u53d6\u79d1\u76ee\u4fe1\u606f\u4e0b\u62c9\u6811")
    @PowerLogInfo(logType=LogType.BIZ, operaionType=OperationType.QUERY, description="\u83b7\u53d6\u79d1\u76ee\u4fe1\u606f\u4e0b\u62c9\u6811")
    public CommonResult<String> getTree(@ApiParam(name="model", value="\u83b7\u53d6\u79d1\u76ee\u4fe1\u606f\u4e0b\u62c9\u6811") @RequestBody KhSubject entity) {
        log.info("\u83b7\u53d6\u79d1\u76ee\u4fe1\u606f\u4e0b\u62c9\u6811\u8bf7\u6c42\u53c2\u6570:{}", (Object)JSON.toJSONString((Object)((Object)entity)));
        List<KhSubject> list = ((KhSubjectManager)this.baseService).getTree(entity);
        return CommonResult.success(list, null);
    }

    @RequestMapping(value={"updateSequence"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6279\u91cf\u4fee\u6539\u6392\u5e8f\u53f7", notes="\u6279\u91cf\u4fee\u6539\u6392\u5e8f\u53f7")
    public CommonResult<String> updateSequence(@ApiParam(name="params", value="\u6392\u5e8f\u53c2\u6570\uff1aKey\uff1aID\uff0cValue\uff1a\u6392\u5e8f\u53f7") @RequestBody HashMap<String, Integer> params) throws Exception {
        if (!params.isEmpty()) {
            ((KhSubjectManager)this.baseService).updateSequence(params);
        }
        return new CommonResult(true, I18nUtil.getMessage((String)"option.success", (Locale)LocaleContextHolder.getLocale()), null);
    }
}

