/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.bpm.engine.task.handler;

import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.StringUtil;
import com.artfess.bpm.api.constant.ActionType;
import com.artfess.bpm.api.model.identity.BpmIdentity;
import com.artfess.bpm.api.model.process.def.NodeProperties;
import com.artfess.bpm.api.model.process.nodedef.BpmNodeDef;
import com.artfess.bpm.api.model.process.nodedef.ext.SignNodeDef;
import com.artfess.bpm.api.model.process.nodedef.ext.UserTaskNodeDef;
import com.artfess.bpm.api.model.process.task.BpmTask;
import com.artfess.bpm.api.plugin.core.def.TaskActionHandlerDef;
import com.artfess.bpm.api.plugin.core.session.TaskActionPluginSession;
import com.artfess.bpm.api.service.BpmDefinitionAccessor;
import com.artfess.bpm.api.service.BpmInstService;
import com.artfess.bpm.engine.task.cmd.DefaultTaskFinishCmd;
import com.artfess.bpm.engine.task.handler.AbstractTaskActionHandler;
import com.artfess.bpm.persistence.manager.BpmExeStackExecutorManager;
import com.artfess.bpm.persistence.manager.BpmExeStackManager;
import com.artfess.bpm.persistence.manager.BpmProcessInstanceManager;
import com.artfess.bpm.persistence.manager.BpmSignDataManager;
import com.artfess.bpm.persistence.model.BpmExeStack;
import com.artfess.bpm.persistence.model.DefaultBpmProcessInstance;
import com.artfess.uc.api.service.IUserService;
import java.io.Serializable;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component
public class TaskActionBackToStartHandler
extends AbstractTaskActionHandler {
    @Resource
    BpmDefinitionAccessor bpmDefinitionAccessor;
    @Resource
    BpmInstService bpmInstService;
    @Resource
    IUserService userServiceImpl;
    @Resource
    BpmExeStackManager bpmExeStackManager;
    @Resource
    BpmProcessInstanceManager bpmProcessInstanceManager;
    @Resource
    BpmExeStackExecutorManager exeStrackExecutorManager;
    @Resource
    BpmSignDataManager bpmSignDataManager;

    @Override
    public boolean isNeedCompleteTask() {
        return true;
    }

    @Override
    public ActionType getActionType() {
        return ActionType.BACK_TO_START;
    }

    @Override
    public void preActionHandler(TaskActionPluginSession pluginSession, TaskActionHandlerDef def) throws Exception {
        DefaultTaskFinishCmd cmd = (DefaultTaskFinishCmd)pluginSession.getTaskFinishCmd();
        String instId = cmd.getInstId();
        String targeNode = cmd.getDestination();
        String handMode = (String)cmd.getTransitVars("backHandMode");
        BpmTask task = (BpmTask)cmd.getTransitVars("bpmTask_");
        if (StringUtil.isEmpty((String)targeNode)) {
            BpmNodeDef bpmNodeDef;
            UserTaskNodeDef backTargetNodeDef;
            NodeProperties nodeProperties;
            String backUserMode;
            DefaultBpmProcessInstance inst = (DefaultBpmProcessInstance)this.bpmProcessInstanceManager.get((Serializable)((Object)instId));
            if (StringUtil.isNotZeroEmpty((String)inst.getParentInstId())) {
                throw new RuntimeException("\u591a\u5b9e\u4f8b\u7684\u5185\u5d4c\u5b50\u6d41\u7a0b\u4e0d\u5141\u8bb8\u9a73\u56de\u5230\u4e3b\u6d41\u7a0b!");
            }
            BpmExeStack stack = this.bpmExeStackManager.getInitStack(instId);
            cmd.setDestination(stack.getNodeId());
            String destinationNode = cmd.getDestination();
            if (!(stack.getInterpose() != 0 || stack.getIsMulitiTask() != 0 || cmd.getTransitVars("IsDoneUnused") != null && ((Boolean)cmd.getTransitVars("IsDoneUnused")).booleanValue() || !StringUtil.isEmpty((String)(backUserMode = (nodeProperties = (backTargetNodeDef = (UserTaskNodeDef)this.bpmDefinitionAccessor.getBpmNodeDef(stack.getPrcoDefId(), destinationNode)).getLocalProperties()).getBackUserMode())) && !backUserMode.equals("history"))) {
                List<BpmIdentity> identitys = this.exeStrackExecutorManager.getBpmIdentitysByStackId(stack.getId());
                cmd.addBpmIdentity(stack.getNodeId(), identitys);
            }
            if (BeanUtils.isNotEmpty((Object)((Object)stack)) && stack.getInterpose() == 0 && stack.getIsMulitiTask() == 0 && cmd.getTransitVars("IsDoneUnused") != null && ((Boolean)cmd.getTransitVars("IsDoneUnused")).booleanValue() && (bpmNodeDef = this.bpmDefinitionAccessor.getBpmNodeDef(stack.getPrcoDefId(), destinationNode)) instanceof SignNodeDef) {
                List<BpmIdentity> signBpmIdentity = this.bpmSignDataManager.getByInstanIdAndNodeIdAndNo(instId, destinationNode);
                cmd.addBpmIdentity(destinationNode, signBpmIdentity);
                return;
            }
        }
        this.bpmExeStackManager.popStartStack(instId, task.getNodeId(), handMode);
    }

    @Override
    public void afterActionHandler(TaskActionPluginSession pluginSession, TaskActionHandlerDef def) {
    }
}

