package com.artfess.base.enums;

import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

/**
 * 堤防形式
 */
@Getter
public enum DikePattEnum {
    ONE("1", "土堤"),

    TWO("2", "砌石堤"),

    THREE("3", "土石混合堤"),

    FOUR("4", "钢筋混凝土防洪墙"),

    FIVE("5", "其他"),

            ;

    DikePattEnum(String type, String desc){
        this.type = type;
        this.desc = desc;
    }

    private String type;

    private String desc;

    public static String getType(String desc){
        if(StringUtils.isEmpty(desc)){
            return null;
        }
        DikePattEnum[] values = values();
        for (DikePattEnum state : values) {
            if (state.getDesc().equals(desc)) {
                return state.getType();
            }
        }
        return null;
    }
}
