package com.artfess.base.enums;

import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

/**
 *  测站应用分类
 */
@Getter
public enum AppTypeEnum {
    /**
     *
     */
    ONE("1", "山洪"),

    TWO("2", "水库"),

//    THREE("3", "水文"), 已改成中小河流

    THREE("3", "中小河流"),

    OTHER("4", "其他"),

    ;

    AppTypeEnum(String type, String desc){
        this.type = type;
        this.desc = desc;
    }

    private String type;

    private String desc;


    public static String getDesc(String type){
        if(StringUtils.isEmpty(type)){
            return null;
        }
        AppTypeEnum[] values = values();
        for (AppTypeEnum state : values) {
            if (state.getType().equals(type)) {
                return state.getDesc();
            }
        }
        return null;
    }
}
