package com.artfess.ljzc.welfare.dao;

import com.alibaba.fastjson.JSONObject;
import com.artfess.ljzc.welfare.model.AssetPubilcInfo;
import com.artfess.ljzc.welfare.vo.AssetPubilcInfoVo;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import com.sun.star.awt.DeviceInfo;
import org.apache.ibatis.annotations.Param;

import java.math.BigDecimal;

/**
 * 公益资产信息 Mapper 接口
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2023-11-27
 */
public interface AssetPubilcInfoDao extends BaseMapper<AssetPubilcInfo> {

    /**
    * 分页查询公益资产数据
    * @param convert2IPage
    * @param convert2Wrapper
    * @Return: com.baomidou.mybatisplus.core.metadata.IPage<com.artfess.ljzc.welfare.model.AssetPubilcInfo>
    * @Author: chens
    * @Date: 2023/12/6 11:21
    */
    IPage<AssetPubilcInfoVo> queryPubilcInfoVoPage(IPage<AssetPubilcInfo> convert2IPage, @Param(Constants.WRAPPER) QueryWrapper<AssetPubilcInfo> convert2Wrapper);

    BigDecimal bookValue(@Param("fullId") String fullId);

    JSONObject publicStatistics(@Param("fullId") String fullId);
}
