package com.artfess.ljzc.fixed.controller;


import com.alibaba.fastjson.JSON;
import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.annotation.PowerLogInfo;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.base.enums.LogType;
import com.artfess.base.enums.OperationType;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.model.CommonResult;
import com.artfess.base.util.StringUtil;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.UpdateGroup;
import com.artfess.ljzc.fixed.manager.BizAssetFixedTypeManager;
import com.artfess.ljzc.fixed.model.BizAssetFixedType;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 固定资产类型信息 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2023-11-27
 */
@Slf4j
@Api(tags = "固定资产-类型信息")
@RestController
@RequestMapping("/biz/assetFixedType/v1/")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class BizAssetFixedTypeController extends BaseController<BizAssetFixedTypeManager, BizAssetFixedType> {

    @Override
    @PostMapping("/")
    @ApiOperation("添加实体的接口")
    public CommonResult<String> create(@ApiParam(name = "model", value = "实体信息") @Validated({AddGroup.class}) @RequestBody BizAssetFixedType t) {
        String id = baseService.insertTree(t);
        if(t.getSn() == null){
            t.setSn(baseService.getNextSequence(null));
        }
        baseService.updateById(t);
        if (StringUtil.isEmpty(id)) {
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION, null);
        }
        return new CommonResult<>();
    }

    @Override
    @PutMapping("/")
    @ApiOperation("更新实体")
    public CommonResult<String> updateById(@ApiParam(name = "model", value = "实体信息") @Validated({UpdateGroup.class}) @RequestBody BizAssetFixedType t) {
        BizAssetFixedType bizAssetFixedType = baseService.get(t.getId());
        String id  = baseService.updateTree(t, bizAssetFixedType.getName());
        if (StringUtil.isEmpty(id)) {
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION, null);
        }
        return new CommonResult<>();
    }

    @PostMapping("/getTree")
    @ApiOperation("获取固定资产分类下拉树")
    @PowerLogInfo(logType = LogType.BIZ, operaionType = OperationType.QUERY, description = "获取固定资产分类下拉树")
    public CommonResult<String> getTree(@ApiParam(name = "model", value = "获取固定资产分类下拉树") @RequestBody BizAssetFixedType entity) {
        log.info("获取固定资产分类下拉树请求参数:{}", JSON.toJSONString(entity));
        List<BizAssetFixedType> list = baseService.getTree(entity);
        return CommonResult.success(list, null);
    }

}
