/*
 * @Description:
 * @Author: @liulin
 * @Date: 2023-01-30 16:21:12
 * @LastEditors: Do not edit
 * @LastEditTime: 2023-04-14 11:39:24
 */
import {mapState} from 'vuex'
import req from '@/request.js'
import utils from '@/utils.js'
import sat from '@/api/satisfaction/satisfaction'

const portal = window.context.portal
export const TableMixin = {
  data() {
    return {
      tableMaxHeight: 600,
      showMore: false,
      /* 文件上传需要变量 */
      fileList: [], // 文件上传
      accept:
        '.bmp,.jpg,.png,.tif,.gif,.pcx,.tga,.exif,.fpx,.svg,.psd,.cdr,.pcd,.dxf,.ufo,.eps,.ai,.raw,.WMF,.webp,.avif,.apng,.xls,.docx,.docm,.doc,.dotx,.pptx,.pptm,.ppt,.pdf,.xps,.potx,.txt,.xls,.xlsx,.xps,.zip,.rar,.7z',
      url: `${portal}/file/v1/uploadFileForConfig`,
      previewUrl: `${portal}/file/onlinePreviewController/v1/getFileById_`,
      header: {
        Authorization: `Bearer ${this.$store.state.login.currentUser.token}`
      },
      uploadData: {
        bizCode: '',
        bizId: '',
        bizType: ''
      },
      /* 文件上传需要变量 */
      disabledDetils: false, // 查看详情禁用,
      demandRunwaOoptionsSerch: [], // 所属跑道数据（搜索框）
      demandRunwaOoptionsForm: [], // 所属跑道数据（表单内）
      unitTreeData: [], // 责任单位选择级联数据
      // 反馈时限设置时间范围为选择当天之后时间
      pickerOptions: {
        disabledDate(time) {
          return time.getTime() < Date.now()
        }
      },
      // 选择当年及其之后
      pickerYearOptions: {
        disabledDate(time) {
          return time.getTime() < Date.now() - 8.64e7
        }
      },
      hisData: [],
      currentUpadte: [],
      statusOptions: [],
      isAdvanced: false
    }
  },
  mounted() {
    this.calcTableHeight()
    this.$root.$on('resize', () => {
      this.calcTableHeight(500)
    })
  },
  created() {
    //获取主责单位
    this.unitTreeData = JSON.parse(sessionStorage.getItem('responsibilityTree'))
  },
  methods: {
    // 获取字典值翻译
    getDictName(code, value) {
      return utils.getDictName(code, value)
    },
    /* 文件上传 --- start */
    handleUpload() {
      this.$confirm(
        '文件是否涉密？若文件涉密请通过内网邮件上传！',
        '文件上传提示',
        {
          confirmButtonText: '立即上传',
          cancelButtonText: '文件涉密,内网邮件上传',
          type: 'warning'
        }
      )
        .then(() => {
          this.$refs.upload.$el.click()
        })
        .catch(() => {
          // 存在这个值为文件涉密内网上传作为查看判断依据
          this.dialogForm.classified = '1'
          // 单独为成校晾晒设置
          this.dialogFormChilred.classified = '1'
        })
    },
    // 上传时
    handleUploadprogress() {
      this.loading = true
    },
    // 上传失败
    hanldeUploadError() {
      this.loading = false
    },
    // 上传成功之后
    beforeUpload(res, file, fileList) {
      this.loading = false
      if (res.success) {
        this.fileList = fileList
        let files = []
        fileList.forEach(item => {
          if (item.response) {
            files.push(item.response.fileId)
          } else {
            files.push(item.id)
          }
        })
        this.dialogForm.ids = files
        // 存在这个值为文件涉密内网上传作为查看判断依据
        this.dialogForm.classified = '0'
        this.$message.success('附件上传成功')
      } else {
        this.$message.error('附件上传失败')
      }
    },
    // 文件下载
    handleDownload(file) {
      let id = file.id ? file.id : file.response.fileId
      window.open(portal + `/file/v1/downloadFile?fileId=${id}`, '_blank')
    },
    // 移除之前
    beforeRemove(file, fileList) {
      return this.$confirm(`确定删除 ${file.name}？`, this.$t('common.tips'), {
        confirmButtonText: this.$t('common.confirm'),
        cancelButtonText: this.$t('common.cancel'),
        type: 'warning'
      }).then(() => {
        let id = file.id || file.response.fileId
        sat.deleteFileById(id, res => {
          if (res.state) {
            this.loading = false
            this.$message.success('附件删除成功')
            let arr = this.fileList.filter(item => {
              let fileId = item.id || item.response.fileId
              if (fileId !== id) {
                return item
              }
            })
            this.fileList = arr
            let files = []
            this.fileList.forEach(item => {
              if (item.response) {
                files.push(item.response.fileId)
              } else {
                files.push(item.id)
              }
            })
            this.dialogForm.ids = files
            return true
          } else {
            this.$message.error('附件删除失败')
            return false
          }
        })
      })
    },
    // 移除时
    handleUploadRemove() {
      this.loading = true
    },
    // 根据附件id删除附件
    handleRemove(file) {
      console.log(file)
      this.$confirm('确认删除？', this.$t('common.tips'), {
        confirmButtonText: this.$t('common.confirm'),
        cancelButtonText: this.$t('common.cancel'),
        type: 'warning'
      }).then(() => {
        let id = file.id || file.response.fileId
        sat.deleteFileById(id, res => {
          if (res.state) {
            this.$message.success('附件删除成功')
            let arr = this.fileList.filter(item => {
              let fileId = item.id || item.response.fileId
              if (fileId !== id) {
                return item
              }
            })
            this.fileList = arr
          } else {
            this.$message.error('附件删除失败')
          }
        })
      })
    },
    // 文件预览
    handlePreview(file) {
      let id = file.id ? file.id : file.response.fileId
      let type =
        file.fileType ||
        (file.extensionName ? file.extensionName : file.name.split('.')[1])
      this.$refs.filePreview.previewUrl =
        portal + `/file/onlinePreviewController/v1/getFileById_${id}`
      this.$refs.filePreview.open(type)
      // sat.getDownloadById(id, res => {})
    },
    // 图片预览
    handlePictureCardPreview(file) {
      this.$refs.imgPrivew.open(portal + `/file/v1/downloadFile?fileId=${id}`)
    },
    handleExceed(files, fileList) {
      this.$message.warning(
        `当前限制选择 3 个文件，本次选择了 ${
          files.length
        } 个文件，共选择了 ${files.length + fileList.length} 个文件`
      )
    },
    /* 文件上传 --- end */
    // 查看详情
    handleLookDetiles(row) {
      this.dialog.title = '详情'
      // 协同单位转换
      if (
        row.cooperativeUnitName &&
        typeof row.cooperativeUnitName == 'string'
      ) {
        row.cooperativeUnitName = JSON.parse(row.cooperativeUnitName) || ''
      }
      if (row.propulsiveYear) {
        row.propulsiveYear = row.propulsiveYear.toString()
      }
      if (row.demandRunway) {
        row.demandRunway = row.demandRunway.toString()
      }
      this.disabledDetils = true
      this.dialogForm = row
      this.dialogForm_ = row
      row.files &&
      row.files.length != 0 &&
      row.files.forEach(item => {
        item.name = item.fileName
      })
      this.fileList = row.files || []
      this.isTag = true
      this.isShowBtn = false
      this.activeCollapse1 = ['1', '2', '3', '4']
      this.dialog.visible = true
      // 清除表单效验
      this.$refs.form.clearValidate()
    },
    // 编辑
    handleDbClick(data) {
      this.dialog.title = '编辑'
      // 协同单位转换
      if (
        data.cooperativeUnitName &&
        typeof data.cooperativeUnitName == 'string'
      ) {
        data.cooperativeUnitName = JSON.parse(data.cooperativeUnitName) || ''
      }
      if (data.demandRunway) {
        data.demandRunway = data.demandRunway.toString()
      }
      if (data.propulsiveYear) {
        data.propulsiveYear = data.propulsiveYear.toString()
      }
      this.fileList = data.files || []
      this.disabledDetils = false
      this.edit = true
      data.files &&
      data.files.length != 0 &&
      data.files.forEach(item => {
        item.name = item.fileName
      })
      this.dialogForm = data
      this.dialog.visible = true
      // 清除表单效验
      this.$refs.form.clearValidate()
    },
    // 计算表格高度
    calcTableHeight(delay = 0) {
      // 动态计算表格的高度，自适应当前容器
      setTimeout(() => {
        if (!this.$refs.tabelRef) return
        const contentPanelHeight =
          this.$refs.tabelRef && this.$refs.tabelRef.clientHeight
        const paginationPanelHeight = this.$refs.paginationPanel ? 32 : 0
        this.tableMaxHeight = contentPanelHeight - paginationPanelHeight - 32
      }, delay || 0)
    },
    // 展开高级搜索
    advanced() {
      // this.isAdvanced = !this.isAdvanced
      this.$nextTick(() => this.calcTableHeight(200))
    }
  }
}
