import req from '@/request.js'
const portal = window.context.portal
const headers = {
    'Content-type': 'application/x-www-form-urlencoded'
}
export default {
    // 品牌榜
    getProjectBrand(data, cb) {
        req.post(portal + `/project/largeScreen/v1/queryBrandForProject?year=${data.year}&month=${data.month}`).then(res => {
            cb(res.data)
        })
    },
    // 品牌榜 月统计
    getBrandMonthDate(data, cb) {
        req.post(portal + `/project/largeScreen/v1/brandLineChart?year=${data.year}&month=${data.month}`).then(res => {
            cb(res.data)
        })
    },
    // 迭代榜
    getIteration(data, cb) {
        req.post(portal + `/project/largeScreen/v1/queryIterationForProject?year=${data.year}&month=${data.month}`).then(res => {
            cb(res.data)
        })
    },
    // 根据id查询举措列表
    getIterationList(id, cb) {
        req.post(portal + `/project/largeScreen/v1/queryIterationForProjectInfo?projectId=${id}`).then(res => {
            cb(res.data)
        })
    },
    // 竞速榜
    getProjectSpeed(data, cb) {
        req.post(portal + `/bizScoringProjectTarget/v1/query`, data).then(res => {
            cb(res.data)
        })
    },
    // 指标库
    getIndexLibraryOld(data, cb) {
        req.post(portal + `/project/largeScreen/v1/complianceRateCount?year=${data.year}&month=${data.month}`).then(res => {
            cb(res.data)
        })
    },
    getIndexLibrary(data, cb) {
        req.post(portal + `/project/largeScreen/v1/reachRateCount?year=${data.year}&month=${data.month}`).then(res => {
            cb(res.data)
        })
    },
    // 查询指标库饼图数据
    getIndexPieChartData(data, cb) {
        req.post(portal + `/project/largeScreen/v1/reachProjectRateCount?year=${data.year}&month=${data.month}`).then(res => {
            cb(res.data)
        })
    },

    // 报表指数
    getRank(data, cb) {
        req.request({
            method: 'post',
            url: portal + `/project/largeScreen/v1/indexRank`,
            data,
            headers
        }).then(res => {
            cb(res.data)
        })
    },
    // 成果榜 趋势对比
    getResultTrend(data, cb) {
        let { year, month } = data
        req.post(portal + `/project/largeScreen/v1/achievementCount?year=${year}&month=${month}`).then(res => {
            cb(res.data)
        })
    },
    // 成果 分类查询
    getResultList(data, cb) {
        req.post(portal + `/project/largeScreen/v1/achievementInfo`, data).then(res => {
            cb(res.data)
        })
    },
    // 成果榜查询详情
    getResultD(id, cb) {
        req.post(portal + `/project/largeScreen/v1/achievementFindById/${id}`).then(res => {
            cb(res.data)
        })
    },
    // 制度成果 分类查询
    getResultZD(data, cb) {
        req.post(portal + `/project/largeScreen/v1/achievementInvCount`, data).then(res => {
            cb(res.data)
        })
    },
    // 主要举措指标
    getNumIndex(cb) {
        req.get(portal + `/bizScoringProjectMeasure/v1/getNumVo`).then(res => {
            cb(res.data)
        })
    },
    // 当月计划完成总览
    getProjectFinish(cb) {
        req.get(portal + `/bizScoringProjectTarget/v1/targetAll`).then(res => {
            cb(res.data)
        })
    },
    // 主要量化目标
    getTargetIndex(cb) {
        req.get(portal + `/bizScoringProjectTarget/v1/target`).then(res => {
            cb(res.data)
        })
    },
    // 三个一批项目库
    getProjectByType(data, cb) {
        req.post(portal + `/majorProjects/municipalMajorProjectManagement/v1/queryProjectList`, data).then(res => {
            cb(res.data)
        })
    },
    // 量化目标清单
    targetList(data, cb) {
        req.request({
            method: 'post',
            url: portal + `/majorProjects/pilotQuantitativeObjectivesPush/v1/queryTargetList`,
            data,
            headers
        }).then(res => {
            cb(res.data)
        })
    },
    // 月度计划清单
    queryMonthPlanList(data, cb) {
        req.request({
            method: 'post',
            url: portal + `/majorProjects/pilotQuantitativeObjectivesPush/v1/queryMonthPlanList`,
            data,
            headers
        }).then(res => {
            cb(res.data)
        })
    },
    // 重大项目综合报表
    getReport(data, cb) {
        req.request({
            method: 'post',
            url: portal + `/bizScoringProjectSyn/v1/querySynReport`,
            data,
            headers
        }).then(res => {
            cb(res.data)
        })
    },
    // 需求热力榜
    getDemandHeatList(data, cb) {
        let { year, month } = data
        req.post(portal + `/project/largeScreen/v1/demandHeatList?year=${year}&month=${month}`).then(res => {
            cb(res.data)
        })
    },
    // 需求清单
    getDemandList(data, cb) {
        req.post(portal + '/project/largeScreen/v1/demandDetailList', data).then(res => {
            cb(res.data)
        })
    },
    // 获取作战图统计数据
    getBattleChart(data, cb) {
        let { year, month } = data
        req.post(portal + `/project/largeScreen/v1/monthPlanNum?year=${year}&month=${month}`).then(res => {
            cb(res.data)
        })
    },
    // 各个项目作战图统计
    getProjectStatistics(data, cb) {
        let { year, month } = data
        req.post(portal + `/project/largeScreen/v1/monthPlanNumForProject?year=${year}&month=${month}`).then(res => {
            cb(res.data)
        })
    },
    // 重大项目详情
    getProjectDetailById(data, cb) {
        let { year, month, projectId } = data
        req.post(portal + `/majorProjects/municipalMajorProjectManagement/v1/overAllQuery?projectId=${projectId}&year=${year}&month=${month}`).then(res => {
            cb(res.data)
        })
    },
    // 改革动态
    getNews(data, cb) {
        req.post(portal + `/fill/bizWorkNews/v1/queryCode`, data).then(res => {
            cb(res.data)
        })
    },
}