import req from '@/request.js'
const portal = window.context.portal
const headers = {
    'Content-type': 'application/x-www-form-urlencoded'
}
export default {
    // 根据id查询所有附件信息
    getFileListById(data, cb) {
        req.post(portal + `/file/v1/query`, data).then(res => {
            cb(res.data)
        })
    },
    // 根据id下载文件
    getDownloadById(id, cb) {
        req.get(portal + `/file/v1/downloadFile?fileId=${id}`).then(res => {
            cb(res.data)
        })
    },
    // 根据id删除附件
    deleteFileById(ids, cb) {
        req.post(portal + `/file/v1/remove`, ids).then(res => {
            cb(res.data)
        })
    },
    // 根据id获取已导入的数据
    getImportDataById(data, cb) {
        req.request({
            method: 'post',
            url: portal + `/biz/reformSatisfaction/districts/detailQuery`,
            data,
            headers
        }).then(res => {
            cb(res.data)
        })
    },
}
