import req from '@/request.js'

const portal = window.context.portal

// 获取快捷菜单数据
export function getSwiftMenus() {
  return req.get(portal + `/sys/sysSwiftMenu/v1/getSwiftMenus`)
}

// 新增
export function saveMenus(menuAlias) {
  return req.post(portal + `/sys/sysSwiftMenu/v1/save?menuAlias=${menuAlias}`)
}

// 删除
export function removeSwiftMenus(menuAlias) {
  return req.remove(portal + `/sys/sysSwiftMenu/v1/removeSwiftMenus?menuAlias=${menuAlias}`)
}

// 更改排序
export function updateSequence(data) {
  return req.post(portal + `/sys/sysSwiftMenu/v1/updateSequence`, data)
}


