import req from '@/request.js'

const yhxt = window.context.portal
const uc = window.context.uc
export default {
  //获取公司信息
  getCompanyInfo_1(demId) {
    return new Promise((resolve, reject) => {
      req.get(uc + `/api/org/v1/orgs/getOrgsByparentId?parentId=${demId}`).then(
        resp => {
          resolve(resp.data)
        },
        error => {
          reject(error)
        }
      )
    })
  },
  //获取公司信息
  getCompanyInfo(demId) {
    return new Promise((resolve, reject) => {
      req.get(yhxt + `/Company/v1/getTree/${demId}`).then(
        resp => {
          resolve(resp.data)
        },
        error => {
          reject(error)
        }
      )
    })
  },
  //获取路线信息管理
  getRouterManagement(data) {
    return new Promise((resolve, reject) => {
      req.post(yhxt + `/route/routemanage/v1/getJson`, data).then(
        resp => {
          resolve(resp.data)
        },
        error => {
          reject(error)
        }
      )
    })
  },
  //新增路线信息管理
  addRouterManagement(data) {
    return new Promise((resolve, reject) => {
      req.post(yhxt + `/route/routemanage/v1/save`, data).then(
        resp => {
          resolve(resp.data)
        },
        error => {
          reject(error)
        }
      )
    })
  },
  //获取路段信息管理
  getRoadManagement(data) {
    return new Promise((resolve, reject) => {
      req.post(yhxt + `/road/roadmanage/v1/getJson`, data).then(
        resp => {
          resolve(resp.data)
        },
        error => {
          reject(error)
        }
      )
    })
  },
  //新增路段信息管理
  addRoadManagement(data) {
    return new Promise((resolve, reject) => {
      req.post(yhxt + `/road/roadmanage/v1/save`, data).then(
        resp => {
          resolve(resp.data)
        },
        error => {
          reject(error)
        }
      )
    })
  },
  //获取桥梁信息管理
  getBridgeManagement(data) {
    return new Promise((resolve, reject) => {
      req.post(yhxt + `/bizBridgeInformation/v1/getJson`, data).then(
        resp => {
          resolve(resp.data)
        },
        error => {
          reject(error)
        }
      )
    })
  },
  //新增桥梁信息管理
  addBridgeManagement(data) {
    return new Promise((resolve, reject) => {
      req.post(yhxt + `/bizBridgeInformation/v1/saveBridge`, data).then(
        resp => {
          resolve(resp.data)
        },
        error => {
          reject(error)
        }
      )
    })
  },
  //获取隧道信息管理
  getTunnelManagement(data) {
    return new Promise((resolve, reject) => {
      req.post(yhxt + `/bizTunnelInformation/v1/getJson`, data).then(
        resp => {
          resolve(resp.data)
        },
        error => {
          reject(error)
        }
      )
    })
  },
  //新增隧道信息管理
  addTunnelManagement(data) {
    return new Promise((resolve, reject) => {
      req.post(yhxt + `/bizTunnelInformation/v1/saveTunnel`, data).then(
        resp => {
          resolve(resp.data)
        },
        error => {
          reject(error)
        }
      )
    })
  },
  //获取边坡信息管理
  getSideSlopeManagement(data) {
    return new Promise((resolve, reject) => {
      req.post(yhxt + `/bizSideSlopeInformation/v1/getJson`, data).then(
        resp => {
          resolve(resp.data)
        },
        error => {
          reject(error)
        }
      )
    })
  },
  //新增边坡信息管理
  addSideSlopeManagement(data) {
    return new Promise((resolve, reject) => {
      req.post(yhxt + `/bizSideSlopeInformation/v1/saveSideSlope`, data).then(
        resp => {
          resolve(resp.data)
        },
        error => {
          reject(error)
        }
      )
    })
  },
  //获取涵洞信息管理
  getCulvertManagement(data) {
    return new Promise((resolve, reject) => {
      req
        .post(
          yhxt +
            `/bizCulvertInformation/bizCulvertInformationmanager/v1/getJson`,
          data
        )
        .then(
          resp => {
            resolve(resp.data)
          },
          error => {
            reject(error)
          }
        )
    })
  },
  //新增涵洞信息管理
  addCulvertManagement(data) {
    return new Promise((resolve, reject) => {
      req
        .post(
          yhxt + `/bizCulvertInformation/bizCulvertInformationmanager/v1/save`,
          data
        )
        .then(
          resp => {
            resolve(resp.data)
          },
          error => {
            reject(error)
          }
        )
    })
  },
  //获取沿线设施信息管理
  getSideFacilitiesManagement(data) {
    return new Promise((resolve, reject) => {
      req
        .post(
          yhxt +
            `/bizRoadsideFacilities/bizRoadsideFacilitiesManager/v1/getJson`,
          data
        )
        .then(
          resp => {
            resolve(resp.data)
          },
          error => {
            reject(error)
          }
        )
    })
  },
  //新增沿线设施信息管理
  addSideFacilitiesManagement(data) {
    return new Promise((resolve, reject) => {
      req
        .post(
          yhxt + `/bizRoadsideFacilities/bizRoadsideFacilitiesManager/v1/save`,
          data
        )
        .then(
          resp => {
            resolve(resp.data)
          },
          error => {
            reject(error)
          }
        )
    })
  },
  //获取成本科目信息管理
  getCostAccountManagement(query) {
    return new Promise((resolve, reject) => {
      req
        .get(yhxt + `/bizCourseDetails/v1/get/getByParentId?pCode=${query}`)
        .then(
          resp => {
            resolve(resp)
          },
          error => {
            reject(error)
          }
        )
    })
  },
  //搜索
  searchCostAccountManagement(data) {
    return new Promise((resolve, reject) => {
      req.get(yhxt + `/bizCourseDetails/v1/getList`, data).then(
        resp => {
          resolve(resp)
        },
        error => {
          reject(error)
        }
      )
    })
  },
  //新增成本科目信息管理
  addCostAccountManagement(data) {
    return new Promise((resolve, reject) => {
      req.post(yhxt + `/bizCourseDetails/v1/save`, data).then(
        resp => {
          resolve(resp.data)
        },
        error => {
          reject(error)
        }
      )
    })
  },
  //删除成本科目信息管理
  deleteCostAccountManagement(ids) {
    return new Promise((resolve, reject) => {
      req
        .remove(yhxt + `/bizCourseDetails/v1/updateCourseDetails?ids=${ids}`)
        .then(
          resp => {
            resolve(resp.data)
          },
          error => {
            reject(error)
          }
        )
    })
  },
  //获取工程图纸信息管理
  getEngineeringManagement(data) {
    return new Promise((resolve, reject) => {
      req.post(yhxt + `/bizEngineeringDrawing/v1/getJson`, data).then(
        resp => {
          resolve(resp.data)
        },
        error => {
          reject(error)
        }
      )
    })
  },
  //新增工程图纸信息管理
  addEngineeringManagement(data) {
    return new Promise((resolve, reject) => {
      req.post(yhxt + `/bizEngineeringDrawing/v1/saveVo`, data).then(
        resp => {
          resolve(resp.data)
        },
        error => {
          reject(error)
        }
      )
    })
  },
  //获取工程图纸下附件信息管理
  getEnclosureManagement(data) {
    return new Promise((resolve, reject) => {
      req.post(yhxt + `/bizAccessory/v1/getJson`, data).then(
        resp => {
          resolve(resp.data)
        },
        error => {
          reject(error)
        }
      )
    })
  },
  //获取病害图纸下附件信息管理
  getEnclosurevirus(data) {
    return new Promise((resolve, reject) => {
      req.post(yhxt + `/bizAccessory/v1/getJson`, data).then(
        resp => {
          resolve(resp.data)
        },
        error => {
          reject(error)
        }
      )
    })
  },
  //获取养护合同下附件信息管理
  getcuring(data) {
    return new Promise((resolve, reject) => {
      req.post(yhxt + `/bizAccessory/v1/getJson`, data).then(
        resp => {
          resolve(resp.data)
        },
        error => {
          reject(error)
        }
      )
    })
  },
  //删除附件管理信息管理
  deleteEnclosureManagement(ids) {
    return new Promise((resolve, reject) => {
      req.remove(yhxt + `/bizAccessory/v1/updateAccessory?ids=${ids}`).then(
        resp => {
          resolve(resp.data)
        },
        error => {
          reject(error)
        }
      )
    })
  },
  //新增工程图纸信息管理
  addCarInfoManagement(data) {
    return new Promise((resolve, reject) => {
      req.post(yhxt + `/bizVehicle/v1/save`, data).then(
        resp => {
          resolve(resp.data)
        },
        error => {
          reject(error)
        }
      )
    })
  },
  //获取工程图纸下附件信息管理
  getCarInfoManagement(data) {
    return new Promise((resolve, reject) => {
      req.post(yhxt + `/bizVehicle/v1/list`, data).then(
        resp => {
          resolve(resp.data)
        },
        error => {
          reject(error)
        }
      )
    })
  },
  //获取桥梁专项检查
  getSpecialProjectInspectionData(data) {
    return new Promise((resolve, reject) => {
      req.post(yhxt + `/bizBridgeSpecialCheck/v1/getJson`, data).then(
        resp => {
          resolve(resp.data)
        },
        error => {
          reject(error)
        }
      )
    })
  },
  //新增桥梁专项检查
  addSpecialProjectInspectionData(data) {
    return new Promise((resolve, reject) => {
      req
        .post(yhxt + `/bizBridgeSpecialCheck/v1/saveVo`, data)
        .then(
          resp => {
            resolve(resp.data)
          },
          error => {
            reject(error)
          }
        )
    })
  },
  //获取隧道专项检查
  getSpecialInspectionTunnelData(data) {
    return new Promise((resolve, reject) => {
      req.post(yhxt + `/bizTunnelSpecialCheck/v1/getJson`, data).then(
        resp => {
          resolve(resp.data)
        },
        error => {
          reject(error)
        }
      )
    })
  },
  //新增隧道专项检查
  addSpecialInspectionTunnelData(data) {
    return new Promise((resolve, reject) => {
      req.post(yhxt + `/bizTunnelSpecialCheck/v1/saveVo`, data).then(
        resp => {
          resolve(resp.data)
        },
        error => {
          reject(error)
        }
      )
    })
  },
  //获取MQI数据检查
  getMQIData(data) {
    return new Promise((resolve, reject) => {
      req.post(yhxt + `/bizMqiCheckData/v1/getJson`, data).then(
        resp => {
          resolve(resp.data)
        },
        error => {
          reject(error)
        }
      )
    })
  },
  //新增MQI数据检查
  addMQIData(data) {
    return new Promise((resolve, reject) => {
      req.post(yhxt + `/bizMqiCheckData/v1/save`, data).then(
        resp => {
          resolve(resp.data)
        },
        error => {
          reject(error)
        }
      )
    })
  },
  //根据id查询mqi数据
  getByIdMQIData(id) {
    return new Promise((resolve, reject) => {
      req.get(yhxt + `/bizMqiCheckData/v1/get/${id}`).then(
        resp => {
          resolve(resp.data)
        },
        error => {
          reject(error)
        }
      )
    })
  },
  //获取项目管理数据
  getProjectManagementData(data) {
    return new Promise((resolve, reject) => {
      req.post(yhxt + `/bizEngineeringProject/v1/getJson`, data).then(
        resp => {
          resolve(resp.data)
        },
        error => {
          reject(error)
        }
      )
    })
  },
  //新增项目管理数据
  addProjectManagementData(data) {
    return new Promise((resolve, reject) => {
      req
        .post(yhxt + `/bizEngineeringProject/v1/saveVo`, data)
        .then(
          resp => {
            resolve(resp.data)
          },
          error => {
            reject(error)
          }
        )
    })
  },
  //新建病害-保存
  addDiseaseSave(data) {
    return new Promise((resolve, reject) => {
      req.post(yhxt + `/disease/v1/save`, data).then(
        resp => {
          resolve(resp.data)
        },
        error => {
          reject(error)
        }
      )
    })
  },
  //获取合同管理数据
  getContractInfo(data) {
    return new Promise((resolve, reject) => {
      req.post(yhxt + `/bizProjectContract/v1/getJson`, data).then(
        resp => {
          resolve(resp.data)
        },
        error => {
          reject(error)
        }
      )
    })
  },
  //新增合同管理数据
  addContractInfo(data) {
    return new Promise((resolve, reject) => {
      req.post(yhxt + `/bizProjectContract/v1/save`, data).then(
        resp => {
          resolve(resp.data)
        },
        error => {
          reject(error)
        }
      )
    })
  },
  //新增养护合同
  saveContractInfo(data) {
    return new Promise((resolve, reject) => {
      req.post(yhxt +`/contract/v1/saveVo`, data).then(
        resp => {
          resolve(resp.data)
        },
        error => {
          reject(error)
        }
      )
    })
  },
  //根据id查询合同明显数据
  getByIdContractInfoData(id) {
    return new Promise((resolve, reject) => {
      req.get(yhxt + `/bizProjectContract/v1/get/${id}`).then(
        resp => {
          resolve(resp.data)
        },
        error => {
          reject(error)
        }
      )
    })
  },
  //获取开工管理数据
  getStartInfo(data) {
    return new Promise((resolve, reject) => {
      req.post(yhxt + `/bizProjectBeginApplyFor/v1/getJson`, data).then(
        resp => {
          resolve(resp.data)
        },
        error => {
          reject(error)
        }
      )
    })
  },
  //新增开工管理数据
  addStartInfo(data) {
    return new Promise((resolve, reject) => {
      req
        .post(
          yhxt + `/bizProjectBeginApplyFor/v1/saveVo`,
          data
        )
        .then(
          resp => {
            resolve(resp.data)
          },
          error => {
            reject(error)
          }
        )
    })
  },
  //审核开工信息数据
  examineData(data) {
    return new Promise((resolve, reject) => {
      req
        .post(
          yhxt + `/bizProjectBeginApplyFor/v1/savebizProjectBeginApplyForState`,
          data
        )
        .then(
          resp => {
            resolve(resp.data)
          },
          error => {
            reject(error)
          }
        )
    })
  },
  //获取巡检记录数据
  getPatrolRecord(data) {
    return new Promise((resolve, reject) => {
      req
        .post(yhxt + `/bizInspectionRecordsOfSupervision/v1/getJson`, data)
        .then(
          resp => {
            resolve(resp.data)
          },
          error => {
            reject(error)
          }
        )
    })
  },
  //新增巡检记录数据
  addPatrolRecord(data) {
    return new Promise((resolve, reject) => {
      req
        .post(
          yhxt +
            `/bizInspectionRecordsOfSupervision/v1/saveVo`,
          data
        )
        .then(
          resp => {
            resolve(resp.data)
          },
          error => {
            reject(error)
          }
        )
    })
  },
  //获取安全环保数据
  getSafetyEnvironmentalProtection(data) {
    return new Promise((resolve, reject) => {
      req
        .post(yhxt + `/bizProjectSafetyEnvironmentalRecord/v1/getJson`, data)
        .then(
          resp => {
            resolve(resp.data)
          },
          error => {
            reject(error)
          }
        )
    })
  },
  //新增安全环保数据
  addSafetyEnvironmentalProtection(data) {
    return new Promise((resolve, reject) => {
      req
        .post(
          yhxt +
            `/bizProjectSafetyEnvironmentalRecord/v1/saveVo`,
          data
        )
        .then(
          resp => {
            resolve(resp.data)
          },
          error => {
            reject(error)
          }
        )
    })
  },
  //获取项目日志数据
  getProjectLog(data) {
    return new Promise((resolve, reject) => {
      req.post(yhxt + `/bizConstructionLog/v1/getJson`, data).then(
        resp => {
          resolve(resp.data)
        },
        error => {
          reject(error)
        }
      )
    })
  },
  //新增项目日志数据
  addProjectLog(data) {
    return new Promise((resolve, reject) => {
      req.post(yhxt + `/bizConstructionLog/v1/saveVo`, data).then(
        resp => {
          resolve(resp.data)
        },
        error => {
          reject(error)
        }
      )
    })
  },
  //获取招投标信息数据
  getBiddingInfo(data) {
    return new Promise((resolve, reject) => {
      req.post(yhxt + `/bizProjectBidding/v1/getJson`, data).then(
        resp => {
          resolve(resp.data)
        },
        error => {
          reject(error)
        }
      )
    })
  },
  //新招投标信息数据
  addBiddingInfo(data) {
    return new Promise((resolve, reject) => {
      req
        .post(
          yhxt + `/bizProjectBidding/v1/saveVo`,
          data
        )
        .then(
          resp => {
            resolve(resp.data)
          },
          error => {
            reject(error)
          }
        )
    })
  },
  //获取项目周报月报数据
  getProjectWeekMouth(data) {
    return new Promise((resolve, reject) => {
      req.post(yhxt + `/bizProjectWeeklyMonthlyReport/v1/getJson`, data).then(
        resp => {
          resolve(resp.data)
        },
        error => {
          reject(error)
        }
      )
    })
  },
  //新增项目周报月报数据
  addProjectWeekMouth(data) {
    return new Promise((resolve, reject) => {
      req
        .post(
          yhxt + `/bizProjectWeeklyMonthlyReport/v1/saveVo`,
          data
        )
        .then(
          resp => {
            resolve(resp.data)
          },
          error => {
            reject(error)
          }
        )
    })
  },
  //获取质量管理数据
  getQualityManagement(data) {
    return new Promise((resolve, reject) => {
      req.post(yhxt + `/bizProjectManageQuality/v1/getJson`, data).then(
        resp => {
          resolve(resp.data)
        },
        error => {
          reject(error)
        }
      )
    })
  },
  //新增质量管理数据
  addQualityManagement(data) {
    return new Promise((resolve, reject) => {
      req
        .post(
          yhxt + `/bizProjectManageQuality/v1/saveVo`,
          data
        )
        .then(
          resp => {
            resolve(resp.data)
          },
          error => {
            reject(error)
          }
        )
    })
  },
  //获取质检整改和质检复查数据
  getQualityRectification(data) {
    return new Promise((resolve, reject) => {
      req.post(yhxt + `/bizProjectManageQualityChange/v1/getJsonVo`, data).then(
        resp => {
          resolve(resp.data)
        },
        error => {
          reject(error)
        }
      )
    })
  },
  //新增质检整改数据
  addQualityRectification(data) {
    return new Promise((resolve, reject) => {
      req
        .post(
          yhxt +
            `/bizProjectManageQualityChange/v1/saveVo`,
          data
        )
        .then(
          resp => {
            resolve(resp.data)
          },
          error => {
            reject(error)
          }
        )
    })
  },
  //获取民工信息数据
  getMigrantWorksManagement(data) {
    return new Promise((resolve, reject) => {
      req
        .post(
          yhxt +
            `/bizMigrantWorkersInformation/v1/getJson

      `,
          data
        )
        .then(
          resp => {
            resolve(resp.data)
          },
          error => {
            reject(error)
          }
        )
    })
  },
  //新增民工信息数据
  addMigrantWorksManagement(data) {
    return new Promise((resolve, reject) => {
      req
        .post(
          yhxt +
            `/bizMigrantWorkersInformation/v1/saveVo`,
          data
        )
        .then(
          resp => {
            resolve(resp.data)
          },
          error => {
            reject(error)
          }
        )
    })
  },
  //获取专项工程下附件信息管理
  getSpecialProjectManagement(id, data) {
    return new Promise((resolve, reject) => {
      req
        .post(yhxt + `/bizEngineeringAccessories/v1/getJson?type=${id}`, data)
        .then(
          resp => {
            resolve(resp.data)
          },
          error => {
            reject(error)
          }
        )
    })
  },
  //删除附件管理信息管理
  deleteSpecialProjectManagement(ids) {
    return new Promise((resolve, reject) => {
      req
        .remove(
          yhxt +
            `/bizEngineeringAccessories/v1/updateEngineeringAccessories?ids=${ids}`
        )
        .then(
          resp => {
            resolve(resp.data)
          },
          error => {
            reject(error)
          }
        )
    })
  },
  //删除合同明细管理
  deleteContractDetailInfo(ids) {
    return new Promise((resolve, reject) => {
      req
        .remove(
          yhxt +
            `/bizProjectContractDetails/v1/updateContractDetails?ids=${ids}`
        )
        .then(
          resp => {
            resolve(resp.data)
          },
          error => {
            reject(error)
          }
        )
    })
  },
  //获取日常养护合同
  getDailyMaintenanceontract(query) {
    return new Promise((resolve, reject) => {
      req
        .post(yhxt + `/contract/v1/getJson`, query)
        .then(
          resp => {
            resolve(resp.data)
          },
          error => {
            reject(error)
          }
        )
    })
  },
}
