import req from '@/request.js'
const portal = window.context.portal
const headers = {
    'Content-type': 'application/x-www-form-urlencoded'
}
export default {
    //分页查询
    queryData(data, cb) {
        req.post(portal + `/biz/stock/stockInfo/v1/queryPageStockInfoAuthority`, data).then(res => {
            cb(res.data)
        })
    },
    //添加
    addData(data, cb) {
        req.post(portal + `/biz/stock/stockInfo/v1/insertStockInfo`, data).then(res => {
            cb(res.data)
        })
    },
    //编辑
    editData(data, cb) {
        req.post(portal + `/biz/stock/stockInfo/v1/updateStockInfo`, data).then(res => {
            cb(res.data)
        })
    },
    //删除
    deleteData(ids, cb) {
        req.post(portal + `/biz/stock/stockInfo/v1/deleteBachStockInfo?ids=${ids}`).then(res => {
            cb(res.data)
        })
    },
    //根据id查询
    detailsData(id, cb) {
        req.post(portal + `/biz/stock/stockInfo/v1/findById?id=${id}`).then(res => {
            cb(res.data)
        })
    },
    //审核股权资产入库
    processData(ids,status,msg, cb) {
        req.post(portal + `/biz/stock/stockInfo/v1/auditStock?ids=${ids}&status=${status}&msg=${msg}`).then(res => {
            cb(res.data)
        })
    },
    //获取组织树
    getOrgTree(data, cb) {
        req.post(portal + `/api/org/v1/orgs/findByParamsOrgTree`, data).then(res => {
            cb(res.data)
        })
    },
     //当前用户下级组织树
     getUserOrgTree(id, cb) {
        req.get(portal + `/api/org/v1/orgTree/children/${id}`).then(res => {
            cb(res.data)
        })
    },
}